/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.core;

import com.google.typography.font.sfntly.data.FontData;
import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.math.FontMath;
import com.google.typography.font.sfntly.table.core.CMap;
import com.google.typography.font.sfntly.table.core.CMapTable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public final class CMapFormat4
extends CMap {
    private final int segCount;
    private final int glyphIdArrayOffset;

    protected CMapFormat4(ReadableFontData data, CMapTable.CMapId cmapId) {
        super(data, CMap.CMapFormat.Format4.value, cmapId);
        this.segCount = this.data.readUShort(CMapTable.Offset.format4SegCountX2.offset) / 2;
        this.glyphIdArrayOffset = CMapFormat4.glyphIdArrayOffset(this.segCount);
    }

    @Override
    public int glyphId(int character) {
        int segment = this.data.searchUShort(CMapFormat4.startCodeOffset(this.segCount), FontData.DataSize.USHORT.size(), CMapTable.Offset.format4EndCount.offset, FontData.DataSize.USHORT.size(), this.segCount, character);
        if (segment == -1) {
            return 0;
        }
        int startCode = this.startCode(segment);
        return this.retrieveGlyphId(segment, startCode, character);
    }

    public int retrieveGlyphId(int segment, int startCode, int character) {
        if (character < startCode) {
            return 0;
        }
        int idRangeOffset = this.idRangeOffset(segment);
        if (idRangeOffset == 0) {
            return (character + this.idDelta(segment)) % 65536;
        }
        return this.data.readUShort(idRangeOffset + this.idRangeOffsetLocation(segment) + 2 * (character - startCode));
    }

    public int getSegCount() {
        return this.segCount;
    }

    public int startCode(int segment) {
        this.isValidIndex(segment);
        return CMapFormat4.startCode(this.data, this.segCount, segment);
    }

    private static int length(ReadableFontData data) {
        int length = data.readUShort(CMapTable.Offset.format4Length.offset);
        return length;
    }

    private static int segCount(ReadableFontData data) {
        int segCount = data.readUShort(CMapTable.Offset.format4SegCountX2.offset) / 2;
        return segCount;
    }

    private static int startCode(ReadableFontData data, int segCount, int index) {
        int startCode = data.readUShort(CMapFormat4.startCodeOffset(segCount) + index * FontData.DataSize.USHORT.size());
        return startCode;
    }

    private static int startCodeOffset(int segCount) {
        int startCodeOffset = CMapTable.Offset.format4EndCount.offset + FontData.DataSize.USHORT.size() + segCount * FontData.DataSize.USHORT.size();
        return startCodeOffset;
    }

    private static int endCode(ReadableFontData data, int segCount, int index) {
        int endCode = data.readUShort(CMapTable.Offset.format4EndCount.offset + index * FontData.DataSize.USHORT.size());
        return endCode;
    }

    private static int idDelta(ReadableFontData data, int segCount, int index) {
        int idDelta = data.readShort(CMapFormat4.idDeltaOffset(segCount) + index * FontData.DataSize.SHORT.size());
        return idDelta;
    }

    private static int idDeltaOffset(int segCount) {
        int idDeltaOffset = CMapTable.Offset.format4EndCount.offset + (2 * segCount + 1) * FontData.DataSize.USHORT.size();
        return idDeltaOffset;
    }

    private static int idRangeOffset(ReadableFontData data, int segCount, int index) {
        int idRangeOffset = data.readUShort(CMapFormat4.idRangeOffsetOffset(segCount) + index * FontData.DataSize.USHORT.size());
        return idRangeOffset;
    }

    private static int idRangeOffsetOffset(int segCount) {
        int idRangeOffsetOffset = CMapTable.Offset.format4EndCount.offset + (2 * segCount + 1) * FontData.DataSize.USHORT.size() + segCount * FontData.DataSize.SHORT.size();
        return idRangeOffsetOffset;
    }

    private static int glyphIdArrayOffset(int segCount) {
        int glyphIdArrayOffset = CMapTable.Offset.format4EndCount.offset + (3 * segCount + 1) * FontData.DataSize.USHORT.size() + segCount * FontData.DataSize.SHORT.size();
        return glyphIdArrayOffset;
    }

    public int endCode(int segment) {
        this.isValidIndex(segment);
        return CMapFormat4.endCode(this.data, this.segCount, segment);
    }

    private void isValidIndex(int segment) {
        if (segment < 0 || segment >= this.segCount) {
            throw new IllegalArgumentException();
        }
    }

    public int idDelta(int segment) {
        this.isValidIndex(segment);
        return CMapFormat4.idDelta(this.data, this.segCount, segment);
    }

    public int idRangeOffset(int segment) {
        this.isValidIndex(segment);
        return this.data.readUShort(this.idRangeOffsetLocation(segment));
    }

    public int idRangeOffsetLocation(int segment) {
        this.isValidIndex(segment);
        return CMapFormat4.idRangeOffsetOffset(this.segCount) + segment * FontData.DataSize.USHORT.size();
    }

    private int glyphIdArray(int index) {
        return this.data.readUShort(this.glyphIdArrayOffset + index * FontData.DataSize.USHORT.size());
    }

    @Override
    public int language() {
        return this.data.readUShort(CMapTable.Offset.format4Language.offset);
    }

    @Override
    public Iterator<Integer> iterator() {
        return new CharacterIterator();
    }

    public static class Builder
    extends CMap.Builder<CMapFormat4> {
        private List<Segment> segments;
        private List<Integer> glyphIdArray;

        protected Builder(WritableFontData data, int offset, CMapTable.CMapId cmapId) {
            super(data == null ? null : data.slice(offset, data.readUShort(offset + CMapTable.Offset.format4Length.offset)), CMap.CMapFormat.Format4, cmapId);
        }

        protected Builder(ReadableFontData data, int offset, CMapTable.CMapId cmapId) {
            super(data == null ? null : data.slice(offset, data.readUShort(offset + CMapTable.Offset.format4Length.offset)), CMap.CMapFormat.Format4, cmapId);
        }

        private void initialize(ReadableFontData data) {
            this.segments = new ArrayList<Segment>();
            this.glyphIdArray = new ArrayList<Integer>();
            if (data == null || data.length() == 0) {
                return;
            }
            int segCount = CMapFormat4.segCount(data);
            for (int index = 0; index < segCount; ++index) {
                Segment segment = new Segment();
                segment.setStartCount(CMapFormat4.startCode(data, segCount, index));
                segment.setEndCount(CMapFormat4.endCode(data, segCount, index));
                segment.setIdDelta(CMapFormat4.idDelta(data, segCount, index));
                segment.setIdRangeOffset(CMapFormat4.idRangeOffset(data, segCount, index));
                this.segments.add(segment);
            }
            int glyphIdArrayLength = CMapFormat4.length(data) - CMapFormat4.glyphIdArrayOffset(segCount);
            for (int index = 0; index < glyphIdArrayLength; index += FontData.DataSize.USHORT.size()) {
                this.glyphIdArray.add(data.readUShort(index + CMapFormat4.glyphIdArrayOffset(segCount)));
            }
        }

        public List<Segment> getSegments() {
            if (this.segments == null) {
                this.initialize(this.internalReadData());
                this.setModelChanged();
            }
            return this.segments;
        }

        public void setSegments(List<Segment> segments) {
            this.segments = Segment.deepCopy(segments);
            this.setModelChanged();
        }

        public List<Integer> getGlyphIdArray() {
            if (this.glyphIdArray == null) {
                this.initialize(this.internalReadData());
                this.setModelChanged();
            }
            return this.glyphIdArray;
        }

        public void setGlyphIdArray(List<Integer> glyphIdArray) {
            this.glyphIdArray = new ArrayList<Integer>(glyphIdArray);
            this.setModelChanged();
        }

        @Override
        protected CMapFormat4 subBuildTable(ReadableFontData data) {
            return new CMapFormat4(data, this.cmapId());
        }

        @Override
        protected void subDataSet() {
            this.segments = null;
            this.glyphIdArray = null;
            super.setModelChanged(false);
        }

        @Override
        protected int subDataSizeToSerialize() {
            if (!this.modelChanged()) {
                return super.subDataSizeToSerialize();
            }
            int size = CMapTable.Offset.format4FixedSize.offset + this.segments.size() * (3 * FontData.DataSize.USHORT.size() + FontData.DataSize.SHORT.size()) + this.glyphIdArray.size() * FontData.DataSize.USHORT.size();
            return size;
        }

        @Override
        protected boolean subReadyToSerialize() {
            if (!this.modelChanged()) {
                return super.subReadyToSerialize();
            }
            return this.segments != null;
        }

        @Override
        protected int subSerialize(WritableFontData newData) {
            int i;
            if (!this.modelChanged()) {
                return super.subSerialize(newData);
            }
            int index = 0;
            index += newData.writeUShort(index, CMap.CMapFormat.Format4.value());
            index += FontData.DataSize.USHORT.size();
            index += newData.writeUShort(index, this.language());
            int segCount = this.segments.size();
            index += newData.writeUShort(index, segCount * 2);
            int log2SegCount = FontMath.log2(this.segments.size());
            int searchRange = 1 << log2SegCount + 1;
            index += newData.writeUShort(index, searchRange);
            int entrySelector = log2SegCount;
            index += newData.writeUShort(index, entrySelector);
            int rangeShift = 2 * segCount - searchRange;
            index += newData.writeUShort(index, rangeShift);
            for (i = 0; i < segCount; ++i) {
                index += newData.writeUShort(index, this.segments.get(i).getEndCount());
            }
            index += FontData.DataSize.USHORT.size();
            for (i = 0; i < segCount; ++i) {
                index += newData.writeUShort(index, this.segments.get(i).getStartCount());
            }
            for (i = 0; i < segCount; ++i) {
                index += newData.writeShort(index, this.segments.get(i).getIdDelta());
            }
            for (i = 0; i < segCount; ++i) {
                index += newData.writeUShort(index, this.segments.get(i).getIdRangeOffset());
            }
            for (i = 0; i < this.glyphIdArray.size(); ++i) {
                index += newData.writeUShort(index, this.glyphIdArray.get(i));
            }
            newData.writeUShort(CMapTable.Offset.format4Length.offset, index);
            return index;
        }

        public static class Segment {
            private int startCount;
            private int endCount;
            private int idDelta;
            private int idRangeOffset;

            public static List<Segment> deepCopy(List<Segment> original) {
                ArrayList<Segment> list = new ArrayList<Segment>(original.size());
                for (Segment segment : original) {
                    list.add(new Segment(segment));
                }
                return list;
            }

            public Segment() {
            }

            public Segment(Segment other) {
                this(other.startCount, other.endCount, other.idDelta, other.idRangeOffset);
            }

            public Segment(int startCount, int endCount, int idDelta, int idRangeOffset) {
                this.startCount = startCount;
                this.endCount = endCount;
                this.idDelta = idDelta;
                this.idRangeOffset = idRangeOffset;
            }

            public int getStartCount() {
                return this.startCount;
            }

            public void setStartCount(int startCount) {
                this.startCount = startCount;
            }

            public int getEndCount() {
                return this.endCount;
            }

            public void setEndCount(int endCount) {
                this.endCount = endCount;
            }

            public int getIdDelta() {
                return this.idDelta;
            }

            public void setIdDelta(int idDelta) {
                this.idDelta = idDelta;
            }

            public int getIdRangeOffset() {
                return this.idRangeOffset;
            }

            public void setIdRangeOffset(int idRangeOffset) {
                this.idRangeOffset = idRangeOffset;
            }

            public String toString() {
                return String.format("[0x%04x - 0x%04x, delta = 0x%04x, rangeOffset = 0x%04x]", this.startCount, this.endCount, this.idDelta, this.idRangeOffset);
            }
        }
    }

    private class CharacterIterator
    implements Iterator<Integer> {
        private int segmentIndex = 0;
        private int firstCharInSegment = -1;
        private int lastCharInSegment;
        private int nextChar;
        private boolean nextCharSet;

        private CharacterIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.nextCharSet) {
                return true;
            }
            while (this.segmentIndex < CMapFormat4.this.segCount) {
                if (this.firstCharInSegment < 0) {
                    this.firstCharInSegment = CMapFormat4.this.startCode(this.segmentIndex);
                    this.lastCharInSegment = CMapFormat4.this.endCode(this.segmentIndex);
                    this.nextChar = this.firstCharInSegment;
                    this.nextCharSet = true;
                    return true;
                }
                if (this.nextChar < this.lastCharInSegment) {
                    ++this.nextChar;
                    this.nextCharSet = true;
                    return true;
                }
                ++this.segmentIndex;
                this.firstCharInSegment = -1;
            }
            return false;
        }

        @Override
        public Integer next() {
            if (!this.nextCharSet && !this.hasNext()) {
                throw new NoSuchElementException("No more characters to iterate.");
            }
            this.nextCharSet = false;
            return this.nextChar;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Unable to remove a character from cmap.");
        }
    }
}

