/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.conversion.eot;

import com.google.typography.font.tools.conversion.eot.BitIOWriter;
import com.google.typography.font.tools.conversion.eot.HuffmanEncoder;

public class LzcompCompress {
    private static final int MAX_2BYTE_DIST = 512;
    private static final int DIST_MIN = 1;
    private static final int DIST_WIDTH = 3;
    private static final int LEN_MIN = 2;
    private static final int LEN_MIN3 = 3;
    private static final int LEN_WIDTH = 3;
    private static final int BIT_RANGE = 2;
    private static final int PRELOAD_SIZE = 7168;
    private static final int DEFAULT_MAX_COPY_DIST = Integer.MAX_VALUE;
    private BitIOWriter bits;
    private boolean usingRunLength = false;
    private int length1;
    private int maxCopyDist = Integer.MAX_VALUE;
    private HuffmanEncoder distEncoder;
    private HuffmanEncoder lenEncoder;
    private HuffmanEncoder symEncoder;
    private int numDistRanges;
    private int distMax;
    private int dup2;
    private int dup4;
    private int dup6;
    private int numSyms;
    private byte[] buf;
    private HashNode[] hashTable;

    private LzcompCompress() {
        this.bits = new BitIOWriter();
    }

    private void write(byte[] dataIn) {
        this.bits.writeBit(this.usingRunLength);
        this.length1 = dataIn.length;
        this.setDistRange(this.length1);
        this.distEncoder = new HuffmanEncoder(this.bits, 8);
        this.lenEncoder = new HuffmanEncoder(this.bits, 8);
        this.symEncoder = new HuffmanEncoder(this.bits, this.numSyms);
        this.buf = new byte[7168 + this.length1];
        System.arraycopy(dataIn, 0, this.buf, 7168, this.length1);
        this.encode();
        this.bits.flush();
    }

    void setDistRange(int length) {
        this.numDistRanges = 1;
        this.distMax = 1 + (1 << 3 * this.numDistRanges) - 1;
        while (this.distMax < this.length1) {
            ++this.numDistRanges;
            this.distMax = 1 + (1 << 3 * this.numDistRanges) - 1;
        }
        this.dup2 = 256 + 8 * this.numDistRanges;
        this.dup4 = this.dup2 + 1;
        this.dup6 = this.dup4 + 1;
        this.numSyms = this.dup6 + 1;
    }

    private void encode() {
        int maxIndex = this.length1 + 7168;
        this.initializeModel();
        this.bits.writeValue(this.length1, 24);
        int limit = this.length1 + 7168;
        int[] dist = new int[1];
        int i = 7168;
        while (i < limit) {
            int len;
            int here = i;
            if ((len = this.makeCopyDecision(i++, dist)) > 0) {
                int distRanges = this.getNumDistRanges(dist[0]);
                this.encodeLength(len, dist[0], distRanges);
                this.encodeDistance2(dist[0], distRanges);
                for (int j = 1; j < len; ++j) {
                    this.updateModel(i++);
                }
                continue;
            }
            byte c = this.buf[here];
            if (here >= 2 && c == this.buf[here - 2]) {
                this.symEncoder.writeSymbol(this.dup2);
                continue;
            }
            if (here >= 4 && c == this.buf[here - 4]) {
                this.symEncoder.writeSymbol(this.dup4);
                continue;
            }
            if (here >= 6 && c == this.buf[here - 6]) {
                this.symEncoder.writeSymbol(this.dup6);
                continue;
            }
            this.symEncoder.writeSymbol(this.buf[here] & 0xFF);
        }
    }

    void initializeModel() {
        this.hashTable = new HashNode[65536];
        int i = 0;
        for (int k = 0; k < 32; ++k) {
            for (int j = 0; j < 96; ++j) {
                this.buf[i] = (byte)k;
                this.updateModel(i++);
                this.buf[i] = (byte)j;
                this.updateModel(i++);
            }
        }
        for (int j = 0; i < 7168 && j < 256; ++j) {
            this.buf[i] = (byte)j;
            this.updateModel(i++);
            this.buf[i] = (byte)j;
            this.updateModel(i++);
            this.buf[i] = (byte)j;
            this.updateModel(i++);
            this.buf[i] = (byte)j;
            this.updateModel(i++);
        }
    }

    private int makeCopyDecision(int index, int[] bestDist) {
        int[] dist1 = new int[1];
        int[] gain1 = new int[1];
        int[] costPerByte1 = new int[1];
        int here = index;
        int len1 = this.findMatch(index, dist1, gain1, costPerByte1);
        this.updateModel(index++);
        if (gain1[0] > 0) {
            int distBitCount;
            int distRanges;
            int lenBitCount;
            int cost1B;
            int cost1A;
            int[] costPerByte3;
            int[] gain3;
            int[] dist3;
            int len3;
            int[] dist2 = new int[1];
            int[] gain2 = new int[1];
            int[] costPerByte2 = new int[1];
            int len2 = this.findMatch(index, dist2, gain2, costPerByte2);
            int symbolCost = this.symEncoder.writeSymbolCost(this.buf[here] & 0xFF);
            if (gain2[0] >= gain1[0] && costPerByte1[0] > (costPerByte2[0] * len2 + symbolCost) / (len2 + 1)) {
                len1 = 0;
            } else if (len1 > 3 && (len2 = this.findMatch(here + len1, dist2, gain2, costPerByte2)) >= 2 && (len3 = this.findMatch(here + len1 - 1, dist3 = new int[1], gain3 = new int[1], costPerByte3 = new int[1])) > len2 && costPerByte3[0] < costPerByte2[0] && (cost1A = costPerByte1[0] * len1 + costPerByte2[0] * len2) / (len1 + len2) > (cost1B = (lenBitCount = this.encodeLengthCost(len1 - 1, dist1[0] + 1, distRanges = this.getNumDistRanges(dist1[0] + 1))) + (distBitCount = this.encodeDistance2Cost(dist1[0] + 1, distRanges)) + costPerByte3[0] * len3) / (len1 - 1 + len3)) {
                --len1;
                dist1[0] = dist1[0] + 1;
            }
            if (len1 == 2) {
                int dup2Cost;
                if (here >= 2 && this.buf[here] == this.buf[here - 2]) {
                    int dup2Cost2 = this.symEncoder.writeSymbolCost(this.dup2);
                    if (costPerByte1[0] * 2 > dup2Cost2 + this.symEncoder.writeSymbolCost(this.buf[here + 1] & 0xFF)) {
                        len1 = 0;
                    }
                } else if (here >= 1 && here + 1 < this.buf.length && this.buf[here + 1] == this.buf[here - 1] && costPerByte1[0] * 2 > symbolCost + (dup2Cost = this.symEncoder.writeSymbolCost(this.dup2))) {
                    len1 = 0;
                }
            }
        }
        bestDist[0] = dist1[0];
        return len1;
    }

    int findMatch(int index, int[] distOut, int[] gainOut, int[] costPerByteOut) {
        int maxCostCacheLength = 32;
        int[] literalCostCache = new int[33];
        int maxIndexMinusIndex = this.buf.length - index;
        int bestLength = 0;
        int bestDist = 0;
        int bestGain = 0;
        int bestCopyCost = 0;
        int maxComputedLength = 0;
        if (maxIndexMinusIndex > 1) {
            int pos = (this.buf[index] & 0xFF) << 8 | this.buf[index + 1] & 0xFF;
            HashNode prevNode = null;
            int hNodeCount = 0;
            HashNode hNode = this.hashTable[pos];
            while (hNode != null) {
                int i = hNode.index;
                int dist = index - i;
                if (++hNodeCount > 256 || dist > this.maxCopyDist) {
                    if (this.hashTable[pos] == hNode) {
                        this.hashTable[pos] = null;
                        break;
                    }
                    prevNode.next = null;
                    break;
                }
                int maxLen = index - i;
                if (maxIndexMinusIndex < maxLen) {
                    maxLen = maxIndexMinusIndex;
                }
                if (maxLen >= 2) {
                    i += 2;
                    int length = 2;
                    for (length = 2; length < maxLen && this.buf[i] == this.buf[index + length]; ++length) {
                        ++i;
                    }
                    if (length >= 2 && (dist = dist - length + 1) <= this.distMax && (length != 2 || dist < 512) && (length > bestLength || dist <= bestDist || length > bestLength - 2 && (dist <= bestDist << 3 || length >= bestLength && dist <= bestDist << 4))) {
                        int gain;
                        int distRanges;
                        int copyCost;
                        int literalCost = 0;
                        if (length > maxComputedLength) {
                            int limit = length;
                            if (limit > 32) {
                                limit = 32;
                            }
                            for (i = maxComputedLength; i < limit; ++i) {
                                byte c = this.buf[index + i];
                                literalCostCache[i + 1] = literalCostCache[i] + this.symEncoder.writeSymbolCost(c & 0xFF);
                            }
                            maxComputedLength = limit;
                            if (length > 32) {
                                literalCost = literalCostCache[32];
                                literalCost += literalCost / 32 * (length - 32);
                            } else {
                                literalCost = literalCostCache[length];
                            }
                        } else {
                            literalCost = literalCostCache[length];
                        }
                        if (literalCost > bestGain && literalCost - (copyCost = this.encodeLengthCost(length, dist, distRanges = this.getNumDistRanges(dist))) - (distRanges << 16) > bestGain && (gain = literalCost - (copyCost += this.encodeDistance2Cost(dist, distRanges))) > bestGain) {
                            bestGain = gain;
                            bestLength = length;
                            bestDist = dist;
                            bestCopyCost = copyCost;
                        }
                    }
                }
                prevNode = hNode;
                hNode = hNode.next;
            }
        }
        costPerByteOut[0] = bestLength > 0 ? bestCopyCost / bestLength : 0;
        distOut[0] = bestDist;
        gainOut[0] = bestGain;
        return bestLength;
    }

    private int getNumDistRanges(int dist) {
        int bitsNeeded = HuffmanEncoder.bitsUsed(dist - 1);
        int distRanges = (bitsNeeded + 3 - 1) / 3;
        return distRanges;
    }

    private void encodeLength(int value, int dist, int numDistRanges) {
        int symbol;
        int i;
        value = dist >= 512 ? (value -= 3) : (value -= 2);
        int bitsUsed = HuffmanEncoder.bitsUsed(value);
        for (i = 2; i < bitsUsed; i += 2) {
        }
        int mask = 1 << i - 1;
        int n = symbol = bitsUsed > 2 ? 2 : 0;
        if ((value & mask) != 0) {
            symbol |= 1;
        }
        symbol <<= 1;
        if ((value & (mask >>= 1)) != 0) {
            symbol |= 1;
        }
        mask >>= 1;
        this.symEncoder.writeSymbol(256 + symbol + (numDistRanges - 1) * 8);
        for (i = bitsUsed - 2; i >= 1; i -= 2) {
            int n2 = symbol = i > 2 ? 2 : 0;
            if ((value & mask) != 0) {
                symbol |= 1;
            }
            symbol <<= 1;
            if ((value & (mask >>= 1)) != 0) {
                symbol |= 1;
            }
            mask >>= 1;
            this.lenEncoder.writeSymbol(symbol);
        }
    }

    private int encodeLengthCost(int value, int dist, int numDistRanges) {
        int symbol;
        int i;
        value = dist >= 512 ? (value -= 3) : (value -= 2);
        int bitsUsed = HuffmanEncoder.bitsUsed(value);
        for (i = 2; i < bitsUsed; i += 2) {
        }
        int mask = 1 << i - 1;
        int n = symbol = bitsUsed > 2 ? 2 : 0;
        if ((value & mask) != 0) {
            symbol |= 1;
        }
        symbol <<= 1;
        if ((value & (mask >>= 1)) != 0) {
            symbol |= 1;
        }
        mask >>= 1;
        int cost = this.symEncoder.writeSymbolCost(256 + symbol + (numDistRanges - 1) * 8);
        for (i = bitsUsed - 2; i >= 1; i -= 2) {
            int n2 = symbol = i > 2 ? 2 : 0;
            if ((value & mask) != 0) {
                symbol |= 1;
            }
            symbol <<= 1;
            if ((value & (mask >>= 1)) != 0) {
                symbol |= 1;
            }
            mask >>= 1;
            cost += this.lenEncoder.writeSymbolCost(symbol);
        }
        return cost;
    }

    private void encodeDistance2(int value, int distRanges) {
        --value;
        int mask = 7;
        for (int i = (distRanges - 1) * 3; i >= 0; i -= 3) {
            this.distEncoder.writeSymbol(value >> i & 7);
        }
    }

    private int encodeDistance2Cost(int value, int distRanges) {
        int cost = 0;
        --value;
        int mask = 7;
        for (int i = (distRanges - 1) * 3; i >= 0; i -= 3) {
            cost += this.distEncoder.writeSymbolCost(value >> i & 7);
        }
        return cost;
    }

    private void updateModel(int index) {
        byte c = this.buf[index];
        if (index > 0) {
            HashNode hNode = new HashNode();
            byte prevC = this.buf[index - 1];
            int pos = (prevC & 0xFF) << 8 | c & 0xFF;
            hNode.index = index - 1;
            hNode.next = this.hashTable[pos];
            this.hashTable[pos] = hNode;
        }
    }

    private byte[] toByteArray() {
        return this.bits.toByteArray();
    }

    public static byte[] compress(byte[] dataIn) {
        LzcompCompress compressor = new LzcompCompress();
        compressor.write(dataIn);
        return compressor.toByteArray();
    }

    public static int getPreloadSize() {
        return 7168;
    }

    private static class HashNode {
        int index;
        HashNode next;

        private HashNode() {
        }
    }
}

