/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.sfnttool;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.table.core.CMap;
import com.google.typography.font.sfntly.table.core.CMapTable;
import com.google.typography.font.sfntly.table.truetype.CompositeGlyph;
import com.google.typography.font.sfntly.table.truetype.Glyph;
import com.google.typography.font.sfntly.table.truetype.GlyphTable;
import com.google.typography.font.sfntly.table.truetype.LocaTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GlyphCoverage {
    public static List<Integer> getGlyphCoverage(Font font, String string) {
        CMapTable cmapTable = (CMapTable)font.getTable(Tag.cmap);
        CMap cmap = GlyphCoverage.getBestCMap(cmapTable);
        HashSet<Integer> coverage = new HashSet<Integer>();
        coverage.add(0);
        for (int i = 0; i < string.length(); ++i) {
            int c = string.charAt(i) & 0xFFFF;
            int glyphId = cmap.glyphId(c);
            GlyphCoverage.touchGlyph(font, coverage, glyphId);
        }
        ArrayList<Integer> sortedCoverage = new ArrayList<Integer>(coverage);
        Collections.sort(sortedCoverage);
        return sortedCoverage;
    }

    private static void touchGlyph(Font font, Set<Integer> coverage, int glyphId) {
        if (!coverage.contains(glyphId)) {
            coverage.add(glyphId);
            Glyph glyph = GlyphCoverage.getGlyph(font, glyphId);
            if (glyph != null && glyph.glyphType() == Glyph.GlyphType.Composite) {
                CompositeGlyph composite = (CompositeGlyph)glyph;
                for (int i = 0; i < composite.numGlyphs(); ++i) {
                    GlyphCoverage.touchGlyph(font, coverage, composite.glyphIndex(i));
                }
            }
        }
    }

    private static CMap getBestCMap(CMapTable cmapTable) {
        for (CMap cmap : cmapTable) {
            if (cmap.format() != CMap.CMapFormat.Format12.value()) continue;
            return cmap;
        }
        for (CMap cmap : cmapTable) {
            if (cmap.format() != CMap.CMapFormat.Format4.value()) continue;
            return cmap;
        }
        return null;
    }

    private static Glyph getGlyph(Font font, int glyphId) {
        LocaTable locaTable = (LocaTable)font.getTable(Tag.loca);
        GlyphTable glyfTable = (GlyphTable)font.getTable(Tag.glyf);
        int offset = locaTable.glyphOffset(glyphId);
        int length = locaTable.glyphLength(glyphId);
        return glyfTable.glyph(offset, length);
    }
}

