/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.fetch;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.fetch.ProcessInstanceGetCallHierarchyRequest;
import io.camunda.client.api.search.response.ProcessInstanceCallHierarchyEntryResponse;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.response.SearchResponseMapper;
import io.camunda.client.protocol.rest.ProcessInstanceCallHierarchyEntry;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class ProcessInstanceGetCallHierarchyRequestImpl
implements ProcessInstanceGetCallHierarchyRequest {
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final long processInstanceKey;

    public ProcessInstanceGetCallHierarchyRequestImpl(HttpClient httpClient, long processInstanceKey) {
        this.httpClient = httpClient;
        this.processInstanceKey = processInstanceKey;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    public ProcessInstanceGetCallHierarchyRequest requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<List<ProcessInstanceCallHierarchyEntryResponse>> send() {
        HttpCamundaFuture<List<ProcessInstanceCallHierarchyEntryResponse>> result = new HttpCamundaFuture<List<ProcessInstanceCallHierarchyEntryResponse>>();
        this.httpClient.get(String.format("/process-instances/%d/call-hierarchy", this.processInstanceKey), this.httpRequestConfig.build(), ProcessInstanceCallHierarchyEntry[].class, SearchResponseMapper::toProcessInstanceCallHierarchyEntryResponse, result);
        return result;
    }
}

