/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.fetch;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.fetch.ProcessInstanceGetRequest;
import io.camunda.client.api.search.response.ProcessInstance;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.response.SearchResponseMapper;
import io.camunda.client.protocol.rest.ProcessInstanceResult;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class ProcessInstanceGetRequestImpl
implements ProcessInstanceGetRequest {
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final long processInstanceKey;

    public ProcessInstanceGetRequestImpl(HttpClient httpClient, long processInstanceKey) {
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.processInstanceKey = processInstanceKey;
    }

    public ProcessInstanceGetRequest requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<ProcessInstance> send() {
        HttpCamundaFuture<ProcessInstance> result = new HttpCamundaFuture<ProcessInstance>();
        this.httpClient.get(String.format("/process-instances/%d", this.processInstanceKey), this.httpRequestConfig.build(), ProcessInstanceResult.class, SearchResponseMapper::toProcessInstanceGetResponse, result);
        return result;
    }
}

