/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.request;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.fetch.RolesSearchRequest;
import io.camunda.client.api.search.request.FinalSearchRequestStep;
import io.camunda.client.api.search.request.SearchRequestBuilders;
import io.camunda.client.api.search.request.SearchRequestPage;
import io.camunda.client.api.search.response.Role;
import io.camunda.client.api.search.response.SearchResponse;
import io.camunda.client.api.search.sort.RoleSort;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.request.SearchRequestSortMapper;
import io.camunda.client.impl.search.request.TypedSearchRequestPropertyProvider;
import io.camunda.client.impl.search.response.SearchResponseMapper;
import io.camunda.client.protocol.rest.RoleFilter;
import io.camunda.client.protocol.rest.RoleSearchQueryRequest;
import io.camunda.client.protocol.rest.RoleSearchQueryResult;
import io.camunda.client.protocol.rest.SearchQueryPageRequest;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class RolesSearchRequestImpl
extends TypedSearchRequestPropertyProvider<RoleSearchQueryRequest>
implements RolesSearchRequest {
    private final RoleSearchQueryRequest request;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final JsonMapper jsonMapper;

    public RolesSearchRequestImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.request = new RoleSearchQueryRequest();
    }

    @Override
    public FinalSearchRequestStep<Role> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<SearchResponse<Role>> send() {
        HttpCamundaFuture<SearchResponse<Role>> result = new HttpCamundaFuture<SearchResponse<Role>>();
        this.httpClient.post("/roles/search", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), RoleSearchQueryResult.class, SearchResponseMapper::toRolesResponse, result);
        return result;
    }

    @Override
    public RolesSearchRequest filter(io.camunda.client.api.search.filter.RoleFilter value) {
        this.request.setFilter((RoleFilter)RolesSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public RolesSearchRequest filter(Consumer<io.camunda.client.api.search.filter.RoleFilter> fn) {
        return this.filter(SearchRequestBuilders.roleFilter(fn));
    }

    @Override
    public RolesSearchRequest sort(RoleSort value) {
        this.request.setSort(SearchRequestSortMapper.toRoleSearchQuerySortRequest((List)RolesSearchRequestImpl.provideSearchRequestProperty(value)));
        return this;
    }

    @Override
    public RolesSearchRequest sort(Consumer<RoleSort> fn) {
        return this.sort(SearchRequestBuilders.roleSort(fn));
    }

    @Override
    public RolesSearchRequest page(SearchRequestPage value) {
        this.request.setPage((SearchQueryPageRequest)RolesSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public RolesSearchRequest page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    protected RoleSearchQueryRequest getSearchRequestProperty() {
        return this.request;
    }
}

