/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.response;

import io.camunda.client.api.search.enums.ElementInstanceState;
import io.camunda.client.api.search.enums.ElementInstanceType;
import io.camunda.client.api.search.response.ElementInstance;
import io.camunda.client.impl.util.EnumUtil;
import io.camunda.client.impl.util.ParseUtil;
import io.camunda.client.protocol.rest.ElementInstanceResult;
import java.time.OffsetDateTime;
import java.util.Objects;

public final class ElementInstanceImpl
implements ElementInstance {
    private final Long elementInstanceKey;
    private final Long processDefinitionKey;
    private final String processDefinitionId;
    private final Long processInstanceKey;
    private final String elementId;
    private final String elementName;
    private final OffsetDateTime startDate;
    private final OffsetDateTime endDate;
    private final Boolean incident;
    private final Long incidentKey;
    private final ElementInstanceState state;
    private final String tenantId;
    private final ElementInstanceType type;

    public ElementInstanceImpl(ElementInstanceResult item) {
        this.elementInstanceKey = ParseUtil.parseLongOrNull(item.getElementInstanceKey());
        this.processDefinitionKey = ParseUtil.parseLongOrNull(item.getProcessDefinitionKey());
        this.processDefinitionId = item.getProcessDefinitionId();
        this.processInstanceKey = ParseUtil.parseLongOrNull(item.getProcessInstanceKey());
        this.elementId = item.getElementId();
        this.elementName = item.getElementName();
        this.startDate = ParseUtil.parseOffsetDateTimeOrNull(item.getStartDate());
        this.endDate = ParseUtil.parseOffsetDateTimeOrNull(item.getEndDate());
        this.incident = item.getHasIncident();
        this.incidentKey = ParseUtil.parseLongOrNull(item.getIncidentKey());
        this.state = EnumUtil.convert(item.getState(), ElementInstanceState.class);
        this.tenantId = item.getTenantId();
        this.type = EnumUtil.convert(item.getType(), ElementInstanceType.class);
    }

    @Override
    public Long getElementInstanceKey() {
        return this.elementInstanceKey;
    }

    @Override
    public Long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @Override
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    @Override
    public Long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    @Override
    public String getElementId() {
        return this.elementId;
    }

    @Override
    public String getElementName() {
        return this.elementName;
    }

    @Override
    public OffsetDateTime getStartDate() {
        return this.startDate;
    }

    @Override
    public OffsetDateTime getEndDate() {
        return this.endDate;
    }

    @Override
    public Boolean getIncident() {
        return this.incident;
    }

    @Override
    public Long getIncidentKey() {
        return this.incidentKey;
    }

    @Override
    public ElementInstanceState getState() {
        return this.state;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public ElementInstanceType getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.elementInstanceKey, this.processDefinitionKey, this.processInstanceKey, this.processDefinitionId, this.elementId, this.startDate, this.endDate, this.incident, this.incidentKey, this.state, this.tenantId, this.type});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElementInstanceImpl that = (ElementInstanceImpl)o;
        return Objects.equals(this.elementInstanceKey, that.elementInstanceKey) && Objects.equals(this.processDefinitionKey, that.processDefinitionKey) && Objects.equals(this.processInstanceKey, that.processInstanceKey) && Objects.equals(this.processDefinitionId, that.processDefinitionId) && Objects.equals(this.elementId, that.elementId) && Objects.equals(this.elementName, that.elementName) && Objects.equals(this.startDate, that.startDate) && Objects.equals(this.endDate, that.endDate) && Objects.equals(this.incident, that.incident) && Objects.equals(this.incidentKey, that.incidentKey) && this.state == that.state && Objects.equals(this.tenantId, that.tenantId) && this.type == that.type;
    }
}

