/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.response;

import io.camunda.client.api.response.Process;
import io.camunda.client.api.search.response.ProcessDefinition;
import io.camunda.client.impl.util.ParseUtil;
import io.camunda.client.protocol.rest.ProcessDefinitionResult;
import java.util.Objects;

public class ProcessDefinitionImpl
implements ProcessDefinition,
Process {
    private final Long processDefinitionKey;
    private final String name;
    private final String resourceName;
    private final Integer version;
    private final String versionTag;
    private final String processDefinitionId;
    private final String tenantId;

    public ProcessDefinitionImpl(ProcessDefinitionResult item) {
        this.processDefinitionKey = ParseUtil.parseLongOrNull(item.getProcessDefinitionKey());
        this.name = item.getName();
        this.resourceName = item.getResourceName();
        this.version = item.getVersion();
        this.versionTag = item.getVersionTag();
        this.processDefinitionId = item.getProcessDefinitionId();
        this.tenantId = item.getTenantId();
    }

    @Override
    public long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public String getVersionTag() {
        return this.versionTag;
    }

    @Override
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getBpmnProcessId() {
        return this.processDefinitionId;
    }

    public int hashCode() {
        return Objects.hash(this.processDefinitionKey, this.name, this.resourceName, this.version, this.versionTag, this.processDefinitionId, this.tenantId);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessDefinitionImpl that = (ProcessDefinitionImpl)o;
        return Objects.equals(this.processDefinitionKey, that.processDefinitionKey) && Objects.equals(this.name, that.name) && Objects.equals(this.resourceName, that.resourceName) && Objects.equals(this.version, that.version) && Objects.equals(this.versionTag, that.versionTag) && Objects.equals(this.processDefinitionId, that.processDefinitionId) && Objects.equals(this.tenantId, that.tenantId);
    }

    public String toString() {
        return "ProcessDefinitionImpl{processDefinitionKey=" + this.processDefinitionKey + ", name='" + this.name + '\'' + ", resourceName='" + this.resourceName + '\'' + ", version=" + this.version + ", versionTag='" + this.versionTag + '\'' + ", processDefinitionId='" + this.processDefinitionId + '\'' + ", tenantId='" + this.tenantId + '\'' + '}';
    }
}

