/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.api.assertions;

import io.camunda.client.api.response.EvaluateDecisionResponse;
import io.camunda.client.api.search.filter.DecisionInstanceFilter;
import io.camunda.client.api.search.response.DecisionInstance;
import io.camunda.process.test.api.assertions.DecisionSelector;

public class DecisionSelectors {
    public static DecisionSelector byProcessInstanceKey(long processInstanceKey) {
        return new DecisionProcessInstanceKeySelector(processInstanceKey);
    }

    public static DecisionSelector byName(String decisionName) {
        return new DecisionNameSelector(decisionName);
    }

    public static DecisionSelector byName(String decisionName, long processInstanceKey) {
        return new DecisionNameSelector(decisionName, processInstanceKey);
    }

    public static DecisionSelector byId(String decisionId) {
        return new DecisionIdSelector(decisionId);
    }

    public static DecisionSelector byId(String decisionId, long processInstanceKey) {
        return new DecisionIdSelector(decisionId, processInstanceKey);
    }

    public static DecisionSelector byResponse(EvaluateDecisionResponse response) {
        return new EvaluateDecisionResponseSelector(response);
    }

    private static final class DecisionProcessInstanceKeySelector
    implements DecisionSelector {
        private final long processInstanceKey;

        private DecisionProcessInstanceKeySelector(long processInstanceKey) {
            this.processInstanceKey = processInstanceKey;
        }

        @Override
        public boolean test(DecisionInstance decisionInstance) {
            return true;
        }

        @Override
        public String describe() {
            return "processInstanceKey: " + this.processInstanceKey;
        }

        @Override
        public void applyFilter(DecisionInstanceFilter filter) {
            filter.processInstanceKey(this.processInstanceKey);
        }
    }

    private static final class DecisionNameSelector
    implements DecisionSelector {
        private final String decisionDefinitionName;
        private final Long processInstanceKey;

        private DecisionNameSelector(String decisionDefinitionName) {
            this(decisionDefinitionName, (Long)null);
        }

        private DecisionNameSelector(String decisionDefinitionName, Long processInstanceKey) {
            this.decisionDefinitionName = decisionDefinitionName;
            this.processInstanceKey = processInstanceKey;
        }

        @Override
        public boolean test(DecisionInstance decision) {
            return this.decisionDefinitionName.equals(decision.getDecisionDefinitionName());
        }

        @Override
        public String describe() {
            if (this.processInstanceKey != null) {
                return String.format("name: %s, processInstanceKey: %d", this.decisionDefinitionName, this.processInstanceKey);
            }
            return "name: " + this.decisionDefinitionName;
        }

        @Override
        public void applyFilter(DecisionInstanceFilter filter) {
            filter.decisionDefinitionName(this.decisionDefinitionName);
            if (this.processInstanceKey != null) {
                filter.processInstanceKey(this.processInstanceKey.longValue());
            }
        }
    }

    private static final class DecisionIdSelector
    implements DecisionSelector {
        private final String decisionDefinitionId;
        private final Long processInstanceKey;

        private DecisionIdSelector(String decisionDefinitionId) {
            this(decisionDefinitionId, (Long)null);
        }

        private DecisionIdSelector(String decisionDefinitionId, Long processInstanceKey) {
            this.decisionDefinitionId = decisionDefinitionId;
            this.processInstanceKey = processInstanceKey;
        }

        @Override
        public boolean test(DecisionInstance decisionInstance) {
            return this.decisionDefinitionId.equals(decisionInstance.getDecisionDefinitionId());
        }

        @Override
        public String describe() {
            if (this.processInstanceKey != null) {
                return String.format("decisionId: %s, processInstanceKey: %d", this.decisionDefinitionId, this.processInstanceKey);
            }
            return "decisionId: " + this.decisionDefinitionId;
        }

        @Override
        public void applyFilter(DecisionInstanceFilter filter) {
            filter.decisionDefinitionId(this.decisionDefinitionId);
            if (this.processInstanceKey != null) {
                filter.processInstanceKey(this.processInstanceKey.longValue());
            }
        }
    }

    private static final class EvaluateDecisionResponseSelector
    implements DecisionSelector {
        private final EvaluateDecisionResponse response;

        private EvaluateDecisionResponseSelector(EvaluateDecisionResponse response) {
            this.response = response;
        }

        @Override
        public boolean test(DecisionInstance decision) {
            return decision.getDecisionInstanceKey() == this.response.getDecisionInstanceKey() && decision.getDecisionDefinitionId().equals(this.response.getDecisionId());
        }

        @Override
        public String describe() {
            return String.format("name: %s, decisionId: %s", this.response.getDecisionName(), this.response.getDecisionId());
        }

        @Override
        public void applyFilter(DecisionInstanceFilter filter) {
            filter.decisionInstanceKey(this.response.getDecisionInstanceKey()).decisionDefinitionId(this.response.getDecisionId());
        }
    }
}

