/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.api.assertions;

import io.camunda.client.api.search.filter.ElementInstanceFilter;
import io.camunda.client.api.search.response.ElementInstance;
import io.camunda.process.test.api.assertions.ElementSelector;

public class ElementSelectors {
    public static ElementSelector byId(String elementId) {
        return new ElementIdSelector(elementId);
    }

    public static ElementSelector byName(String elementName) {
        return new ElementNameSelector(elementName);
    }

    private static final class ElementIdSelector
    implements ElementSelector {
        private final String elementId;

        private ElementIdSelector(String elementId) {
            this.elementId = elementId;
        }

        @Override
        public boolean test(ElementInstance element) {
            return this.elementId.equals(element.getElementId());
        }

        @Override
        public String describe() {
            return this.elementId;
        }

        @Override
        public void applyFilter(ElementInstanceFilter filter) {
            filter.elementId(this.elementId);
        }
    }

    private static final class ElementNameSelector
    implements ElementSelector {
        private final String elementName;

        private ElementNameSelector(String elementName) {
            this.elementName = elementName;
        }

        @Override
        public boolean test(ElementInstance element) {
            return this.elementName.equals(element.getElementName());
        }

        @Override
        public String describe() {
            return this.elementName;
        }
    }
}

