/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.api.coverage;

import io.camunda.process.test.api.coverage.ProcessCoverageBuilder;
import io.camunda.process.test.api.coverage.core.CoverageCollector;
import io.camunda.process.test.api.coverage.report.CoverageReporter;
import io.camunda.process.test.impl.assertions.CamundaDataSource;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class ProcessCoverage {
    private final CoverageCollector coverageCollector;
    private final CoverageReporter coverageReporter;

    public ProcessCoverage(Class<?> testClass, List<String> excludedProcessDefinitionIds, String reportDirectory, Consumer<String> printStream, Supplier<CamundaDataSource> dataSourceSupplier) {
        this.coverageCollector = CoverageCollector.createCollector(testClass, excludedProcessDefinitionIds, dataSourceSupplier);
        this.coverageReporter = new CoverageReporter(reportDirectory, printStream);
    }

    public static ProcessCoverageBuilder newBuilder() {
        return new ProcessCoverageBuilder();
    }

    public void collectTestRunCoverage(String runName) {
        this.coverageCollector.collectTestRunCoverage(runName);
    }

    public void reportCoverage() {
        this.coverageReporter.reportCoverage(this.coverageCollector);
        this.coverageReporter.printCoverage(this.coverageCollector);
    }
}

