/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.api.coverage.report;

import io.camunda.process.test.api.coverage.core.CoverageCreator;
import io.camunda.process.test.api.coverage.model.Coverage;
import io.camunda.process.test.api.coverage.model.Model;
import io.camunda.process.test.api.coverage.model.Suite;
import io.camunda.process.test.api.coverage.report.AggregatedCoverageReport;
import io.camunda.process.test.api.coverage.report.AggregatedSuiteInfo;
import io.camunda.process.test.api.coverage.report.HtmlCoverageReport;
import io.camunda.process.test.api.coverage.report.SuiteCoverageReport;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CoverageReportCreator {
    public static SuiteCoverageReport createSuiteCoverageReport(Suite suite, Collection<Model> models) {
        List<Coverage> coverages = CoverageCreator.aggregateCoverages(CoverageReportCreator.allCoverages(Collections.singletonList(suite)), models);
        return new SuiteCoverageReport(suite.getId(), suite.getName(), suite.getRuns(), models, coverages);
    }

    public static AggregatedCoverageReport createAggregatedCoverageReport(Collection<Suite> suites, Collection<Model> models) {
        List<Coverage> coverages = CoverageCreator.aggregateCoverages(CoverageReportCreator.allCoverages(suites), models);
        Collection suiteInfos = suites.stream().map(suite -> new AggregatedSuiteInfo(suite.getId(), suite.getName(), CoverageCreator.aggregateCoverages(CoverageReportCreator.allCoverages(Collections.singletonList(suite)), models))).collect(Collectors.toList());
        return new AggregatedCoverageReport(suiteInfos, models, coverages);
    }

    public static HtmlCoverageReport createHtmlCoverageReport(Collection<Suite> suites, Collection<Model> models) {
        Collection suiteReports = suites.stream().map(suite -> CoverageReportCreator.createSuiteCoverageReport(suite, models)).collect(Collectors.toList());
        List<Coverage> coverages = CoverageCreator.aggregateCoverages(CoverageReportCreator.allCoverages(suites), models);
        Map<String, String> definitions = models.stream().collect(Collectors.toMap(Model::getProcessDefinitionId, Model::xml, (a, b) -> a));
        return new HtmlCoverageReport(suiteReports, coverages, definitions);
    }

    private static Collection<Coverage> allCoverages(Collection<Suite> suites) {
        return suites.stream().flatMap(suite -> suite.getRuns().stream().flatMap(r -> r.getCoverages().stream())).collect(Collectors.toList());
    }
}

