/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.assertions;

import io.camunda.client.api.search.enums.UserTaskState;
import io.camunda.client.api.search.response.UserTask;
import io.camunda.process.test.api.CamundaAssertAwaitBehavior;
import io.camunda.process.test.api.assertions.UserTaskAssert;
import io.camunda.process.test.api.assertions.UserTaskSelector;
import io.camunda.process.test.impl.assertions.CamundaDataSource;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractOffsetDateTimeAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.OptionalAssert;

public class UserTaskAssertj
extends AbstractAssert<UserTaskAssertj, UserTaskSelector>
implements UserTaskAssert {
    private final CamundaDataSource dataSource;
    private final CamundaAssertAwaitBehavior awaitBehavior;

    public UserTaskAssertj(CamundaDataSource dataSource, CamundaAssertAwaitBehavior awaitBehavior, UserTaskSelector selector) {
        super((Object)selector, UserTaskAssert.class);
        this.dataSource = dataSource;
        this.awaitBehavior = awaitBehavior;
    }

    @Override
    public UserTaskAssert isCreated() {
        this.hasUserTaskInState(UserTaskState.CREATED);
        return this;
    }

    @Override
    public UserTaskAssert isCompleted() {
        this.hasUserTaskInState(UserTaskState.COMPLETED);
        return this;
    }

    @Override
    public UserTaskAssert isCanceled() {
        this.hasUserTaskInState(UserTaskState.CANCELED);
        return this;
    }

    @Override
    public UserTaskAssert isFailed() {
        this.hasUserTaskInState(UserTaskState.FAILED);
        return this;
    }

    @Override
    public UserTaskAssert hasAssignee(String assignee) {
        this.awaitUserTask(userTask -> ((AbstractStringAssert)Assertions.assertThat((String)userTask.getAssignee()).withFailMessage("Expected [%s] to have assignee '%s', but was '%s'", new Object[]{((UserTaskSelector)this.actual).describe(), assignee, userTask.getAssignee()})).isEqualTo(assignee));
        return this;
    }

    @Override
    public UserTaskAssert hasPriority(int priority) {
        this.awaitUserTask(userTask -> ((AbstractIntegerAssert)Assertions.assertThat((Integer)userTask.getPriority()).withFailMessage("Expected [%s] to have priority '%d', but was '%d'", new Object[]{((UserTaskSelector)this.actual).describe(), priority, userTask.getPriority()})).isEqualTo(priority));
        return this;
    }

    @Override
    public UserTaskAssert hasElementId(String elementId) {
        this.awaitUserTask(userTask -> ((AbstractStringAssert)Assertions.assertThat((String)userTask.getElementId().trim()).withFailMessage("Expected [%s] to have element ID '%s', but was '%s'", new Object[]{((UserTaskSelector)this.actual).describe(), elementId, userTask.getElementId()})).isEqualTo(elementId));
        return this;
    }

    @Override
    public UserTaskAssert hasName(String name) {
        this.awaitUserTask(userTask -> ((AbstractStringAssert)Assertions.assertThat((String)userTask.getName().trim()).withFailMessage("Expected [%s] to have name '%s', but was '%s'", new Object[]{((UserTaskSelector)this.actual).describe(), name, userTask.getName()})).isEqualTo(name));
        return this;
    }

    @Override
    public UserTaskAssert hasProcessInstanceKey(long processInstanceKey) {
        this.awaitUserTask(userTask -> ((AbstractLongAssert)Assertions.assertThat((Long)userTask.getProcessInstanceKey()).withFailMessage("Expected [%s] to have processInstanceKey '%d', but was '%d'", new Object[]{((UserTaskSelector)this.actual).describe(), processInstanceKey, userTask.getProcessInstanceKey()})).isEqualTo(processInstanceKey));
        return this;
    }

    @Override
    public UserTaskAssert hasDueDate(String dueDate) {
        this.awaitUserTask(userTask -> ((AbstractOffsetDateTimeAssert)Assertions.assertThat((OffsetDateTime)userTask.getDueDate()).withFailMessage("Expected [%s] to have due date '%s', but was '%s'", new Object[]{((UserTaskSelector)this.actual).describe(), dueDate, userTask.getDueDate()})).isEqualTo(dueDate));
        return this;
    }

    @Override
    public UserTaskAssert hasCompletionDate(String completionDate) {
        this.awaitUserTask(userTask -> ((AbstractOffsetDateTimeAssert)Assertions.assertThat((OffsetDateTime)userTask.getCompletionDate()).withFailMessage("Expected [%s] to have completion date '%s', but was '%s'", new Object[]{((UserTaskSelector)this.actual).describe(), completionDate, userTask.getCompletionDate()})).isEqualTo(completionDate));
        return this;
    }

    @Override
    public UserTaskAssert hasFollowUpDate(String followUpDate) {
        this.awaitUserTask(userTask -> ((AbstractOffsetDateTimeAssert)Assertions.assertThat((OffsetDateTime)userTask.getFollowUpDate()).withFailMessage("Expected [%s] to have follow-up date '%s', but was '%s'", new Object[]{((UserTaskSelector)this.actual).describe(), followUpDate, userTask.getFollowUpDate()})).isEqualTo(followUpDate));
        return this;
    }

    @Override
    public UserTaskAssert hasCreationDate(String creationDate) {
        this.awaitUserTask(userTask -> ((AbstractOffsetDateTimeAssert)Assertions.assertThat((OffsetDateTime)userTask.getCreationDate()).withFailMessage("Expected [%s] to have creation date '%s', but was '%s'", new Object[]{((UserTaskSelector)this.actual).describe(), creationDate, userTask.getCreationDate()})).isEqualTo(creationDate));
        return this;
    }

    @Override
    public UserTaskAssert hasCandidateGroup(String candidateGroup) {
        this.awaitUserTask(userTask -> ((ListAssert)Assertions.assertThat((List)userTask.getCandidateGroups()).withFailMessage("Expected [%s] to have candidate group '%s', but was %s", new Object[]{((UserTaskSelector)this.actual).describe(), candidateGroup, userTask.getCandidateGroups()})).contains((Object[])new String[]{candidateGroup}));
        return this;
    }

    @Override
    public UserTaskAssert hasCandidateGroups(List<String> candidateGroups) {
        this.awaitUserTask(userTask -> ((ListAssert)Assertions.assertThat((List)userTask.getCandidateGroups()).withFailMessage("Expected [%s] to have candidate groups %s, but was %s", new Object[]{((UserTaskSelector)this.actual).describe(), candidateGroups, userTask.getCandidateGroups()})).containsAll((Iterable)candidateGroups));
        return this;
    }

    private void hasUserTaskInState(UserTaskState expectedState) {
        this.awaitUserTask(userTask -> ((AbstractComparableAssert)Assertions.assertThat((Comparable)userTask.getState()).withFailMessage("Expected [%s] to be %s, but was %s", new Object[]{((UserTaskSelector)this.actual).describe(), this.formatState(expectedState), this.formatState(userTask.getState())})).isEqualTo((Object)expectedState));
    }

    private String formatState(UserTaskState state) {
        if (state == null) {
            return "not activated";
        }
        return state.name().toLowerCase();
    }

    private void awaitUserTask(Consumer<UserTask> assertion) {
        this.awaitBehavior.untilAsserted(() -> this.dataSource.findUserTasks(((UserTaskSelector)this.actual)::applyFilter), userTasks -> {
            Optional<UserTask> userTask = userTasks.stream().filter(((UserTaskSelector)this.actual)::test).findFirst();
            ((OptionalAssert)Assertions.assertThat(userTask).withFailMessage("No user task [%s] found", new Object[]{((UserTaskSelector)this.actual).describe()})).isPresent();
            assertion.accept(userTask.get());
        });
    }
}

