/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.mock;

import io.camunda.client.CamundaClient;
import io.camunda.client.api.response.ActivatedJob;
import io.camunda.client.api.worker.JobHandler;
import io.camunda.process.test.api.mock.JobWorkerMockBuilder;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobWorkerMockImpl
implements JobWorkerMockBuilder.JobWorkerMock {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobWorkerMockImpl.class);
    private final List<ActivatedJob> activatedJobs = new ArrayList<ActivatedJob>();

    public JobWorkerMockImpl(String jobType, CamundaClient camundaClient, JobHandler jobHandler) {
        JobHandler loggingJobHandler = (jobClient, job) -> {
            LOGGER.debug("Mock: Pass job to custom handler [job-type: '{}', job-key: '{}']", (Object)jobType, (Object)job.getKey());
            this.activatedJobs.add(job);
            jobHandler.handle(jobClient, job);
        };
        JobHandler safeLoggingJobHandler = (client, job) -> {
            try {
                loggingJobHandler.handle(client, job);
            }
            catch (AssertionError e) {
                String failureMessage = String.format("JobWorkerMock [job-type: %s, job-key: %s] has failed assertions and will be terminated.", jobType, job.getKey());
                System.err.println(failureMessage);
                ((Throwable)((Object)e)).printStackTrace();
                client.newFailCommand(job.getKey()).retries(0).send().join();
            }
        };
        camundaClient.newWorker().jobType(jobType).handler(safeLoggingJobHandler).open();
    }

    @Override
    public int getInvocations() {
        return this.activatedJobs.size();
    }

    @Override
    public List<ActivatedJob> getActivatedJobs() {
        return this.activatedJobs;
    }
}

