/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.runtime;

import io.camunda.client.CamundaClient;
import io.camunda.client.CamundaClientBuilder;
import io.camunda.client.CamundaClientConfiguration;
import io.camunda.client.api.response.PartitionBrokerHealth;
import io.camunda.client.api.response.PartitionInfo;
import io.camunda.client.api.response.Topology;
import io.camunda.process.test.api.CamundaClientBuilderFactory;
import io.camunda.process.test.impl.runtime.CamundaProcessTestRuntime;
import io.camunda.process.test.impl.runtime.CamundaProcessTestRuntimeBuilder;
import java.net.URI;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamundaProcessTestRemoteRuntime
implements CamundaProcessTestRuntime {
    private static final Logger LOGGER = LoggerFactory.getLogger(CamundaProcessTestRemoteRuntime.class);
    private final URI camundaRestApiAddress;
    private final URI camundaGrpcApiAddress;
    private final URI camundaMonitoringApiAddress;
    private final URI connectorsRestApiAddress;
    private final CamundaClientBuilderFactory camundaClientBuilderFactory;

    public CamundaProcessTestRemoteRuntime(CamundaProcessTestRuntimeBuilder runtimeBuilder) {
        this.camundaClientBuilderFactory = runtimeBuilder.getRemoteCamundaClientBuilderFactory();
        this.camundaMonitoringApiAddress = runtimeBuilder.getRemoteCamundaMonitoringApiAddress();
        this.connectorsRestApiAddress = runtimeBuilder.getRemoteConnectorsRestApiAddress();
        CamundaClientConfiguration clientConfiguration = this.getClientConfiguration(this.camundaClientBuilderFactory);
        this.camundaRestApiAddress = clientConfiguration.getRestAddress();
        this.camundaGrpcApiAddress = clientConfiguration.getGrpcAddress();
        if (runtimeBuilder.isMultiTenancyEnabled()) {
            LOGGER.warn("Multitenancy detected, but not enabled. Activating multitenancy with a remote Camunda runtime has no effect. This feature is only supported for self-managed Camunda runtimes. Instead, make sure to configure the CamundaRuntimeConfiguration with all parameters necessary to authenticate the CamundaClient against the remote runtime.");
        }
    }

    @Override
    public void start() {
        LOGGER.info("Connecting to remote runtime. [Camunda REST: {}, Camunda gRPC: {}, Camunda Monitoring: {}, Connectors REST: {}]", new Object[]{this.camundaRestApiAddress, this.camundaGrpcApiAddress, this.camundaMonitoringApiAddress, this.connectorsRestApiAddress});
        this.checkConnectionToRemoteRuntime();
    }

    @Override
    public URI getCamundaRestApiAddress() {
        return this.camundaRestApiAddress;
    }

    @Override
    public URI getCamundaGrpcApiAddress() {
        return this.camundaGrpcApiAddress;
    }

    @Override
    public URI getCamundaMonitoringApiAddress() {
        return this.camundaMonitoringApiAddress;
    }

    @Override
    public URI getConnectorsRestApiAddress() {
        return this.connectorsRestApiAddress;
    }

    @Override
    public CamundaClientBuilderFactory getCamundaClientBuilderFactory() {
        return this.camundaClientBuilderFactory;
    }

    private void checkConnectionToRemoteRuntime() {
        Topology topology = this.queryRemoteRuntimeHealth();
        boolean isHealthy = topology.getBrokers().stream().flatMap(brokerInfo -> brokerInfo.getPartitions().stream()).map(PartitionInfo::getHealth).allMatch(arg_0 -> PartitionBrokerHealth.HEALTHY.equals(arg_0));
        boolean hasAtLeastOnePartition = topology.getBrokers().stream().anyMatch(brokerInfo -> !brokerInfo.getPartitions().isEmpty());
        if (!isHealthy || !hasAtLeastOnePartition) {
            if (!isHealthy) {
                String errorMessage = String.format("Remote Camunda runtime is unhealthy. [topology: %s]", topology);
                throw new RemoteRuntimeUnhealthyException(errorMessage);
            }
            String errorMessage = String.format("Remote Camunda runtime has zero available partitions. Please check the remote runtime logs for errors. [topology: %s]", topology);
            throw new RemoteRuntimeHasNoAvailablePartitionsException(errorMessage);
        }
        LOGGER.info("Remote Camunda runtime connected. [version: {}]", (Object)topology.getGatewayVersion());
    }

    private Topology queryRemoteRuntimeHealth() {
        Topology topology;
        block8: {
            CamundaClient camundaClient = ((CamundaClientBuilder)this.getCamundaClientBuilderFactory().get()).build();
            try {
                topology = (Topology)camundaClient.newTopologyRequest().send().join();
                if (camundaClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (camundaClient != null) {
                        try {
                            camundaClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to connect to remote Camunda runtime.", e);
                }
            }
            camundaClient.close();
        }
        return topology;
    }

    private CamundaClientConfiguration getClientConfiguration(Supplier<CamundaClientBuilder> camundaClientBuilderSupplier) {
        CamundaClientBuilder clientBuilder = camundaClientBuilderSupplier.get();
        try (CamundaClient camundaClient = clientBuilder.build();){
            CamundaClientConfiguration camundaClientConfiguration = camundaClient.getConfiguration();
            return camundaClientConfiguration;
        }
    }

    @Override
    public void close() throws Exception {
    }

    public static class RemoteRuntimeUnhealthyException
    extends IllegalStateException {
        public RemoteRuntimeUnhealthyException(String message) {
            super(message);
        }
    }

    public static class RemoteRuntimeHasNoAvailablePartitionsException
    extends IllegalStateException {
        public RemoteRuntimeHasNoAvailablePartitionsException(String message) {
            super(message);
        }
    }
}

