/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.runtime.logging;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.process.test.impl.runtime.logging.LogEntry;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import org.testcontainers.containers.output.OutputFrame;

public class Slf4jJsonLogConsumer
implements Consumer<OutputFrame> {
    private static final Map<String, Level> LOG_LEVEL_BY_SEVERITY = new HashMap<String, Level>();
    private final ObjectMapper objectMapper = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    private final Logger logger;
    private final Class<? extends LogEntry> logEntryType;

    public Slf4jJsonLogConsumer(Logger logger, Class<? extends LogEntry> logEntryType) {
        this.logger = logger;
        this.logEntryType = logEntryType;
    }

    @Override
    public void accept(OutputFrame outputFrame) {
        OutputFrame.OutputType outputType = outputFrame.getType();
        String utf8String = outputFrame.getUtf8StringWithoutLineEnding();
        switch (outputType) {
            case END: {
                break;
            }
            case STDOUT: {
                if (Slf4jJsonLogConsumer.isJsonLogMessage(utf8String)) {
                    this.logJsonMessage(utf8String);
                    break;
                }
                this.logger.info("{}", (Object)utf8String);
                break;
            }
            case STDERR: {
                this.logger.error("{}", (Object)utf8String);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected outputType " + outputType);
            }
        }
    }

    private static boolean isJsonLogMessage(String logMessage) {
        return logMessage.startsWith("{") && logMessage.endsWith("}");
    }

    private void logJsonMessage(String jsonMessage) {
        try {
            LogEntry logEntry = (LogEntry)this.objectMapper.readValue(jsonMessage, this.logEntryType);
            Level logLevel = LOG_LEVEL_BY_SEVERITY.getOrDefault(logEntry.getSeverity(), Level.INFO);
            String loggerName = logEntry.getLoggerName();
            String message = logEntry.getMessage();
            this.logger.atLevel(logLevel).log("{} - {}", (Object)loggerName, (Object)message);
        }
        catch (JsonProcessingException e) {
            this.logger.info("{}", (Object)jsonMessage);
        }
    }

    static {
        LOG_LEVEL_BY_SEVERITY.put("TRACE", Level.TRACE);
        LOG_LEVEL_BY_SEVERITY.put("DEBUG", Level.DEBUG);
        LOG_LEVEL_BY_SEVERITY.put("INFO", Level.INFO);
        LOG_LEVEL_BY_SEVERITY.put("WARNING", Level.WARN);
        LOG_LEVEL_BY_SEVERITY.put("ERROR", Level.ERROR);
    }
}

