/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.runtime.properties;

import io.camunda.client.CamundaClient;
import io.camunda.client.CamundaClientBuilder;
import io.camunda.client.CamundaClientCloudBuilderStep1;
import io.camunda.client.CredentialsProvider;
import io.camunda.process.test.api.CamundaClientBuilderFactory;
import io.camunda.process.test.impl.runtime.CamundaProcessTestRuntimeDefaults;
import io.camunda.process.test.impl.runtime.properties.RemoteRuntimeClientAuthProperties;
import io.camunda.process.test.impl.runtime.properties.RemoteRuntimeClientCloudProperties;
import io.camunda.process.test.impl.runtime.util.CptCredentialsProviderConfigurer;
import io.camunda.process.test.impl.runtime.util.PropertiesUtil;
import java.net.URI;
import java.util.Properties;

public class RemoteRuntimeClientProperties {
    public static final String PROPERTY_NAME_MODE = "remote.client.mode";
    public static final String PROPERTY_NAME_GRPC_ADDRESS = "remote.client.grpcAddress";
    public static final String PROPERTY_NAME_REST_ADDRESS = "remote.client.restAddress";
    private final ClientMode mode;
    private final URI grpcAddress;
    private final URI restAddress;
    private final RemoteRuntimeClientCloudProperties remoteRuntimeClientCloudProperties;
    private final RemoteRuntimeClientAuthProperties remoteRuntimeClientAuthProperties;

    public RemoteRuntimeClientProperties(Properties properties) {
        this.remoteRuntimeClientAuthProperties = new RemoteRuntimeClientAuthProperties(properties);
        this.remoteRuntimeClientCloudProperties = new RemoteRuntimeClientCloudProperties(properties);
        this.mode = PropertiesUtil.getPropertyOrDefault(properties, PROPERTY_NAME_MODE, v -> {
            try {
                return ClientMode.valueOf(v.toLowerCase());
            }
            catch (Throwable t) {
                return this.remoteRuntimeClientCloudProperties.getClusterId() != null ? ClientMode.saas : ClientMode.selfManaged;
            }
        }, ClientMode.selfManaged);
        this.grpcAddress = PropertiesUtil.getPropertyOrNull(properties, PROPERTY_NAME_GRPC_ADDRESS, v -> {
            try {
                return URI.create(v);
            }
            catch (Throwable t) {
                return CamundaProcessTestRuntimeDefaults.REMOTE_CLIENT_GRPC_ADDRESS;
            }
        });
        this.restAddress = PropertiesUtil.getPropertyOrNull(properties, PROPERTY_NAME_REST_ADDRESS, v -> {
            try {
                return URI.create(v);
            }
            catch (Throwable t) {
                return CamundaProcessTestRuntimeDefaults.REMOTE_CLIENT_REST_ADDRESS;
            }
        });
    }

    public ClientMode getMode() {
        return this.mode;
    }

    public URI getGrpcAddress() {
        return this.grpcAddress;
    }

    public URI getRestAddress() {
        return this.restAddress;
    }

    public RemoteRuntimeClientCloudProperties getCloudProperties() {
        return this.remoteRuntimeClientCloudProperties;
    }

    public RemoteRuntimeClientAuthProperties getAuthProperties() {
        return this.remoteRuntimeClientAuthProperties;
    }

    public CamundaClientBuilderFactory getClientBuilderFactory() {
        CamundaClientBuilder camundaClientBuilder = this.createCamundaClient(this.mode);
        if (CamundaProcessTestRuntimeDefaults.REMOTE_CLIENT_GRPC_ADDRESS != null) {
            camundaClientBuilder.grpcAddress(CamundaProcessTestRuntimeDefaults.REMOTE_CLIENT_GRPC_ADDRESS);
        }
        if (CamundaProcessTestRuntimeDefaults.REMOTE_CLIENT_REST_ADDRESS != null) {
            camundaClientBuilder.restAddress(CamundaProcessTestRuntimeDefaults.REMOTE_CLIENT_REST_ADDRESS);
        }
        return () -> camundaClientBuilder;
    }

    private CamundaClientBuilder createCamundaClient(ClientMode mode) {
        return mode == ClientMode.saas ? this.buildCloudClientFactory() : this.buildSelfManagedClientFactory();
    }

    private CamundaClientBuilder buildCloudClientFactory() {
        CamundaClientCloudBuilderStep1.CamundaClientCloudBuilderStep2.CamundaClientCloudBuilderStep3.CamundaClientCloudBuilderStep4.CamundaClientCloudBuilderStep5 cloudBuilderStep = CamundaClient.newCloudClientBuilder().withClusterId(this.remoteRuntimeClientCloudProperties.getClusterId()).withClientId(this.remoteRuntimeClientAuthProperties.getClientId()).withClientSecret(this.remoteRuntimeClientAuthProperties.getClientSecret()).withRegion(this.remoteRuntimeClientCloudProperties.getRegion());
        if (this.remoteRuntimeClientAuthProperties.getMethod() != null) {
            CredentialsProvider credentialsProvider = CptCredentialsProviderConfigurer.configure(this);
            cloudBuilderStep.credentialsProvider(credentialsProvider);
        }
        return cloudBuilderStep;
    }

    private CamundaClientBuilder buildSelfManagedClientFactory() {
        return CamundaClient.newClientBuilder();
    }

    public static enum ClientMode {
        selfManaged,
        saas;

    }
}

