/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.runtime.properties;

import io.camunda.process.test.impl.runtime.CamundaProcessTestRuntimeDefaults;
import io.camunda.process.test.impl.runtime.properties.RemoteRuntimeClientProperties;
import io.camunda.process.test.impl.runtime.util.PropertiesUtil;
import java.net.URI;
import java.util.Properties;

public class RemoteRuntimeProperties {
    public static final String PROPERTY_NAME_CAMUNDA_MONITORING_API_ADDRESS = "remote.camundaMonitoringApiAddress";
    public static final String PROPERTY_NAME_CONNECTORS_REST_API_ADDRESS = "remote.connectorsRestApiAddress";
    private final URI camundaMonitoringApiAddress;
    private final URI connectorsRestApiAddress;
    private final RemoteRuntimeClientProperties remoteClientProperties;

    public RemoteRuntimeProperties(Properties properties) {
        this.camundaMonitoringApiAddress = PropertiesUtil.getPropertyOrDefault(properties, PROPERTY_NAME_CAMUNDA_MONITORING_API_ADDRESS, v -> {
            try {
                return URI.create(v);
            }
            catch (Throwable t) {
                return CamundaProcessTestRuntimeDefaults.LOCAL_CAMUNDA_MONITORING_API_ADDRESS;
            }
        }, CamundaProcessTestRuntimeDefaults.LOCAL_CAMUNDA_MONITORING_API_ADDRESS);
        this.connectorsRestApiAddress = PropertiesUtil.getPropertyOrDefault(properties, PROPERTY_NAME_CONNECTORS_REST_API_ADDRESS, v -> {
            try {
                return URI.create(v);
            }
            catch (Throwable t) {
                return CamundaProcessTestRuntimeDefaults.LOCAL_CONNECTORS_REST_API_ADDRESS;
            }
        }, CamundaProcessTestRuntimeDefaults.LOCAL_CONNECTORS_REST_API_ADDRESS);
        this.remoteClientProperties = new RemoteRuntimeClientProperties(properties);
    }

    public URI getCamundaMonitoringApiAddress() {
        return this.camundaMonitoringApiAddress;
    }

    public URI getConnectorsRestApiAddress() {
        return this.connectorsRestApiAddress;
    }

    public RemoteRuntimeClientProperties getRemoteClientProperties() {
        return this.remoteClientProperties;
    }
}

