/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.runtime.util;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class PropertiesUtil {
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\$\\{.*}");

    public static String getPropertyOrNull(Properties properties, String propertyName) {
        return PropertiesUtil.getPropertyOrDefault(properties, propertyName, null);
    }

    public static String getPropertyOrDefault(Properties properties, String propertyName, String defaultValue) {
        String propertyValue = properties.getProperty(propertyName);
        if (propertyValue == null || PropertiesUtil.isPlaceholder(propertyValue)) {
            return defaultValue;
        }
        return propertyValue;
    }

    public static <T> T getPropertyOrNull(Properties properties, String propertyName, Function<String, T> converter) {
        return PropertiesUtil.getPropertyOrDefault(properties, propertyName, converter, null);
    }

    public static <T> T getPropertyOrDefault(Properties properties, String propertyName, Function<String, T> converter, T defaultValue) {
        String propertyValue = properties.getProperty(propertyName);
        if (propertyValue == null || PropertiesUtil.isPlaceholder(propertyValue)) {
            return defaultValue;
        }
        return converter.apply(propertyValue);
    }

    private static boolean isPlaceholder(String propertyValue) {
        return PLACEHOLDER_PATTERN.matcher(propertyValue).matches();
    }

    public static Map<String, String> getPropertyMapOrEmpty(Properties properties, String propertyNamePrefix) {
        return PropertiesUtil.getPropertyMapOrEmpty(properties, propertyNamePrefix, Function.identity());
    }

    public static <T> Map<String, T> getPropertyMapOrEmpty(Properties properties, String propertyNamePrefix, Function<String, T> converter) {
        String validatedPropertyNamePrefix = propertyNamePrefix.trim().endsWith(".") ? propertyNamePrefix.trim() : propertyNamePrefix.trim() + ".";
        return properties.stringPropertyNames().stream().filter(key -> key.startsWith(validatedPropertyNamePrefix)).collect(Collectors.toMap(key -> key.substring(validatedPropertyNamePrefix.length()), key -> PropertiesUtil.readProperty(properties, key, converter)));
    }

    public static List<String> getPropertyListOrEmpty(Properties properties, String propertyNamePrefix) {
        return PropertiesUtil.getPropertyListOrEmpty(properties, propertyNamePrefix, Function.identity());
    }

    public static <T> List<T> getPropertyListOrEmpty(Properties properties, String propertyNamePrefix, Function<String, T> converter) {
        Pattern propertyNamePattern = Pattern.compile(String.format("%s\\[\\d+]", propertyNamePrefix));
        return properties.stringPropertyNames().stream().filter(key -> propertyNamePattern.matcher((CharSequence)key).matches()).map(key -> PropertiesUtil.readProperty(properties, key, converter)).collect(Collectors.toList());
    }

    private static String readProperty(Properties properties, String key) {
        return (String)PropertiesUtil.readProperty(properties, key, Function.identity());
    }

    private static <T> T readProperty(Properties properties, String key, Function<String, T> converter) {
        return converter.apply(properties.getProperty(key).trim());
    }
}

