/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.testresult;

import io.camunda.client.api.search.enums.ElementInstanceState;
import io.camunda.client.api.search.enums.IncidentState;
import io.camunda.client.api.search.enums.MessageSubscriptionState;
import io.camunda.client.api.search.response.ElementInstance;
import io.camunda.client.api.search.response.Incident;
import io.camunda.client.api.search.response.MessageSubscription;
import io.camunda.client.api.search.response.ProcessInstance;
import io.camunda.process.test.impl.assertions.CamundaDataSource;
import io.camunda.process.test.impl.testresult.ProcessInstanceResult;
import io.camunda.process.test.impl.testresult.ProcessTestResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CamundaProcessTestResultCollector {
    private final CamundaDataSource dataSource;

    public CamundaProcessTestResultCollector(CamundaDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public ProcessTestResult collect() {
        ProcessTestResult result = new ProcessTestResult();
        List<ProcessInstanceResult> processInstanceResults = this.dataSource.findProcessInstances().stream().map(this::collectProcessInstanceResult).collect(Collectors.toList());
        result.setProcessInstanceTestResults(processInstanceResults);
        return result;
    }

    private ProcessInstanceResult collectProcessInstanceResult(ProcessInstance processInstance) {
        ProcessInstanceResult result = new ProcessInstanceResult();
        long processInstanceKey = processInstance.getProcessInstanceKey();
        result.setProcessInstance(processInstance);
        result.setVariables(this.collectVariables(processInstanceKey));
        result.setActiveIncidents(this.collectActiveIncidents(processInstanceKey));
        result.setActiveElementInstances(this.collectActiveElementInstances(processInstanceKey));
        result.setActiveMessageSubscriptions(this.collectActiveMessageSubscriptions(processInstanceKey));
        return result;
    }

    private Map<String, String> collectVariables(long processInstanceKey) {
        return this.dataSource.findVariables(filter -> filter.processInstanceKey(Long.valueOf(processInstanceKey)).scopeKey(Long.valueOf(processInstanceKey))).stream().collect(HashMap::new, (m, v) -> m.put(v.getName(), v.getValue()), HashMap::putAll);
    }

    private List<Incident> collectActiveIncidents(long processInstanceKey) {
        return this.dataSource.findIncidents(filter -> filter.processInstanceKey(Long.valueOf(processInstanceKey)).state(IncidentState.ACTIVE));
    }

    private List<ElementInstance> collectActiveElementInstances(long processInstanceKey) {
        return this.dataSource.findElementInstances(filter -> filter.processInstanceKey(processInstanceKey).state(ElementInstanceState.ACTIVE));
    }

    private List<MessageSubscription> collectActiveMessageSubscriptions(long processInstanceKey) {
        return this.dataSource.findMessageSubscriptions(filter -> filter.processInstanceKey(Long.valueOf(processInstanceKey)).messageSubscriptionState(MessageSubscriptionState.CREATED));
    }
}

