/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.jobhandling.parameter;

import io.camunda.client.CamundaClient;
import io.camunda.client.annotation.value.DocumentValue;
import io.camunda.client.api.command.ClientException;
import io.camunda.client.api.command.InternalClientException;
import io.camunda.client.api.response.ActivatedJob;
import io.camunda.client.api.response.DocumentReferenceResponse;
import io.camunda.client.api.worker.JobClient;
import io.camunda.client.jobhandling.parameter.ParameterDocumentContext;
import io.camunda.client.jobhandling.parameter.ParameterResolver;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentParameterResolver
implements ParameterResolver {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentParameterResolver.class);
    private final String variableName;
    private final boolean optional;
    private final DocumentValue.ParameterType parameterType;
    private final CamundaClient camundaClient;

    public DocumentParameterResolver(String variableName, boolean optional, DocumentValue.ParameterType parameterType, CamundaClient camundaClient) {
        this.variableName = variableName;
        this.optional = optional;
        this.parameterType = parameterType;
        this.camundaClient = camundaClient;
    }

    @Override
    public Object resolve(JobClient jobClient, ActivatedJob job) {
        LOG.debug("Resolving document references for variable {}", (Object)this.variableName);
        List<DocumentReferenceResponse> documentReferences = this.getDocumentReferences(job);
        return switch (this.parameterType) {
            default -> throw new IncompatibleClassChangeError();
            case DocumentValue.ParameterType.LIST -> documentReferences;
            case DocumentValue.ParameterType.CONTEXT -> new ParameterDocumentContext(documentReferences, this.camundaClient, this.optional);
            case DocumentValue.ParameterType.SINGLE -> this.singleDocumentReference(documentReferences);
        };
    }

    private DocumentReferenceResponse singleDocumentReference(List<DocumentReferenceResponse> documentReferences) {
        if (this.optional) {
            return documentReferences.stream().findFirst().orElseGet(() -> {
                LOG.debug("Variable {} contains empty list of document references", (Object)this.variableName);
                return null;
            });
        }
        if (documentReferences.isEmpty()) {
            throw new IllegalStateException(String.format("Variable %s contains empty list of document references and parameter is not optional", this.variableName));
        }
        if (documentReferences.size() > 1) {
            LOG.warn("Multiple document references for variable {}, returning only first", (Object)this.variableName);
        }
        return documentReferences.get(0);
    }

    protected List<DocumentReferenceResponse> getDocumentReferences(ActivatedJob job) {
        try {
            List documentReferences = job.getDocumentReferences(this.variableName);
            if (!this.optional && documentReferences == null) {
                throw new InternalClientException("Document reference variable value is null");
            }
            if (documentReferences == null) {
                return Collections.emptyList();
            }
            return documentReferences;
        }
        catch (ClientException e) {
            if (!this.optional) {
                throw new IllegalStateException(String.format("Could not get document references for variable %s", this.variableName), e);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not get document references for variable {}", (Object)this.variableName, (Object)e);
            } else {
                LOG.warn("Could not get document references for variable {}, please enable debug log for more details", (Object)this.variableName);
            }
            return List.of();
        }
    }
}

