/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.jobhandling.result;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.camunda.client.CamundaClient;
import io.camunda.client.api.command.ClientException;
import io.camunda.client.api.command.CreateDocumentBatchCommandStep1;
import io.camunda.client.api.response.DocumentReferenceBatchResponse;
import io.camunda.client.jobhandling.DocumentContext;
import io.camunda.client.jobhandling.result.ResultDocumentContextBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonSerialize(using=ResultDocumentContextSerializer.class)
public class ResultDocumentContext
implements DocumentContext,
ResultDocumentContextBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ResultDocumentContext.class);
    private final Map<String, Function<CreateDocumentBatchCommandStep1.CreateDocumentBatchCommandStep2, CreateDocumentBatchCommandStep1.CreateDocumentBatchCommandStep2>> documentBuilders = new HashMap<String, Function<CreateDocumentBatchCommandStep1.CreateDocumentBatchCommandStep2, CreateDocumentBatchCommandStep1.CreateDocumentBatchCommandStep2>>();
    private String storeId;
    private DocumentReferenceBatchResponse response;

    @Override
    public List<DocumentContext.DocumentEntry> getDocuments() {
        throw new ClientException("ResultDocumentContext.getDocuments() is not implemented");
    }

    public DocumentReferenceBatchResponse getResponse() {
        return this.response;
    }

    public Map<String, Function<CreateDocumentBatchCommandStep1.CreateDocumentBatchCommandStep2, CreateDocumentBatchCommandStep1.CreateDocumentBatchCommandStep2>> getFailedDocumentBuilders() {
        if (this.response == null) {
            LOG.warn("Result document context has not been processed yet, returning empty map");
            return Map.of();
        }
        return this.response.getFailedDocuments().stream().map(detail -> Map.entry(detail.getFileName(), this.documentBuilders.get(detail.getFileName()))).filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public DocumentContext build() {
        return this;
    }

    @Override
    public ResultDocumentContextBuilder storeId(String storeId) {
        this.storeId = storeId;
        return this;
    }

    @Override
    public ResultDocumentContextBuilder addDocument(String fileName, Function<CreateDocumentBatchCommandStep1.CreateDocumentBatchCommandStep2, CreateDocumentBatchCommandStep1.CreateDocumentBatchCommandStep2> documentBuilder) {
        this.documentBuilders.put(fileName, documentBuilder);
        return this;
    }

    public DocumentReferenceBatchResponse processDocumentBuilders(CamundaClient camundaClient) {
        if (this.response != null) {
            LOG.debug("Result document context has already been processed, returning previous response");
        } else {
            CreateDocumentBatchCommandStep1 documentBatchCommand = camundaClient.newCreateDocumentBatchCommand();
            if (this.storeId != null) {
                documentBatchCommand.storeId(this.storeId);
            }
            this.documentBuilders.forEach((fileName, documentBuilder) -> {
                CreateDocumentBatchCommandStep1.CreateDocumentBatchCommandStep2 addDocumentCommand = documentBatchCommand.addDocument();
                addDocumentCommand.fileName(fileName);
                documentBuilder.apply(addDocumentCommand);
                addDocumentCommand.done();
            });
            this.response = (DocumentReferenceBatchResponse)documentBatchCommand.execute();
        }
        return this.response;
    }

    public static class ResultDocumentContextSerializer
    extends StdSerializer<ResultDocumentContext> {
        public ResultDocumentContextSerializer() {
            this(null);
        }

        public ResultDocumentContextSerializer(Class<ResultDocumentContext> t) {
            super(t);
        }

        public void serialize(ResultDocumentContext value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeObject((Object)value.getResponse().getCreatedDocuments());
        }
    }
}

