/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"contentType", "fileName", "expiresAt", "size", "processDefinitionId", "processInstanceKey", "customProperties"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DocumentMetadata {
    public static final String JSON_PROPERTY_CONTENT_TYPE = "contentType";
    @Nullable
    private String contentType;
    public static final String JSON_PROPERTY_FILE_NAME = "fileName";
    @Nullable
    private String fileName;
    public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
    @Nullable
    private String expiresAt;
    public static final String JSON_PROPERTY_SIZE = "size";
    @Nullable
    private Long size;
    public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
    @Nullable
    private String processDefinitionId;
    public static final String JSON_PROPERTY_PROCESS_INSTANCE_KEY = "processInstanceKey";
    @Nullable
    private String processInstanceKey;
    public static final String JSON_PROPERTY_CUSTOM_PROPERTIES = "customProperties";
    @Nullable
    private Map<String, Object> customProperties = new HashMap<String, Object>();

    public DocumentMetadata contentType(@Nullable String contentType) {
        this.contentType = contentType;
        return this;
    }

    @Nullable
    @JsonProperty(value="contentType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContentType() {
        return this.contentType;
    }

    @JsonProperty(value="contentType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContentType(@Nullable String contentType) {
        this.contentType = contentType;
    }

    public DocumentMetadata fileName(@Nullable String fileName) {
        this.fileName = fileName;
        return this;
    }

    @Nullable
    @JsonProperty(value="fileName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFileName() {
        return this.fileName;
    }

    @JsonProperty(value="fileName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFileName(@Nullable String fileName) {
        this.fileName = fileName;
    }

    public DocumentMetadata expiresAt(@Nullable String expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="expiresAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExpiresAt() {
        return this.expiresAt;
    }

    @JsonProperty(value="expiresAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpiresAt(@Nullable String expiresAt) {
        this.expiresAt = expiresAt;
    }

    public DocumentMetadata size(@Nullable Long size) {
        this.size = size;
        return this;
    }

    @Nullable
    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getSize() {
        return this.size;
    }

    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSize(@Nullable Long size) {
        this.size = size;
    }

    public DocumentMetadata processDefinitionId(@Nullable String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Nullable
    @JsonProperty(value="processDefinitionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    @JsonProperty(value="processDefinitionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProcessDefinitionId(@Nullable String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public DocumentMetadata processInstanceKey(@Nullable String processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
        return this;
    }

    @Nullable
    @JsonProperty(value="processInstanceKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    @JsonProperty(value="processInstanceKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProcessInstanceKey(@Nullable String processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
    }

    public DocumentMetadata customProperties(@Nullable Map<String, Object> customProperties) {
        this.customProperties = customProperties;
        return this;
    }

    public DocumentMetadata putCustomPropertiesItem(String key, Object customPropertiesItem) {
        if (this.customProperties == null) {
            this.customProperties = new HashMap<String, Object>();
        }
        this.customProperties.put(key, customPropertiesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="customProperties")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    @JsonProperty(value="customProperties")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomProperties(@Nullable Map<String, Object> customProperties) {
        this.customProperties = customProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentMetadata documentMetadata = (DocumentMetadata)o;
        return Objects.equals(this.contentType, documentMetadata.contentType) && Objects.equals(this.fileName, documentMetadata.fileName) && Objects.equals(this.expiresAt, documentMetadata.expiresAt) && Objects.equals(this.size, documentMetadata.size) && Objects.equals(this.processDefinitionId, documentMetadata.processDefinitionId) && Objects.equals(this.processInstanceKey, documentMetadata.processInstanceKey) && Objects.equals(this.customProperties, documentMetadata.customProperties);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.fileName, this.expiresAt, this.size, this.processDefinitionId, this.processInstanceKey, this.customProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentMetadata {\n");
        sb.append("    contentType: ").append(this.toIndentedString(this.contentType)).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.fileName)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    processInstanceKey: ").append(this.toIndentedString(this.processInstanceKey)).append("\n");
        sb.append("    customProperties: ").append(this.toIndentedString(this.customProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getContentType() != null) {
            try {
                joiner.add(String.format("%scontentType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getContentType()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getFileName() != null) {
            try {
                joiner.add(String.format("%sfileName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getFileName()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getExpiresAt() != null) {
            try {
                joiner.add(String.format("%sexpiresAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getExpiresAt()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getSize() != null) {
            try {
                joiner.add(String.format("%ssize%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getSize()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getProcessDefinitionId() != null) {
            try {
                joiner.add(String.format("%sprocessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getProcessInstanceKey() != null) {
            try {
                joiner.add(String.format("%sprocessInstanceKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getProcessInstanceKey()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getCustomProperties() != null) {
            for (String _key : this.getCustomProperties().keySet()) {
                try {
                    joiner.add(String.format("%scustomProperties%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getCustomProperties().get(_key), URLEncoder.encode(String.valueOf(this.getCustomProperties().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return joiner.toString();
    }
}

