/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum ResourceTypeEnum {
    AUTHORIZATION("AUTHORIZATION"),
    MAPPING_RULE("MAPPING_RULE"),
    MESSAGE("MESSAGE"),
    BATCH("BATCH"),
    COMPONENT("COMPONENT"),
    SYSTEM("SYSTEM"),
    TENANT("TENANT"),
    RESOURCE("RESOURCE"),
    PROCESS_DEFINITION("PROCESS_DEFINITION"),
    DECISION_REQUIREMENTS_DEFINITION("DECISION_REQUIREMENTS_DEFINITION"),
    DECISION_DEFINITION("DECISION_DEFINITION"),
    GROUP("GROUP"),
    USER("USER"),
    ROLE("ROLE"),
    DOCUMENT("DOCUMENT"),
    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    private ResourceTypeEnum(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static ResourceTypeEnum fromValue(String value) {
        for (ResourceTypeEnum b : ResourceTypeEnum.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        return UNKNOWN_DEFAULT_OPEN_API;
    }

    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        return String.format("%s=%s", prefix, this.toString());
    }
}

