/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.util;

import com.aayushatharva.brotli4j.Brotli4jLoader;
import io.gatling.http.client.uri.Uri;
import io.gatling.jdk.util.StringBuilderPool;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ThreadLocalRandom;

public final class HttpUtils {
    private static final String CONTENT_TYPE_CHARSET_ATTRIBUTE = "charset=";
    private static final String CONTENT_TYPE_BOUNDARY_ATTRIBUTE = "boundary=";
    private static final String BROTLI_ACCEPT_ENCODING_SUFFIX = ", br";
    private static final byte[] MULTIPART_CHARS = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".getBytes(StandardCharsets.US_ASCII);

    private HttpUtils() {
    }

    public static String hostHeader(Uri uri) {
        String string = uri.getHost();
        int n = uri.getPort();
        return n == -1 || n == uri.getSchemeDefaultPort() ? string : string + ":" + n;
    }

    public static String originHeader(String string) {
        if (string.startsWith("http://") || string.startsWith("https://") || string.startsWith("ws://") || string.startsWith("wss://")) {
            Uri uri;
            try {
                uri = Uri.create(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
            StringBuilder stringBuilder = StringBuilderPool.DEFAULT.get();
            stringBuilder.append(uri.isSecured() ? "https://" : "http://").append(uri.getHost());
            if (uri.getExplicitPort() != uri.getSchemeDefaultPort()) {
                stringBuilder.append(':').append(uri.getPort());
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public static Charset extractContentTypeCharsetAttribute(String string) {
        String string2 = HttpUtils.extractContentTypeAttribute(string, CONTENT_TYPE_CHARSET_ATTRIBUTE);
        return string2 != null ? Charset.forName(string2) : null;
    }

    public static String extractContentTypeBoundaryAttribute(String string) {
        return HttpUtils.extractContentTypeAttribute(string, CONTENT_TYPE_BOUNDARY_ATTRIBUTE);
    }

    private static String extractContentTypeAttribute(String string, String string2) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c;
            int n;
            int n2;
            if (!string.regionMatches(true, i, string2, 0, string2.length())) continue;
            for (n2 = i + string2.length(); n2 < string.length() && ((n = string.charAt(n2)) == 32 || n == 39 || n == 34); ++n2) {
            }
            if (n2 == string.length()) break;
            for (n = n2 + 1; n < string.length() && (c = string.charAt(n)) != ' ' && c != '\'' && c != '\"' && c != ';'; ++n) {
            }
            return string.substring(n2, n);
        }
        return null;
    }

    public static byte[] computeMultipartBoundary() {
        ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
        byte[] byArray = new byte[35];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = MULTIPART_CHARS[threadLocalRandom.nextInt(MULTIPART_CHARS.length)];
        }
        return byArray;
    }

    public static String patchContentTypeWithBoundaryAttribute(CharSequence charSequence, byte[] byArray) {
        StringBuilder stringBuilder = StringBuilderPool.DEFAULT.get().append(charSequence);
        if (charSequence.length() != 0 && charSequence.charAt(charSequence.length() - 1) != ';') {
            stringBuilder.append(';');
        }
        return stringBuilder.append(' ').append(CONTENT_TYPE_BOUNDARY_ATTRIBUTE).append(new String(byArray, StandardCharsets.US_ASCII)).toString();
    }

    public static String filterOutBrotliFromAcceptEncodingWhenUnavailable(String string) {
        if (!Brotli4jLoader.isAvailable() && string.endsWith(BROTLI_ACCEPT_ENCODING_SUFFIX)) {
            return string.substring(0, string.length() - BROTLI_ACCEPT_ENCODING_SUFFIX.length());
        }
        return null;
    }

    public static boolean isConnectionClose(HttpHeaders httpHeaders) {
        return httpHeaders.contains((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.CLOSE, true);
    }
}

