/*
 * Decompiled with CFR 0.152.
 */
package io.github.biezhi.anima;

import io.github.biezhi.anima.Model;
import io.github.biezhi.anima.core.AnimaQuery;
import io.github.biezhi.anima.core.Atomic;
import io.github.biezhi.anima.core.ResultKey;
import io.github.biezhi.anima.core.dml.Delete;
import io.github.biezhi.anima.core.dml.Select;
import io.github.biezhi.anima.core.dml.Update;
import io.github.biezhi.anima.core.functions.TypeFunction;
import io.github.biezhi.anima.dialect.Dialect;
import io.github.biezhi.anima.dialect.MySQLDialect;
import io.github.biezhi.anima.enums.ErrorCode;
import io.github.biezhi.anima.exception.AnimaException;
import io.github.biezhi.anima.utils.AnimaUtils;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sql2o.Sql2o;
import org.sql2o.converters.Converter;
import org.sql2o.quirks.Quirks;
import org.sql2o.quirks.QuirksDetector;

public class Anima {
    private static final Logger log = LoggerFactory.getLogger(Anima.class);
    private Sql2o sql2o;
    private String tablePrefix;
    private Dialect dialect = new MySQLDialect();
    private Class<? extends Exception> rollbackException = RuntimeException.class;
    private boolean enableSQLStatistic = true;
    private boolean useSQLLimit = true;
    private static Anima instance;

    @Deprecated
    public static Anima me() {
        return Anima.of();
    }

    public static Anima of() {
        if (null == Anima.instance.sql2o) {
            throw new AnimaException(ErrorCode.SQL2O_IS_NULL);
        }
        return instance;
    }

    public Anima(Sql2o sql2o) {
        Anima.open(sql2o);
    }

    public Anima(DataSource dataSource) {
        Anima.open(dataSource);
    }

    public Anima(String url, String user, String pass) {
        Anima.open(url, user, pass);
    }

    public static Anima open(Sql2o sql2o) {
        Anima anima = new Anima();
        anima.setSql2o(sql2o);
        instance = anima;
        return anima;
    }

    public static Anima open(String url) {
        return Anima.open(url, null, null);
    }

    public static Anima open(String url, Quirks quirks) {
        return Anima.open(url, null, null, quirks);
    }

    public static Anima open(DataSource dataSource) {
        return Anima.open(new Sql2o(dataSource));
    }

    public static Anima open(DataSource dataSource, Quirks quirks) {
        return Anima.open(new Sql2o(dataSource, quirks));
    }

    public static Anima open(String url, String user, String pass) {
        return Anima.open(url, user, pass, QuirksDetector.forURL(url));
    }

    public static Anima open(String url, String user, String pass, Quirks quirks) {
        return Anima.open(new Sql2o(url, user, pass, quirks));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Atomic atomic(Runnable runnable) {
        try {
            AnimaQuery.beginTransaction();
            runnable.run();
            AnimaQuery.commit();
            Atomic atomic = Atomic.ok();
            return atomic;
        }
        catch (Exception e) {
            boolean isRollback = false;
            if (Anima.me().rollbackException.isInstance(e)) {
                AnimaQuery.rollback();
                isRollback = true;
            }
            Atomic atomic = Atomic.error(e).rollback(isRollback);
            return atomic;
        }
        finally {
            AnimaQuery.endTransaction();
        }
    }

    public Anima rollbackException(Class<? extends Exception> rollbackException) {
        this.rollbackException = rollbackException;
        return this;
    }

    public Anima tablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
        return this;
    }

    public Anima dialect(Dialect dialect) {
        this.dialect = dialect;
        return this;
    }

    public Anima enableSQLStatistic(boolean enableSQLStatistic) {
        this.enableSQLStatistic = enableSQLStatistic;
        return this;
    }

    public Anima useSQLLimit(boolean useSQLLimit) {
        this.useSQLLimit = useSQLLimit;
        return this;
    }

    public Anima addConverter(Converter<?> ... converters) {
        if (null == converters || converters.length == 0) {
            throw new AnimaException("converters not be null.");
        }
        for (Converter<?> converter : converters) {
            Type[] types = converter.getClass().getGenericInterfaces();
            Type[] params = ((ParameterizedType)types[0]).getActualTypeArguments();
            Class type = (Class)params[0];
            this.sql2o.getQuirks().addConverter(type, converter);
        }
        return this;
    }

    public static Select select() {
        return new Select();
    }

    public static Select select(String columns) {
        return new Select(columns);
    }

    @SafeVarargs
    public static <T extends Model, R> Select select(TypeFunction<T, R> ... functions) {
        return Anima.select(Arrays.stream(functions).map(AnimaUtils::getLambdaColumnName).collect(Collectors.joining(", ")));
    }

    public static Update update() {
        return new Update();
    }

    public static Delete delete() {
        return new Delete();
    }

    public static <T extends Model> ResultKey save(T model) {
        return model.save();
    }

    public static <T extends Model> void saveBatch(List<T> models) {
        Anima.atomic(() -> {
            for (Model model : models) {
                Anima.save(model);
            }
        }).catchException(e -> log.error("Batch save model error, message: {}", (Throwable)e));
    }

    @SafeVarargs
    public static <T extends Model, S extends Serializable> void deleteBatch(Class<T> model, S ... ids) {
        AnimaQuery animaQuery = new AnimaQuery(model);
        Anima.atomic(() -> Arrays.stream(ids).forEach(animaQuery::deleteById)).catchException(e -> log.error("Batch save model error, message: {}", (Throwable)e));
    }

    public static <T extends Model, S extends Serializable> void deleteBatch(Class<T> model, List<S> idList) {
        Anima.deleteBatch(model, (Serializable[])((Serializable[])AnimaUtils.toArray(idList)));
    }

    public static <T extends Model> int deleteById(Class<T> model, Serializable id) {
        return new AnimaQuery<T>(model).deleteById(id);
    }

    public static int execute(String sql, Object ... params) {
        return new AnimaQuery().execute(sql, params);
    }

    private Anima() {
    }

    public Sql2o getSql2o() {
        return this.sql2o;
    }

    public void setSql2o(Sql2o sql2o) {
        this.sql2o = sql2o;
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public void setRollbackException(Class<? extends Exception> rollbackException) {
        this.rollbackException = rollbackException;
    }

    public boolean isEnableSQLStatistic() {
        return this.enableSQLStatistic;
    }

    public boolean isUseSQLLimit() {
        return this.useSQLLimit;
    }
}

