/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.quirks;

import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sql2o.converters.Convert;
import org.sql2o.converters.Converter;
import org.sql2o.converters.java8.LocalDateConverter;
import org.sql2o.converters.java8.LocalDateTimeConverter;
import org.sql2o.quirks.Quirks;

public class NoQuirks
implements Quirks {
    private static final Logger log = LoggerFactory.getLogger(NoQuirks.class);
    protected final Map<Class<?>, Converter<?>> converters;

    public NoQuirks(Map<Class<?>, Converter<?>> converters) {
        this.converters = new HashMap(converters);
    }

    public NoQuirks() {
        this.converters = new HashMap();
        this.converters.put(LocalDate.class, new LocalDateConverter());
        this.converters.put(LocalDateTime.class, new LocalDateTimeConverter());
    }

    @Override
    public <E> Converter<E> converterOf(Class<E> ofClass) {
        Converter<?> c = this.converters.get(ofClass);
        return c != null ? c : Convert.getConverterIfExists(ofClass);
    }

    @Override
    public void addConverter(Class<?> type, Converter<?> converter) {
        log.info("add converter [{}] {}", (Object)type.getName(), converter);
        if (this.converters.containsKey(type)) {
            this.converters.remove(type);
        }
        this.converters.put(type, converter);
    }

    @Override
    public String getColumnName(ResultSetMetaData meta, int colIdx) throws SQLException {
        return meta.getColumnLabel(colIdx);
    }

    @Override
    public boolean returnGeneratedKeysByDefault() {
        return true;
    }

    @Override
    public void setParameter(PreparedStatement statement, int paramIdx, Object value) throws SQLException {
        statement.setObject(paramIdx, value);
    }

    @Override
    public void setParameter(PreparedStatement statement, int paramIdx, InputStream value) throws SQLException {
        statement.setBinaryStream(paramIdx, value);
    }

    @Override
    public void setParameter(PreparedStatement statement, int paramIdx, int value) throws SQLException {
        statement.setInt(paramIdx, value);
    }

    @Override
    public void setParameter(PreparedStatement statement, int paramIdx, Integer value) throws SQLException {
        if (value == null) {
            statement.setNull(paramIdx, 4);
        } else {
            statement.setInt(paramIdx, value);
        }
    }

    @Override
    public void setParameter(PreparedStatement statement, int paramIdx, long value) throws SQLException {
        statement.setLong(paramIdx, value);
    }

    @Override
    public void setParameter(PreparedStatement statement, int paramIdx, Long value) throws SQLException {
        if (value == null) {
            statement.setNull(paramIdx, -5);
        } else {
            statement.setLong(paramIdx, value);
        }
    }

    @Override
    public void setParameter(PreparedStatement statement, int paramIdx, String value) throws SQLException {
        if (value == null) {
            statement.setNull(paramIdx, 12);
        } else {
            statement.setString(paramIdx, value);
        }
    }

    @Override
    public void setParameter(PreparedStatement statement, int paramIdx, Timestamp value) throws SQLException {
        if (value == null) {
            statement.setNull(paramIdx, 93);
        } else {
            statement.setTimestamp(paramIdx, value);
        }
    }

    @Override
    public void setParameter(PreparedStatement statement, int paramIdx, Time value) throws SQLException {
        if (value == null) {
            statement.setNull(paramIdx, 92);
        } else {
            statement.setTime(paramIdx, value);
        }
    }

    @Override
    public void setParameter(PreparedStatement statement, int paramIdx, Boolean value) throws SQLException {
        if (value == null) {
            statement.setNull(paramIdx, 16);
        } else {
            statement.setBoolean(paramIdx, value);
        }
    }

    @Override
    public void setParameter(PreparedStatement statement, int paramIdx, UUID value) throws SQLException {
        statement.setObject(paramIdx, value);
    }

    @Override
    public void setParameter(PreparedStatement statement, int paramIdx, boolean value) throws SQLException {
        statement.setBoolean(paramIdx, value);
    }

    @Override
    public Object getRSVal(ResultSet rs, int idx) throws SQLException {
        return rs.getObject(idx);
    }

    @Override
    public void closeStatement(Statement statement) throws SQLException {
        statement.close();
    }
}

