/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.quirks;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.sql2o.converters.Converter;
import org.sql2o.converters.OracleUUIDConverter;
import org.sql2o.quirks.NoQuirks;

public class OracleQuirks
extends NoQuirks {
    public OracleQuirks() {
        super(new HashMap<Class<?>, Converter<?>>(){
            {
                this.put(UUID.class, new OracleUUIDConverter());
            }
        });
    }

    public OracleQuirks(Map<Class<?>, Converter<?>> converters) {
        super(converters);
    }

    @Override
    public Object getRSVal(ResultSet rs, int idx) throws SQLException {
        Object o = super.getRSVal(rs, idx);
        if (o != null && o.getClass().getCanonicalName().startsWith("oracle.sql.TIMESTAMP")) {
            o = rs.getTimestamp(idx);
        }
        return o;
    }

    @Override
    public boolean returnGeneratedKeysByDefault() {
        return false;
    }

    @Override
    public void setParameter(PreparedStatement statement, int paramIdx, UUID value) throws SQLException {
        statement.setBytes(paramIdx, (byte[])new OracleUUIDConverter().toDatabaseParam(value));
    }
}

