/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.quirks;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.sql2o.quirks.Db2QuirksProvider;
import org.sql2o.quirks.NoQuirks;
import org.sql2o.quirks.OracleQuirksProvider;
import org.sql2o.quirks.PostgresQuirksProvider;
import org.sql2o.quirks.Quirks;
import org.sql2o.quirks.QuirksProvider;

public class QuirksDetector {
    static final List<QuirksProvider> providers = new ArrayList<QuirksProvider>();

    public static Quirks forURL(String jdbcUrl) {
        for (QuirksProvider quirksProvider : providers) {
            if (!quirksProvider.isUsableForUrl(jdbcUrl)) continue;
            return quirksProvider.provide();
        }
        return new NoQuirks();
    }

    public static Quirks forObject(Object jdbcObject) {
        String jdbcObjectClassName = jdbcObject.getClass().getName().contains("$") ? jdbcObject.getClass().getSuperclass().getCanonicalName() : jdbcObject.getClass().getCanonicalName();
        for (QuirksProvider quirksProvider : ServiceLoader.load(QuirksProvider.class)) {
            if (!quirksProvider.isUsableForClass(jdbcObjectClassName)) continue;
            return quirksProvider.provide();
        }
        return new NoQuirks();
    }

    static {
        providers.add(new PostgresQuirksProvider());
        providers.add(new OracleQuirksProvider());
        providers.add(new Db2QuirksProvider());
    }
}

