/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.reflection;

import io.github.biezhi.anima.annotation.Column;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.sql2o.Sql2oException;
import org.sql2o.reflection.FactoryFacade;
import org.sql2o.reflection.Getter;
import org.sql2o.reflection.ObjectConstructor;
import org.sql2o.reflection.Setter;
import org.sql2o.tools.AbstractCache;
import org.sql2o.tools.UnderscoreToCamelCase;

public class PojoMetadata {
    private static final Cache caseSensitiveFalse = new Cache();
    private static final Cache caseSensitiveTrue = new Cache();
    private final PropertyAndFieldInfo propertyInfo;
    private final Map<String, String> columnMappings;
    private final FactoryFacade factoryFacade = FactoryFacade.getInstance();
    private boolean caseSensitive;
    private boolean autoDeriveColumnNames;
    public final boolean throwOnMappingFailure;
    private Class<?> clazz;

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isAutoDeriveColumnNames() {
        return this.autoDeriveColumnNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PojoMetadata that = (PojoMetadata)o;
        return this.autoDeriveColumnNames == that.autoDeriveColumnNames && this.caseSensitive == that.caseSensitive && this.clazz.equals(that.clazz) && this.columnMappings.equals(that.columnMappings) && this.propertyInfo.equals(that.propertyInfo);
    }

    public int hashCode() {
        int result = this.caseSensitive ? 1 : 0;
        result = 31 * result + this.clazz.hashCode();
        return result;
    }

    public PojoMetadata(Class<?> clazz, boolean caseSensitive, boolean autoDeriveColumnNames, Map<String, String> columnMappings, boolean throwOnMappingError) {
        this.caseSensitive = caseSensitive;
        this.autoDeriveColumnNames = autoDeriveColumnNames;
        this.clazz = clazz;
        this.columnMappings = columnMappings == null ? Collections.emptyMap() : columnMappings;
        this.propertyInfo = this.getPropertyInfoThroughCache();
        this.throwOnMappingFailure = throwOnMappingError;
    }

    public ObjectConstructor getObjectConstructor() {
        return this.propertyInfo.objectConstructor;
    }

    private PropertyAndFieldInfo getPropertyInfoThroughCache() {
        return (PropertyAndFieldInfo)(this.caseSensitive ? caseSensitiveTrue : caseSensitiveFalse).get(this.clazz, this);
    }

    private PropertyAndFieldInfo initializePropertyInfo() {
        HashMap<String, Getter> propertyGetters = new HashMap<String, Getter>();
        HashMap<String, Setter> propertySetters = new HashMap<String, Setter>();
        HashMap<String, Field> fields = new HashMap<String, Field>();
        Class<?> theClass = this.clazz;
        ObjectConstructor objectConstructor = this.factoryFacade.newConstructor(theClass);
        do {
            String propertyName;
            boolean isJpaColumnInClasspath = true;
            for (Field field : theClass.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                propertyName = this.readAnnotatedColumnName(field, true);
                if (propertyName == null) {
                    propertyName = field.getName();
                }
                propertyName = this.caseSensitive ? propertyName : propertyName.toLowerCase();
                propertyGetters.put(propertyName, this.factoryFacade.newGetter(field));
                propertySetters.put(propertyName, this.factoryFacade.newSetter(field));
                fields.put(propertyName, field);
            }
            for (AccessibleObject accessibleObject : theClass.getDeclaredMethods()) {
                if (((Method)accessibleObject).getName().startsWith("get")) {
                    propertyName = ((Method)accessibleObject).getName().substring(3);
                    propertyName = this.caseSensitive ? propertyName.substring(0, 1).toLowerCase() + propertyName.substring(1) : propertyName.toLowerCase();
                    propertyGetters.put(propertyName, this.factoryFacade.newGetter((Method)accessibleObject));
                }
                if (!((Method)accessibleObject).getName().startsWith("set") || ((Method)accessibleObject).getParameterTypes().length != 1) continue;
                propertyName = this.readAnnotatedColumnName(accessibleObject, isJpaColumnInClasspath);
                if (propertyName == null) {
                    propertyName = ((Method)accessibleObject).getName().substring(3);
                }
                propertyName = this.caseSensitive ? propertyName.substring(0, 1).toLowerCase() + propertyName.substring(1) : propertyName.toLowerCase();
                propertySetters.put(propertyName, this.factoryFacade.newSetter((Method)accessibleObject));
            }
        } while (!(theClass = theClass.getSuperclass()).equals(Object.class));
        return new PropertyAndFieldInfo(propertyGetters, propertySetters, objectConstructor);
    }

    public Map<String, String> getColumnMappings() {
        return this.columnMappings;
    }

    public Getter getPropertyGetter(String propertyName) {
        Getter getter = this.getPropertyGetterIfExists(propertyName);
        if (getter != null) {
            return getter;
        }
        String errorMsg = "Property with name '" + propertyName + "' not found on class " + this.clazz.toString();
        if (this.caseSensitive) {
            errorMsg = errorMsg + " (You have turned on case sensitive property search. Is this intentional?)";
        }
        throw new Sql2oException(errorMsg);
    }

    public Getter getPropertyGetterIfExists(String propertyName) {
        String name;
        String string = name = this.caseSensitive ? propertyName : propertyName.toLowerCase();
        if (this.columnMappings.containsKey(name)) {
            name = this.columnMappings.get(name);
        }
        if (this.autoDeriveColumnNames) {
            name = UnderscoreToCamelCase.convert(name);
            if (!this.caseSensitive) {
                name = name.toLowerCase();
            }
        }
        return this.propertyInfo.propertyGetters.get(name);
    }

    public Setter getPropertySetter(String propertyName) {
        Setter setter = this.getPropertySetterIfExists(propertyName);
        if (setter != null) {
            return setter;
        }
        String errorMsg = "Property with name '" + propertyName + "' not found on class " + this.clazz.toString();
        if (this.caseSensitive) {
            errorMsg = errorMsg + " (You have turned on case sensitive property search. Is this intentional?)";
        }
        throw new Sql2oException(errorMsg);
    }

    public Setter getPropertySetterIfExists(String propertyName) {
        String name;
        String string = name = this.caseSensitive ? propertyName : propertyName.toLowerCase();
        if (this.columnMappings.containsKey(name)) {
            name = this.columnMappings.get(name);
        }
        if (this.autoDeriveColumnNames) {
            name = UnderscoreToCamelCase.convert(name);
            if (!this.caseSensitive) {
                name = name.toLowerCase();
            }
        }
        return this.propertyInfo.propertySetters.get(name);
    }

    public Class<?> getType() {
        return this.clazz;
    }

    public Object getValueOfProperty(String propertyName, Object object) {
        Getter getter = this.getPropertyGetter(propertyName);
        return getter.getProperty(object);
    }

    private String readAnnotatedColumnName(AnnotatedElement classMember, boolean isJpaColumnInClasspath) {
        Column columnInformation;
        if (isJpaColumnInClasspath && (columnInformation = classMember.getAnnotation(Column.class)) != null && !columnInformation.name().isEmpty()) {
            return columnInformation.name();
        }
        return null;
    }

    private static class PropertyAndFieldInfo {
        final Map<String, Getter> propertyGetters;
        final Map<String, Setter> propertySetters;
        final ObjectConstructor objectConstructor;

        private PropertyAndFieldInfo(Map<String, Getter> propertyGetters, Map<String, Setter> propertySetters, ObjectConstructor objectConstructor) {
            this.propertyGetters = propertyGetters;
            this.propertySetters = propertySetters;
            this.objectConstructor = objectConstructor;
        }
    }

    private static class Cache
    extends AbstractCache<Class<?>, PropertyAndFieldInfo, PojoMetadata> {
        private Cache() {
        }

        @Override
        protected PropertyAndFieldInfo evaluate(Class<?> key, PojoMetadata param) {
            return param.initializePropertyInfo();
        }
    }
}

