/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.tools;

import org.sql2o.tools.ClassUtils;

public final class FeatureDetector {
    private static Boolean oracleAvailable;
    private static boolean cacheUnderscoreToCamelcaseEnabled;

    private FeatureDetector() {
    }

    public static boolean isOracleAvailable() {
        if (oracleAvailable == null) {
            oracleAvailable = ClassUtils.isPresent("oracle.sql.TIMESTAMP");
        }
        return oracleAvailable;
    }

    public static boolean isCacheUnderscoreToCamelcaseEnabled() {
        return cacheUnderscoreToCamelcaseEnabled;
    }

    public static void setCacheUnderscoreToCamelcaseEnabled(boolean cacheUnderscoreToCamelcaseEnabled) {
        FeatureDetector.cacheUnderscoreToCamelcaseEnabled = cacheUnderscoreToCamelcaseEnabled;
    }

    static {
        FeatureDetector.setCacheUnderscoreToCamelcaseEnabled(true);
    }
}

