/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.util;

import com.ruiyun.jvppeteer.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownloadUtil.class);
    private static final int THREAD_COUNT = 5;
    private static final int CHUNK_SIZE = 0x500000;
    private static final int RETRY_TIMES = 5;
    public static final int READ_TIME_OUT = 10000;
    public static final int CONNECT_TIME_OUT = 10000;
    private static final String FAIL_RESULT = "-1";

    public static void download(String url, String filePath, BiConsumer<Integer, Integer> progressCallback) throws IOException, ExecutionException, InterruptedException {
        long contentLength = DownloadUtil.getContentLength(url);
        long taskCount = contentLength % 0x500000L == 0L ? contentLength / 0x500000L : contentLength / 0x500000L + 1L;
        DownloadUtil.createFile(filePath, contentLength);
        ThreadPoolExecutor executor = DownloadUtil.getExecutor();
        ExecutorCompletionService<String> completionService = new ExecutorCompletionService<String>(executor);
        ArrayList<Future<String>> futureList = new ArrayList<Future<String>>();
        int downloadCount = 0;
        if (contentLength <= 0x500000L) {
            Future<String> future = completionService.submit(new DownloadCallable(0L, contentLength, filePath, url));
            futureList.add(future);
        } else {
            int i = 0;
            while ((long)i < taskCount) {
                Future<String> future;
                if ((long)i == taskCount - 1L) {
                    future = completionService.submit(new DownloadCallable(i * 0x500000, contentLength, filePath, url));
                    futureList.add(future);
                } else {
                    future = completionService.submit(new DownloadCallable(i * 0x500000, (i + 1) * 0x500000, filePath, url));
                    futureList.add(future);
                }
                ++i;
            }
        }
        executor.shutdown();
        for (Future<String> future : futureList) {
            String result = (String)future.get();
            if (FAIL_RESULT.equals(result)) {
                LOGGER.error("download fail,url:" + url);
                Files.delete(Paths.get(filePath, new String[0]));
                executor.shutdownNow();
                continue;
            }
            try {
                downloadCount += Integer.parseInt(result);
                if (progressCallback == null) continue;
                progressCallback.accept(downloadCount, (int)(contentLength >> 20));
            }
            catch (Exception e) {
                LOGGER.error("ProgressCallback has some problem", (Throwable)e);
            }
        }
    }

    public static final long getContentLength(String url) throws IOException {
        URL uuuRl = new URL(url);
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)uuuRl.openConnection();
            conn.setRequestMethod("HEAD");
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(10000);
            conn.connect();
            int responseCode = conn.getResponseCode();
            if (responseCode >= 200 && responseCode <= 204) {
                long l = conn.getContentLengthLong();
                return l;
            }
            throw new RuntimeException(url + " responseCode: " + responseCode);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public static ThreadPoolExecutor getExecutor() {
        return new ThreadPoolExecutor(5, 5, 30000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public static void createFile(String path, long length) throws IOException {
        File file = new File(path);
        if (file.exists()) {
            FileUtil.createNewFile(file);
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(path, "rw");
        randomAccessFile.setLength(length);
        randomAccessFile.close();
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }

    static class DownloadCallable
    implements Callable<String> {
        private long startPosition;
        private long endPosition;
        private String filePath;
        private String url;

        public DownloadCallable(long startPosition, long endPosition, String filePath, String url) {
            this.startPosition = startPosition;
            this.endPosition = endPosition;
            this.filePath = filePath;
            this.url = url;
        }

        /*
         * Exception decompiling
         */
        @Override
        public String call() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[FORLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

