/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaoding.open.factory;

import io.github.gaoding.open.GDOpenApi;
import io.github.gaoding.open.client.Client;
import io.github.gaoding.open.constant.BizCode;
import io.github.gaoding.open.factory.GDOpenApiFactoryApi;
import io.github.gaoding.open.model.Config;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;

public final class GDOpenApiFactory {
    private static final AtomicReference<Client> CLIENT = new AtomicReference();

    private GDOpenApiFactory() {
    }

    public static synchronized Client getOrCreateClient(Config config) {
        if (CLIENT.get() != null) {
            return CLIENT.get();
        }
        ServiceLoader<GDOpenApiFactoryApi> shouts = ServiceLoader.load(GDOpenApiFactoryApi.class);
        GDOpenApiFactoryApi factoryApi = null;
        Iterator<GDOpenApiFactoryApi> iterator = shouts.iterator();
        while (iterator.hasNext()) {
            GDOpenApiFactoryApi shout;
            factoryApi = shout = iterator.next();
        }
        if (factoryApi == null) {
            throw new RuntimeException(BizCode.INIT_CLIENT_ERROR.getMessage());
        }
        Client client = factoryApi.createClient(config);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                client.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }));
        CLIENT.set(client);
        return client;
    }

    public static GDOpenApi createApiInstance(Config config) {
        config.check();
        GDOpenApiFactory.getOrCreateClient(config);
        ServiceLoader<GDOpenApi> apis = ServiceLoader.load(GDOpenApi.class);
        GDOpenApi openApi = null;
        Iterator<GDOpenApi> iterator = apis.iterator();
        while (iterator.hasNext()) {
            GDOpenApi shout;
            openApi = shout = iterator.next();
        }
        if (openApi == null) {
            throw new RuntimeException(BizCode.INIT_CLIENT_ERROR.getMessage());
        }
        return openApi;
    }
}

