/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaoding.open.impl;

import io.github.gaoding.open.impl.HttpClient;
import io.github.gaoding.open.model.Config;
import io.github.gaoding.open.model.HttpRequestEntity;
import io.github.gaoding.open.model.HttpResponse;
import java.net.SocketTimeoutException;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;

public class ApacheHttpClient
extends HttpClient {
    private final RequestConfig requestConfig;
    private final PoolingHttpClientConnectionManager httpClientConnectionManager = new PoolingHttpClientConnectionManager();
    private final HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
    private final CloseableHttpClient client;

    public ApacheHttpClient(Config conf) {
        super(conf);
        this.requestConfig = RequestConfig.custom().setSocketTimeout(conf.getReadTimeOut()).setConnectTimeout(conf.getConnectTimeout()).build();
        this.httpClientConnectionManager.setMaxTotal(conf.getMaxConnection().intValue());
        this.httpClientConnectionManager.setDefaultMaxPerRoute(conf.getMaxConcurrency().intValue());
        this.httpClientBuilder.setConnectionManager((HttpClientConnectionManager)this.httpClientConnectionManager);
        this.client = this.httpClientBuilder.build();
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.client.close();
    }

    @Override
    protected Function<? super HttpRequestEntity, ? extends HttpResponse> doSend() {
        return request -> {
            HttpGet httpRequest;
            String method = request.getMethod();
            StringEntity stringEntity = new StringEntity(StringUtils.defaultString((String)request.getBody()), "UTF-8");
            switch (method) {
                case "GET": {
                    httpRequest = new HttpGet(request.getUrl());
                    break;
                }
                case "POST": {
                    httpRequest = new HttpPost(request.getUrl());
                    ((HttpPost)httpRequest).setEntity((HttpEntity)stringEntity);
                    break;
                }
                case "PUT": {
                    httpRequest = new HttpPut(request.getUrl());
                    ((HttpPut)httpRequest).setEntity((HttpEntity)stringEntity);
                    break;
                }
                case "DELETE": {
                    httpRequest = new HttpDelete(request.getUrl());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid HTTP method: " + method);
                }
            }
            httpRequest.setConfig(this.requestConfig);
            Map<String, String> headers = request.getHeaders();
            headers.forEach((arg_0, arg_1) -> ((HttpRequestBase)httpRequest).addHeader(arg_0, arg_1));
            CloseableHttpResponse execute = null;
            try {
                execute = this.client.execute((HttpUriRequest)httpRequest);
                System.out.println(httpRequest);
                HttpEntity entity = execute.getEntity();
                String responseBody = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                int statusCode = execute.getStatusLine().getStatusCode();
                execute.close();
                return new HttpResponse(statusCode, responseBody);
            }
            catch (SocketTimeoutException | ConnectTimeoutException e) {
                return new HttpResponse(-1, "{\"code\":-1,\"message\":\"\u8bf7\u6c42\u8d85\u65f6\"}");
            }
            catch (Exception e) {
                return new HttpResponse(execute != null ? execute.getStatusLine().getStatusCode() : 500, e.getMessage());
            }
        };
    }
}

