/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaoding.open.impl;

import com.alibaba.fastjson.JSON;
import io.github.gaoding.open.GDOpenApi;
import io.github.gaoding.open.client.Client;
import io.github.gaoding.open.constant.BizCode;
import io.github.gaoding.open.factory.GDOpenApiFactory;
import io.github.gaoding.open.model.HttpMethod;
import io.github.gaoding.open.model.OpenApiMethods;
import io.github.gaoding.open.model.Response;
import io.github.gaoding.open.model.auth.AuthCodeRespDto;
import io.github.gaoding.open.model.auth.GetAuthCodeReq;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DefaultGDOpenApiImpl
implements GDOpenApi {
    @Override
    public <T> Response<T> invoke(String path, HttpMethod method, Map<String, String> queryParams, String body, Class<T> clazz, boolean async, String openId) {
        if (StringUtils.isBlank((CharSequence)path) || method == null) {
            return Response.fail(BizCode.CLIENT_PARAMS_ERROR, 400);
        }
        if (queryParams == null) {
            queryParams = new HashMap<String, String>(16);
        }
        String[] split = path.split("\\?");
        try {
            if (split.length > 1) {
                String[] pairs;
                for (String pair : pairs = split[1].split("&")) {
                    int idx = pair.indexOf("=");
                    String key = URLDecoder.decode(pair.substring(0, idx), StandardCharsets.UTF_8.name());
                    String value = URLDecoder.decode(pair.substring(idx + 1), StandardCharsets.UTF_8.name());
                    queryParams.put(key, value);
                }
            }
        }
        catch (Exception e) {
            return Response.fail(BizCode.CLIENT_PARAMS_ERROR, 400);
        }
        path = split[0];
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        Client client = GDOpenApiFactory.getOrCreateClient(null);
        HashMap<String, String> headers = null;
        if (StringUtils.isNotBlank((CharSequence)openId)) {
            headers = new HashMap<String, String>(1);
            String encode = null;
            try {
                encode = URLEncoder.encode(openId, "UTF-8");
                headers.put("open-id", encode);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return client.execute(path.startsWith("/api/ops/opapi") ? path : "/api/ops/opapi" + path, method, body, queryParams, headers, clazz, async, null);
    }

    @Override
    public Response<AuthCodeRespDto> getAuthCode(GetAuthCodeReq getAuthCodeReq) {
        Client client = GDOpenApiFactory.getOrCreateClient(null);
        if (StringUtils.isBlank((CharSequence)getAuthCodeReq.getAbilityCode()) || StringUtils.isBlank((CharSequence)getAuthCodeReq.getUid())) {
            return Response.fail(BizCode.AUTH_ABILITY_UID_MUST, 400);
        }
        return client.execute(OpenApiMethods.GET_AUTH_CODE.getURI(), OpenApiMethods.GET_AUTH_CODE.getMethod(), JSON.toJSONString((Object)getAuthCodeReq), null, null, AuthCodeRespDto.class, false, response -> {
            if (!response.isSuccess()) {
                if (response.isNotAuth()) {
                    return Response.fail(BizCode.CHECK_SIGN_ERROR, 401);
                }
                Response res = (Response)JSON.parseObject((String)response.getBody(), Response.class);
                res.setHttpStatus(response.getStatus());
                return res;
            }
            Response<AuthCodeRespDto> res = new Response<AuthCodeRespDto>();
            res.setCode("0000");
            res.setMessage("success");
            res.setHttpStatus(response.getStatus());
            AuthCodeRespDto authCodeRespDto = (AuthCodeRespDto)JSON.parseObject((String)response.getBody(), AuthCodeRespDto.class);
            res.setData(authCodeRespDto);
            return res;
        });
    }
}

