/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaoding.open.util;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public final class SignatureGenerator {
    private SignatureGenerator() {
    }

    public static String generateSignature(String method, String uri, String secretKey, String requestBody, String queryString, String time) throws Exception {
        method = method.toUpperCase();
        if (!uri.endsWith("/")) {
            uri = uri + "/";
        }
        String sortedQueryString = SignatureGenerator.sortQueryString(queryString);
        String message = method + "@" + uri + "@" + sortedQueryString + "@" + time;
        if (StringUtils.isNotBlank((CharSequence)requestBody)) {
            message = message + "@" + requestBody;
        }
        System.out.println(message);
        return SignatureGenerator.encode(message, secretKey);
    }

    private static String sortQueryString(String queryString) throws UnsupportedEncodingException {
        String[] pairs;
        if (StringUtils.isBlank((CharSequence)queryString)) {
            return "";
        }
        HashMap<String, String> queryMap = new HashMap<String, String>(16);
        for (String pair : pairs = queryString.split("&")) {
            int idx = pair.indexOf("=");
            String key = pair.substring(0, idx);
            String value = pair.substring(idx + 1);
            queryMap.put(key, value);
        }
        TreeMap sortedQuery = new TreeMap(queryMap);
        StringBuilder sortedQueryString = new StringBuilder();
        for (Map.Entry entry : sortedQuery.entrySet()) {
            sortedQueryString.append((String)entry.getKey()).append("=").append((String)entry.getValue()).append("&");
        }
        if (sortedQueryString.length() > 0 && sortedQueryString.charAt(sortedQueryString.length() - 1) == '&') {
            sortedQueryString.deleteCharAt(sortedQueryString.length() - 1);
        }
        return sortedQueryString.toString();
    }

    public static String encode(String data, String key) throws Exception {
        SecretKeySpec signKey = new SecretKeySpec(key.getBytes(), "HmacSHA1");
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(signKey);
        byte[] rawHmac = mac.doFinal(data.getBytes());
        return new String(Base64.encodeBase64((byte[])rawHmac));
    }
}

