/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core.handler;

import com.dtp.common.dto.ThreadPoolStats;
import com.dtp.core.monitor.collector.LogCollector;
import com.dtp.core.monitor.collector.MetricsCollector;
import com.dtp.core.monitor.collector.MicroMeterCollector;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectorHandler {
    private static final Logger log = LoggerFactory.getLogger(CollectorHandler.class);
    private static final List<MetricsCollector> COLLECTORS = Lists.newArrayList();

    private CollectorHandler() {
        ServiceLoader<MetricsCollector> loader = ServiceLoader.load(MetricsCollector.class);
        for (MetricsCollector collector : loader) {
            COLLECTORS.add(collector);
        }
        MicroMeterCollector defaultCollector = new MicroMeterCollector();
        LogCollector logCollector = new LogCollector();
        COLLECTORS.add(defaultCollector);
        COLLECTORS.add(logCollector);
    }

    public void collect(ThreadPoolStats poolStats, String type) {
        if (poolStats == null) {
            return;
        }
        for (MetricsCollector collector : COLLECTORS) {
            if (!collector.support(type)) continue;
            collector.collect(poolStats);
            break;
        }
    }

    public static CollectorHandler getInstance() {
        return CollectorHandlerHolder.INSTANCE;
    }

    private static class CollectorHandlerHolder {
        private static final CollectorHandler INSTANCE = new CollectorHandler();

        private CollectorHandlerHolder() {
        }
    }
}

