/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import io.minio.ObjectReadArgs;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;

public class DownloadObjectArgs
extends ObjectReadArgs {
    private String filename;

    public String filename() {
        return this.filename;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DownloadObjectArgs)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DownloadObjectArgs that = (DownloadObjectArgs)o;
        return Objects.equals(this.filename, that.filename);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.filename);
    }

    public static final class Builder
    extends ObjectReadArgs.Builder<Builder, DownloadObjectArgs> {
        public Builder filename(String filename) {
            this.validateFilename(filename);
            this.operations.add(args -> ((DownloadObjectArgs)args).filename = filename);
            return this;
        }

        private void validateFilename(String filename) {
            this.validateNotEmptyString(filename, "filename");
            Path filePath = Paths.get(filename, new String[0]);
            boolean fileExists = Files.exists(filePath, new LinkOption[0]);
            if (fileExists && !Files.isRegularFile(filePath, new LinkOption[0])) {
                throw new IllegalArgumentException(filename + ": not a regular file");
            }
        }
    }
}

