/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.formatter.eclipse;

import io.spring.javaformat.formatter.eclipse.DefaultCodeFormatter;
import io.spring.javaformat.formatter.eclipse.DefaultCodeFormatterOptions;
import io.spring.javaformat.formatter.eclipse.Preparator;
import io.spring.javaformat.formatter.eclipse.Token;
import io.spring.javaformat.formatter.eclipse.TokenManager;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.parser.Scanner;

public class ExtendedCodeFormatter
extends DefaultCodeFormatter {
    private static boolean useLegacyTokenize = false;
    private final List<Preparator> preparators = new ArrayList<Preparator>();

    public ExtendedCodeFormatter() {
    }

    public ExtendedCodeFormatter(DefaultCodeFormatterOptions defaultCodeFormatterOptions, Map<String, String> options) {
        super(defaultCodeFormatterOptions, options);
    }

    public ExtendedCodeFormatter(DefaultCodeFormatterOptions options) {
        super(options);
    }

    public ExtendedCodeFormatter(Map<String, String> options) {
        super(options);
    }

    protected void addPreparator(Preparator preparator) {
        this.preparators.add(preparator);
    }

    @Override
    protected void tokenizeSource(int kind) {
        if (useLegacyTokenize) {
            this.legacyTokenizeSource(kind);
            return;
        }
        try {
            super.tokenizeSource(kind);
        }
        catch (NoSuchMethodError ex) {
            useLegacyTokenize = true;
            this.legacyTokenizeSource(kind);
        }
    }

    private void legacyTokenizeSource(int kind) {
        this.tokens.clear();
        long sourceLevel = CompilerOptions.versionToJdkLevel((String)this.sourceLevel);
        Scanner scanner = new Scanner(true, false, false, sourceLevel, (char[][])null, (char[][])null, false);
        scanner.setSource(this.sourceArray);
        scanner.fakeInModule = (kind & 0x80) != 0;
        while (true) {
            Token token;
            try {
                int tokenType;
                while ((tokenType = scanner.getNextToken()) != 62) {
                    token = Token.fromCurrent(scanner, tokenType);
                    this.tokens.add(token);
                }
            }
            catch (InvalidInputException ex) {
                token = Token.fromCurrent(scanner, 0);
                this.tokens.add(token);
                continue;
            }
            break;
        }
    }

    @Override
    protected void prepareWraps(int kind) {
        ASTNode astRoot = this.getField("astRoot", ASTNode.class);
        TokenManager tokenManager = this.getField("tokenManager", TokenManager.class);
        this.applyPreparators(Preparator.Phase.PRE_WRAPPING, kind, astRoot, tokenManager);
        super.prepareWraps(kind);
        this.applyPreparators(Preparator.Phase.POST_WRAPPING, kind, astRoot, tokenManager);
    }

    private void applyPreparators(Preparator.Phase preWrapping, int kind, ASTNode astRoot, TokenManager tokenManager) {
        this.preparators.stream().filter(preparator -> preparator.getPhase() == preWrapping).forEach(preparator -> preparator.apply(kind, tokenManager, astRoot));
    }

    private <T> T getField(String name, Class<T> type) {
        try {
            Field field = DefaultCodeFormatter.class.getDeclaredField(name);
            field.setAccessible(true);
            return (T)field.get((Object)this);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }
}

