/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import zipkin.Span;
import zipkin.internal.CorrectForClockSkew;
import zipkin.internal.MergeById;
import zipkin.internal.Pair;

public final class GroupByTraceId {
    public static final Comparator<List<Span>> TRACE_DESCENDING = new Comparator<List<Span>>(){

        @Override
        public int compare(List<Span> left, List<Span> right) {
            return right.get(0).compareTo(left.get(0));
        }
    };

    public static List<List<Span>> apply(Collection<Span> input, boolean strictTraceId, boolean adjust) {
        if (input == null || input.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashMap groupedByTraceId = new LinkedHashMap();
        for (Span span : input) {
            Pair<Long> traceId = Pair.create(strictTraceId ? span.traceIdHigh : 0L, span.traceId);
            if (!groupedByTraceId.containsKey(traceId)) {
                groupedByTraceId.put(traceId, new ArrayList());
            }
            ((List)groupedByTraceId.get(traceId)).add(span);
        }
        ArrayList<List<Span>> result = new ArrayList<List<Span>>(groupedByTraceId.size());
        for (List<Span> sameTraceId : groupedByTraceId.values()) {
            result.add(adjust ? CorrectForClockSkew.apply(MergeById.apply((Iterable<Span>)sameTraceId)) : sameTraceId);
        }
        Collections.sort(result, TRACE_DESCENDING);
        return result;
    }
}

