/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage;

import java.util.List;
import java.util.concurrent.Executor;
import zipkin.DependencyLink;
import zipkin.Span;
import zipkin.internal.Nullable;
import zipkin.internal.Util;
import zipkin.storage.AsyncSpanStore;
import zipkin.storage.Callback;
import zipkin.storage.InternalCallbackRunnable;
import zipkin.storage.QueryRequest;
import zipkin.storage.SpanStore;

final class InternalBlockingToAsyncSpanStoreAdapter
implements AsyncSpanStore {
    final SpanStore delegate;
    final Executor executor;

    InternalBlockingToAsyncSpanStoreAdapter(SpanStore delegate, Executor executor) {
        this.delegate = Util.checkNotNull(delegate, "delegate");
        this.executor = Util.checkNotNull(executor, "executor");
    }

    @Override
    public void getTraces(final QueryRequest request, Callback<List<List<Span>>> callback) {
        this.executor.execute(new InternalCallbackRunnable<List<List<Span>>>(callback){

            @Override
            List<List<Span>> complete() {
                return InternalBlockingToAsyncSpanStoreAdapter.this.delegate.getTraces(request);
            }

            public String toString() {
                return "GetTraces(" + request + ")";
            }
        });
    }

    @Override
    public void getTrace(long id, Callback<List<Span>> callback) {
        this.getTrace(0L, id, callback);
    }

    @Override
    public void getTrace(final long traceIdHigh, final long traceIdLow, Callback<List<Span>> callback) {
        this.executor.execute(new InternalCallbackRunnable<List<Span>>(callback){

            @Override
            List<Span> complete() {
                return InternalBlockingToAsyncSpanStoreAdapter.this.delegate.getTrace(traceIdHigh, traceIdLow);
            }

            public String toString() {
                return "getTrace(" + Util.toLowerHex(traceIdHigh, traceIdLow) + ")";
            }
        });
    }

    @Override
    public void getRawTrace(long traceId, Callback<List<Span>> callback) {
        this.getRawTrace(0L, traceId, callback);
    }

    @Override
    public void getRawTrace(final long traceIdHigh, final long traceIdLow, Callback<List<Span>> callback) {
        this.executor.execute(new InternalCallbackRunnable<List<Span>>(callback){

            @Override
            List<Span> complete() {
                return InternalBlockingToAsyncSpanStoreAdapter.this.delegate.getRawTrace(traceIdHigh, traceIdLow);
            }

            public String toString() {
                return "getRawTrace(" + Util.toLowerHex(traceIdHigh, traceIdLow) + ")";
            }
        });
    }

    @Override
    public void getServiceNames(Callback<List<String>> callback) {
        this.executor.execute(new InternalCallbackRunnable<List<String>>(callback){

            @Override
            List<String> complete() {
                return InternalBlockingToAsyncSpanStoreAdapter.this.delegate.getServiceNames();
            }

            public String toString() {
                return "getServiceNames()";
            }
        });
    }

    @Override
    public void getSpanNames(final String serviceName, Callback<List<String>> callback) {
        this.executor.execute(new InternalCallbackRunnable<List<String>>(callback){

            @Override
            List<String> complete() {
                return InternalBlockingToAsyncSpanStoreAdapter.this.delegate.getSpanNames(serviceName);
            }

            public String toString() {
                return "getSpanNames(" + serviceName + ")";
            }
        });
    }

    @Override
    public void getDependencies(final long endTs, final @Nullable Long lookback, Callback<List<DependencyLink>> callback) {
        this.executor.execute(new InternalCallbackRunnable<List<DependencyLink>>(callback){

            @Override
            List<DependencyLink> complete() {
                return InternalBlockingToAsyncSpanStoreAdapter.this.delegate.getDependencies(endTs, lookback);
            }

            public String toString() {
                return "getDependencies(" + endTs + lookback == null ? ")" : ", " + lookback + ")";
            }
        });
    }

    public String toString() {
        return this.delegate.toString();
    }
}

