/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.internal;

import com.google.auto.value.AutoValue;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import zipkin2.internal.AutoValue_Node_Entry;
import zipkin2.internal.Nullable;

public final class Node<V> {
    private Node<V> parent;
    private V value;
    private List<Node<V>> children = Collections.emptyList();
    private boolean missingRootDummyNode;
    static final MergeFunction FIRST_NOT_NULL = new MergeFunction(){

        public Object merge(@Nullable Object existing, @Nullable Object update) {
            return existing != null ? existing : update;
        }
    };

    @Nullable
    public Node<V> parent() {
        return this.parent;
    }

    @Nullable
    public V value() {
        return this.value;
    }

    public Node<V> value(V newValue) {
        if (newValue == null) {
            throw new NullPointerException("newValue == null");
        }
        this.value = newValue;
        return this;
    }

    public Node<V> addChild(Node<V> child) {
        if (child == this) {
            throw new IllegalArgumentException("circular dependency on " + this);
        }
        child.parent = this;
        if (this.children.equals(Collections.emptyList())) {
            this.children = new ArrayList<Node<V>>();
        }
        this.children.add(child);
        return this;
    }

    public Collection<Node<V>> children() {
        return this.children;
    }

    public Iterator<Node<V>> traverse() {
        return new BreadthFirstIterator(this);
    }

    public boolean isSyntheticRootForPartialTree() {
        return this.missingRootDummyNode;
    }

    @AutoValue
    static abstract class Entry<V> {
        Entry() {
        }

        static <V> Entry<V> create(@Nullable String parentId, String id, V value) {
            return new AutoValue_Node_Entry<V>(parentId, id, value);
        }

        @Nullable
        abstract String parentId();

        abstract String id();

        abstract V value();
    }

    public static final class TreeBuilder<V> {
        final Logger logger;
        final MergeFunction<V> mergeFunction;
        final String traceId;
        String rootId = null;
        Node<V> rootNode = null;
        List<Entry<V>> entries = new ArrayList<Entry<V>>();
        Map<String, Node<V>> idToNode = new LinkedHashMap<String, Node<V>>();
        Map<String, String> idToParent = new LinkedHashMap<String, String>(this.idToNode.size());

        public TreeBuilder(Logger logger, String traceId) {
            this(logger, FIRST_NOT_NULL, traceId);
        }

        TreeBuilder(Logger logger, MergeFunction<V> mergeFunction, String traceId) {
            this.logger = logger;
            this.mergeFunction = mergeFunction;
            this.traceId = traceId;
        }

        public boolean addNode(@Nullable String parentId, String id, V value) {
            if (parentId != null && parentId.equals(id)) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine(String.format("skipping circular dependency: traceId=%s, spanId=%s", this.traceId, id));
                }
                return false;
            }
            this.idToParent.put(id, parentId);
            this.entries.add(Entry.create(parentId, id, value));
            return true;
        }

        void processNode(Entry<V> entry) {
            String parentId = entry.parentId() != null ? entry.parentId() : this.idToParent.get(entry.id());
            String id = entry.id();
            V value = entry.value();
            if (parentId == null) {
                if (this.rootId != null) {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine(String.format("attributing span missing parent to root: traceId=%s, rootSpanId=%s, spanId=%s", this.traceId, this.rootId, id));
                    }
                } else {
                    this.rootId = id;
                }
            }
            Node<Object> node = new Node<V>().value(value);
            if (parentId == null && this.rootNode == null) {
                this.rootNode = node;
                this.rootId = id;
                this.idToParent.remove(id);
            } else if (parentId == null && this.rootId.equals(id)) {
                this.rootNode.value(this.mergeFunction.merge(((Node)this.rootNode).value, ((Node)node).value));
            } else {
                Node previous = this.idToNode.put(id, node);
                if (previous != null) {
                    node.value(this.mergeFunction.merge(previous.value, ((Node)node).value));
                }
            }
        }

        public Node<V> build() {
            int length = this.entries.size();
            for (int i = 0; i < length; ++i) {
                this.processNode(this.entries.get(i));
            }
            for (Map.Entry<String, String> entry : this.idToParent.entrySet()) {
                Node<V> node = this.idToNode.get(entry.getKey());
                Node<V> parent = this.idToNode.get(entry.getValue());
                if (parent == null) {
                    if (this.rootNode == null) {
                        if (this.logger.isLoggable(Level.FINE)) {
                            this.logger.fine("substituting dummy node for missing root span: traceId=" + this.traceId);
                        }
                        this.rootNode = new Node();
                        ((Node)this.rootNode).missingRootDummyNode = true;
                    }
                    this.rootNode.addChild(node);
                    continue;
                }
                parent.addChild(node);
            }
            return this.rootNode != null ? this.rootNode : new Node();
        }
    }

    static interface MergeFunction<V> {
        public V merge(@Nullable V var1, @Nullable V var2);
    }

    static final class BreadthFirstIterator<V>
    implements Iterator<Node<V>> {
        private final Queue<Node<V>> queue = new ArrayDeque<Node<V>>();

        BreadthFirstIterator(Node<V> root) {
            this.queue.add(root);
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public Node<V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Node<V> result = this.queue.remove();
            this.queue.addAll(((Node)result).children);
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

