/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.entities.channel;

import java.util.EnumSet;
import javax.annotation.Nonnull;

public enum ChannelType {
    TEXT(0, 0, true),
    PRIVATE(1, -1),
    VOICE(2, 1, true),
    GROUP(3, -1),
    CATEGORY(4, 2, true),
    NEWS(5, 0, true),
    STAGE(13, 1, true),
    GUILD_NEWS_THREAD(10, -1, true),
    GUILD_PUBLIC_THREAD(11, -1, true),
    GUILD_PRIVATE_THREAD(12, -1, true),
    FORUM(15, 0, true),
    UNKNOWN(-1, -2);

    private final int sortBucket;
    private final int id;
    private final boolean isGuild;

    private ChannelType(int id, int sortBucket) {
        this(id, sortBucket, false);
    }

    private ChannelType(int id, int sortBucket, boolean isGuild) {
        this.id = id;
        this.sortBucket = sortBucket;
        this.isGuild = isGuild;
    }

    public int getSortBucket() {
        return this.sortBucket;
    }

    public int getId() {
        return this.id;
    }

    public boolean isGuild() {
        return this.isGuild;
    }

    public boolean isAudio() {
        switch (this) {
            case VOICE: 
            case STAGE: {
                return true;
            }
        }
        return false;
    }

    public boolean isMessage() {
        switch (this) {
            case VOICE: 
            case STAGE: 
            case TEXT: 
            case NEWS: 
            case PRIVATE: 
            case GROUP: {
                return true;
            }
        }
        return this.isThread();
    }

    public boolean isThread() {
        switch (this) {
            case GUILD_NEWS_THREAD: 
            case GUILD_PUBLIC_THREAD: 
            case GUILD_PRIVATE_THREAD: {
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public static EnumSet<ChannelType> guildTypes() {
        return EnumSet.complementOf(EnumSet.of(PRIVATE, GROUP, UNKNOWN));
    }

    @Nonnull
    public static ChannelType fromId(int id) {
        for (ChannelType type : ChannelType.values()) {
            if (type.id != id) continue;
            return type;
        }
        return UNKNOWN;
    }

    @Nonnull
    public static EnumSet<ChannelType> fromSortBucket(int bucket) {
        EnumSet<ChannelType> types = EnumSet.noneOf(ChannelType.class);
        for (ChannelType type : ChannelType.values()) {
            if (type.getSortBucket() != bucket) continue;
            types.add(type);
        }
        return types;
    }
}

