/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.console;

import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.DatabaseBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import net.ucanaccess.util.Logger;

public class Main {
    private static boolean batchMode = false;
    private Connection conn;
    private boolean connected = true;
    private BufferedReader input;
    private String lastSqlQuery;

    public Main(Connection conn, BufferedReader input) {
        this.conn = conn;
        this.input = input;
    }

    private static boolean hasPassword(File fl) throws IOException {
        Database db;
        try {
            db = DatabaseBuilder.open((File)fl);
        }
        catch (IOException e) {
            DatabaseBuilder dbb = new DatabaseBuilder();
            dbb.setReadOnly(true);
            dbb.setFile(fl);
            db = dbb.open();
        }
        String pwd = db.getDatabasePassword();
        db.close();
        return pwd != null;
    }

    private static void lcProperties(Properties pr) {
        Properties nb = new Properties();
        for (Map.Entry<Object, Object> entry : pr.entrySet()) {
            String key = (String)entry.getKey();
            if (key == null) continue;
            nb.put(key.toLowerCase(), entry.getValue());
        }
        pr.clear();
        pr.putAll((Map<?, ?>)nb);
    }

    public static void main(String[] args) throws Exception {
        File pfl;
        Logger.setLogPrintWriter(new PrintWriter(System.out));
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        Properties info = new Properties();
        if (args.length > 0 && (pfl = new File(args[0])).exists()) {
            FileInputStream fis = new FileInputStream(pfl);
            info.load(fis);
            Main.lcProperties(info);
        }
        try {
            Class.forName("net.ucanaccess.jdbc.UcanaccessDriver");
        }
        catch (ClassNotFoundException e) {
            System.out.println(e.getMessage());
            System.out.println("Check your classpath! ");
            System.exit(1);
        }
        Connection conn = null;
        File fl = null;
        long size = 0L;
        while (fl == null || !fl.exists()) {
            if (fl != null) {
                System.out.println("Given file does not exist");
            }
            System.out.print("Please, enter the full path to the access file (.mdb or .accdb): ");
            String path = input.readLine().trim();
            if (path.endsWith(";")) {
                path = path.substring(0, path.length() - 1);
            }
            if (path.equalsIgnoreCase("quit")) {
                System.out.println("I'm so unhappy. Goodbye.");
                System.exit(1);
            }
            fl = new File(path);
            size = fl.length();
        }
        try {
            String passwordEntry = "";
            String noMem = "";
            if (info.containsKey("jackcessopener") || Main.hasPassword(fl)) {
                System.out.print("Please, enter password: ");
                passwordEntry = ";password=" + input.readLine().trim();
            }
            if (!info.containsKey("jackcessopener")) {
                noMem = size > 30000000L ? ";memory=false" : "";
            }
            conn = DriverManager.getConnection("jdbc:ucanaccess://" + fl.getAbsolutePath() + passwordEntry + noMem, info);
            for (SQLWarning sqlw = conn.getWarnings(); sqlw != null; sqlw = sqlw.getNextWarning()) {
                System.out.println(sqlw.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
            System.exit(1);
        }
        Main main = new Main(conn, input);
        main.sayHello(conn.getMetaData().getDriverVersion());
        main.start();
    }

    public static void setBatchMode(boolean batchMode) {
        Main.batchMode = batchMode;
    }

    private void consoleDump(ResultSet rs, int cols, PrintStream out) throws SQLException {
        while (rs.next()) {
            System.out.print("| ");
            for (int i = 1; i <= cols; ++i) {
                Object o = rs.getObject(i);
                if (o != null && o.getClass().isArray()) {
                    o = Arrays.toString((Object[])o);
                }
                out.print(o + " | ");
            }
            out.println();
            out.println();
        }
    }

    private void csvDump(ResultSet rs, int cols, PrintStream out) throws SQLException {
        int i;
        ResultSetMetaData meta = rs.getMetaData();
        String comma = "";
        for (i = 1; i <= cols; ++i) {
            String lb = meta.getColumnLabel(i);
            out.print(comma + lb);
            comma = ";";
        }
        out.println();
        while (rs.next()) {
            comma = "";
            for (i = 1; i <= cols; ++i) {
                Format df;
                Object o = rs.getObject(i);
                if (o == null) {
                    o = "";
                }
                if (o != null && o.getClass().isArray()) {
                    o = Arrays.toString((Object[])o);
                }
                if (o instanceof Date) {
                    df = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                    o = ((DateFormat)df).format((Date)o);
                }
                if (o instanceof BigDecimal) {
                    df = new DecimalFormat("0.0########");
                    DecimalFormatSymbols dfs = new DecimalFormatSymbols();
                    dfs.setDecimalSeparator('.');
                    ((DecimalFormat)df).setDecimalFormatSymbols(dfs);
                    ((DecimalFormat)df).setGroupingUsed(false);
                    o = df.format(o);
                }
                if (o instanceof String) {
                    o = ((String)o).replaceAll("\n", " ");
                }
                out.print(comma + o);
                comma = ";";
            }
            out.println();
        }
    }

    public void dump(ResultSet rs, PrintStream out, boolean consoleMode) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int cols = meta.getColumnCount();
        if (consoleMode) {
            StringBuffer header = new StringBuffer("| ");
            for (int i = 1; i <= cols; ++i) {
                header.append(meta.getColumnLabel(i) + " | ");
            }
            String interline = "";
            for (int i = 0; i < header.length(); ++i) {
                interline = interline + "-";
            }
            out.println(interline);
            out.println(header);
            out.println(interline);
            out.println();
        }
        if (consoleMode) {
            this.consoleDump(rs, cols, out);
        } else {
            this.csvDump(rs, cols, out);
        }
    }

    private void executeStatement(String sql) {
        try {
            Statement st = this.conn.createStatement();
            if (st.execute(sql)) {
                ResultSet rs = st.getResultSet();
                if (rs != null) {
                    this.dump(rs, System.out, true);
                    this.lastSqlQuery = sql;
                } else {
                    System.out.println("Ok!");
                }
            } else {
                int num = st.getUpdateCount();
                this.prompt(num == 0 ? "No rows affected" : num + " row(s) affected");
            }
        }
        catch (Exception e) {
            this.prompt(e.getMessage());
        }
    }

    private void prompt() {
        System.out.println();
        if (!batchMode) {
            System.out.print("UCanAccess>");
        }
    }

    private void prompt(String content) {
        if (!batchMode) {
            System.out.println("UCanAccess>" + content);
        }
    }

    private String readInput() {
        try {
            String ret = this.input.readLine();
            if (ret == null) {
                this.prompt("Ciao!");
                System.exit(0);
            }
            return ret.trim();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private void sayHello(String version) {
        this.prompt("");
        System.out.printf("Copyright (c) %d Marco Amadei%n", Calendar.getInstance().get(1));
        System.out.println("UCanAccess version " + version);
        System.out.println("You are connected!! ");
        System.out.println("Type quit to exit ");
        System.out.println();
        System.out.println("Commands end with ; ");
        System.out.println();
        System.out.println("use:   ");
        System.out.println("   export <pathToCsv>;");
        System.out.println("for exporting the result set from the last executed query into a .csv file");
        this.prompt();
    }

    private void start() throws SQLException {
        StringBuffer sb = new StringBuffer();
        while (this.connected) {
            String userInput = this.readInput();
            if (userInput.toLowerCase().equalsIgnoreCase("quit")) {
                this.connected = false;
                break;
            }
            sb.append(" ").append(userInput);
            if (sb.length() == 0) {
                this.prompt();
            }
            if (!userInput.trim().endsWith(";")) continue;
            String cmd = sb.toString().substring(0, sb.length() - 1).trim();
            if (cmd.toLowerCase().startsWith("export ")) {
                StringTokenizer st = new StringTokenizer(cmd);
                if (st.countTokens() != 2) {
                    this.prompt("Export command syntax is: export <pathToCsv>");
                }
                if (this.lastSqlQuery == null) {
                    this.prompt("You must first execute an SQL query, then export the ResultSet!");
                } else {
                    Statement statement = this.conn.createStatement();
                    ResultSet rs = statement.executeQuery(this.lastSqlQuery);
                    st.nextToken();
                    File fl = new File(st.nextToken());
                    try {
                        PrintStream out = new PrintStream(fl);
                        this.dump(rs, out, false);
                        out.flush();
                        out.close();
                        this.prompt("Created file: " + fl.getAbsolutePath());
                    }
                    catch (FileNotFoundException e) {
                        this.prompt(e.getMessage());
                    }
                }
            } else {
                this.executeStatement(cmd);
            }
            sb = new StringBuffer();
            this.prompt();
        }
        System.out.println("Cheers! Thank you for using the UCanAccess JDBC Driver.");
    }
}

