/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.ucanaccess.converters.SQLConverter;
import net.ucanaccess.jdbc.FeatureNotSupportedException;
import net.ucanaccess.jdbc.UcanaccessConnection;
import net.ucanaccess.jdbc.UcanaccessSQLException;
import org.hsqldb.jdbc.JDBCDatabaseMetaData;

public class UcanaccessDatabaseMetadata
implements DatabaseMetaData {
    private static final String SELECT_BASE = "SELECT * FROM INFORMATION_SCHEMA.";
    private static final String NATIVE_ALIAS = " l.";
    private static final String CUSTOM_ALIAS = " r.";
    private static final String CAST_EXPR = "CAST(null AS VARCHAR(50)) AS ";
    private UcanaccessConnection connection;
    private DatabaseMetaData wrapped;

    public UcanaccessDatabaseMetadata(DatabaseMetaData wrapped, UcanaccessConnection connection) {
        this.wrapped = wrapped;
        this.connection = connection;
    }

    private String from(String left, String right) {
        StringBuffer sb = new StringBuffer(" FROM ").append("INFORMATION_SCHEMA.").append(left).append(" l INNER JOIN ").append("UCA_METADATA.").append(right).append(" r ");
        return sb.toString();
    }

    private String in(String prefix, String field, Object[] options) {
        if (options == null || options.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(" AND ").append(prefix).append(field).append(" IN ").append("(");
        String comma = "";
        for (int i = 0; i < options.length; ++i) {
            Object norm = options[i];
            String val = norm instanceof String ? "'" + norm.toString().toUpperCase() + "'" : norm.toString();
            sb.append(comma).append(val);
            comma = ",";
        }
        sb.append(")");
        return sb.toString();
    }

    private String nAlias(String s) {
        return NATIVE_ALIAS + s;
    }

    private String cAlias(String s) {
        return CUSTOM_ALIAS + s;
    }

    private String on(List<String> left, List<String> right) {
        StringBuffer sb = new StringBuffer(" ON(");
        Iterator<String> il = left.iterator();
        Iterator<String> ir = right.iterator();
        String and = "";
        while (il.hasNext() && ir.hasNext()) {
            sb.append(and).append(NATIVE_ALIAS).append(il.next()).append("=").append(CUSTOM_ALIAS).append(ir.next());
            and = " AND ";
        }
        sb.append(") ");
        return sb.toString();
    }

    private static String and(String left, String op, String right) {
        return UcanaccessDatabaseMetadata.and(left, op, right, " AND ");
    }

    private static String and(String left, String op, String right, String and) {
        return UcanaccessDatabaseMetadata.and(left, op, right, and, true);
    }

    private static String and(String left, String op, String right, boolean apos) {
        return UcanaccessDatabaseMetadata.and(left, op, right, " AND ", apos);
    }

    private static String and(String left, String op, String right, String and, boolean apos) {
        if (right == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(and);
        if (right.length() == 0) {
            return sb.append(left).append(" IS NULL ").toString();
        }
        String exp = right == null ? null : (apos ? "'" + right + "'" : right);
        sb.append(left).append(" ");
        if ("LIKE".equals(op)) {
            if (exp.indexOf(95) < 0 && exp.indexOf(37) < 0) {
                sb.append(" = ").append(exp);
            } else {
                sb.append(" LIKE ").append(exp);
                sb.append(" ESCAPE '\\'");
            }
        } else {
            sb.append(op).append(' ').append(exp);
        }
        return sb.toString();
    }

    private String select(String htableName, List<String> exclude, List<String> replace) throws SQLException {
        ResultSetMetaData rsmd = this.executeQuery(SELECT_BASE + htableName + " WHERE 1=0").getMetaData();
        String comma = "";
        StringBuffer sb = new StringBuffer("SELECT ");
        for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
            String cn = rsmd.getColumnName(i);
            if (exclude.contains(cn)) {
                String es = replace.get(exclude.indexOf(cn));
                sb.append(comma);
                if (es == null) {
                    sb.append(CAST_EXPR + cn);
                } else if (es.equals("PUBLIC")) {
                    sb.append("'PUBLIC' AS " + cn);
                } else if (es.startsWith(CAST_EXPR) || es.equals("PUBLIC")) {
                    sb.append(es);
                } else {
                    String suffix = es.indexOf(".") > 0 ? "" : "r.";
                    sb.append(suffix).append(es).append(" AS ").append(cn);
                }
            } else {
                sb.append(comma).append("l.").append(cn);
            }
            comma = ",";
        }
        return sb.toString();
    }

    private ResultSet executeQuery(String sql) throws SQLException {
        this.connection.checkLastModified();
        Statement st = this.connection.getHSQLDBConnection().createStatement();
        ResultSet rs = st.executeQuery(sql);
        return rs;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        try {
            return this.wrapped.allProceduresAreCallable();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        try {
            return this.wrapped.allTablesAreSelectable();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        try {
            return this.wrapped.autoCommitFailureClosesAllResultSets();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        try {
            return this.wrapped.dataDefinitionCausesTransactionCommit();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        try {
            return this.wrapped.dataDefinitionIgnoredInTransactions();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        try {
            return this.wrapped.deletesAreDetected(type);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        try {
            return this.wrapped.doesMaxRowSizeIncludeBlobs();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        try {
            return this.wrapped.getAttributes(catalog, schemaPattern, typeNamePattern, attributeNamePattern);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        table = SQLConverter.escapeIdentifier(table).toUpperCase();
        try {
            Object[] scopeArr = new Integer[]{0, 1, 2};
            String nullableS = nullable ? null : String.valueOf(0);
            StringBuffer sql = new StringBuffer(this.select("SYSTEM_BESTROWIDENTIFIER", Arrays.asList("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME"), Arrays.asList(null, null, "TABLE_NAME", "COLUMN_NAME"))).append(this.from("SYSTEM_BESTROWIDENTIFIER", "COLUMNS_VIEW")).append(this.on(Arrays.asList("TABLE_NAME", "COLUMN_NAME"), Arrays.asList("ESCAPED_TABLE_NAME", "ESCAPED_COLUMN_NAME"))).append(UcanaccessDatabaseMetadata.and("TABLE_CAT", "=", "PUBLIC", " WHERE ")).append(UcanaccessDatabaseMetadata.and("TABLE_SCHEM", "=", schema)).append(UcanaccessDatabaseMetadata.and("TABLE_NAME", "=", table)).append(UcanaccessDatabaseMetadata.and("NULLABLE", "=", nullableS, false)).append(this.in(NATIVE_ALIAS, "SCOPE", scopeArr));
            return this.executeQuery(sql.toString());
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        if (this.connection.isShowSchema()) {
            try {
                return this.wrapped.getCatalogs();
            }
            catch (SQLException e) {
                throw new UcanaccessSQLException(e);
            }
        }
        throw new FeatureNotSupportedException();
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        try {
            return this.wrapped.getCatalogSeparator();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        try {
            return this.wrapped.getCatalogTerm();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        try {
            String sql = "SELECT * FROM UCA_METADATA.PROP";
            return this.executeQuery(sql);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        try {
            if (table == null) {
                throw new UcanaccessSQLException(UcanaccessSQLException.ExceptionMessages.PARAMETER_NULL, "table");
            }
            columnNamePattern = UcanaccessDatabaseMetadata.normalizeName(columnNamePattern);
            table = UcanaccessDatabaseMetadata.normalizeName(table);
            if (this.invokeWrapper(catalog, schema)) {
                return this.wrapped.getColumnPrivileges(catalog, schema, table, columnNamePattern);
            }
            String cat = this.connection.isShowSchema() ? "PUBLIC" : null;
            String schem = this.connection.isShowSchema() ? "PUBLIC" : null;
            StringBuffer select = new StringBuffer("SELECT " + cat + " TABLE_CAT, " + schem + " TABLE_SCHEM,").append(this.cAlias("TABLE_NAME")).append(",").append(this.cAlias("COLUMN_NAME")).append(",").append(this.nAlias("GRANTOR")).append(",").append(this.nAlias("GRANTEE")).append(",").append(this.nAlias("PRIVILEGE_TYPE PRIVILEGE")).append(",").append(this.nAlias("IS_GRANTABLE")).append(this.from("COLUMN_PRIVILEGES", "COLUMNS_VIEW")).append(this.on(Arrays.asList("TABLE_NAME", "COLUMN_NAME"), Arrays.asList("ESCAPED_TABLE_NAME", "ESCAPED_COLUMN_NAME"))).append(UcanaccessDatabaseMetadata.and("TABLE_CATALOG", "=", "PUBLIC", " WHERE ")).append(UcanaccessDatabaseMetadata.and("TABLE_SCHEMA", "=", "PUBLIC") + UcanaccessDatabaseMetadata.and("TABLE_NAME", "=", table)).append(UcanaccessDatabaseMetadata.and("COLUMN_NAME", "LIKE", columnNamePattern));
            return this.executeQuery(select.toString());
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        try {
            columnNamePattern = UcanaccessDatabaseMetadata.normalizeName(columnNamePattern);
            tableNamePattern = UcanaccessDatabaseMetadata.normalizeName(tableNamePattern);
            if (this.invokeWrapper(catalog, schemaPattern)) {
                return this.wrapped.getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
            }
            String cat = this.connection.isShowSchema() ? "PUBLIC" : null;
            String schem = this.connection.isShowSchema() ? "PUBLIC" : null;
            StringBuffer select = new StringBuffer(this.select("SYSTEM_COLUMNS", Arrays.asList("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "COLUMN_DEF", "IS_AUTOINCREMENT", "IS_GENERATEDCOLUMN"), Arrays.asList(cat, schem, "TABLE_NAME", "COLUMN_NAME", "COLUMN_DEF", "IS_AUTOINCREMENT", "IS_GENERATEDCOLUMN"))).append(",").append(this.cAlias("ORIGINAL_TYPE")).append(this.from("SYSTEM_COLUMNS", "COLUMNS_VIEW")).append(this.on(Arrays.asList("TABLE_NAME", "COLUMN_NAME"), Arrays.asList("ESCAPED_TABLE_NAME", "ESCAPED_COLUMN_NAME"))).append(UcanaccessDatabaseMetadata.and("TABLE_CAT", "=", "PUBLIC", " WHERE ")).append(UcanaccessDatabaseMetadata.and("TABLE_SCHEM", "=", "PUBLIC")).append(UcanaccessDatabaseMetadata.and("TABLE_NAME", "LIKE", tableNamePattern)).append(UcanaccessDatabaseMetadata.and("COLUMN_NAME", "LIKE", columnNamePattern));
            return this.executeQuery(select.toString());
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        try {
            if (parentTable == null) {
                throw new UcanaccessSQLException(UcanaccessSQLException.ExceptionMessages.PARAMETER_NULL, "parentTable");
            }
            if (foreignTable == null) {
                throw new UcanaccessSQLException(UcanaccessSQLException.ExceptionMessages.PARAMETER_NULL, "foreignTable");
            }
            parentTable = UcanaccessDatabaseMetadata.normalizeName(parentTable);
            foreignTable = UcanaccessDatabaseMetadata.normalizeName(foreignTable);
            if (this.invokeWrapper(parentCatalog, parentSchema)) {
                return this.wrapped.getCrossReference(parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
            }
            String cat = this.connection.isShowSchema() ? "PUBLIC" : null;
            String schem = this.connection.isShowSchema() ? "PUBLIC" : null;
            StringBuffer select = new StringBuffer(this.select("SYSTEM_CROSSREFERENCE", Arrays.asList("PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME"), Arrays.asList(cat, schem, "TABLE_NAME", "COLUMN_NAME", cat, schem, "v.TABLE_NAME", "v.COLUMN_NAME"))).append(this.from("SYSTEM_CROSSREFERENCE", "COLUMNS_VIEW")).append(this.on(Arrays.asList("PKTABLE_NAME", "PKCOLUMN_NAME"), Arrays.asList("ESCAPED_TABLE_NAME", "ESCAPED_COLUMN_NAME"))).append(" INNER JOIN UCA_METADATA.COLUMNS_VIEW v ON( l.FKTABLE_NAME= v.ESCAPED_TABLE_NAME AND  l.FKCOLUMN_NAME= v.ESCAPED_COLUMN_NAME)").append(UcanaccessDatabaseMetadata.and("PKTABLE_CAT", "=", "PUBLIC", " WHERE ")).append(UcanaccessDatabaseMetadata.and("PKTABLE_SCHEM", "=", "PUBLIC")).append(UcanaccessDatabaseMetadata.and("PKTABLE_NAME", "=", parentTable)).append(UcanaccessDatabaseMetadata.and("FKTABLE_CAT", "=", "PUBLIC")).append(UcanaccessDatabaseMetadata.and("FKTABLE_SCHEM", "=", "PUBLIC")).append(UcanaccessDatabaseMetadata.and("FKTABLE_NAME", "=", foreignTable)).append(" ORDER BY FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, KEY_SEQ");
            return this.executeQuery(select.toString());
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        try {
            return this.wrapped.getDatabaseMajorVersion();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        try {
            return this.wrapped.getDatabaseMinorVersion();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "Ucanaccess for access db(Jet) using hasqldb";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        try {
            return this.connection.getDbIO().getFileFormat().toString();
        }
        catch (IOException e) {
            return "";
        }
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        try {
            return this.wrapped.getDefaultTransactionIsolation();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getDriverMajorVersion() {
        return 0;
    }

    @Override
    public int getDriverMinorVersion() {
        return 0;
    }

    @Override
    public String getDriverName() throws SQLException {
        return "Ucanaccess";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        try {
            String version = this.getClass().getPackage().getImplementationVersion();
            return version == null ? "3.x.x" : version;
        }
        catch (Exception e) {
            return "2.x.x";
        }
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        try {
            if (table == null) {
                throw new UcanaccessSQLException(UcanaccessSQLException.ExceptionMessages.PARAMETER_NULL, "table");
            }
            table = UcanaccessDatabaseMetadata.normalizeName(table);
            if (this.invokeWrapper(catalog, schema)) {
                return this.wrapped.getExportedKeys(catalog, schema, table);
            }
            String cat = this.connection.isShowSchema() ? "PUBLIC" : null;
            String schem = this.connection.isShowSchema() ? "PUBLIC" : null;
            StringBuffer select = new StringBuffer(this.select("SYSTEM_CROSSREFERENCE", Arrays.asList("PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME"), Arrays.asList(cat, schem, "TABLE_NAME", "COLUMN_NAME", cat, schem, "v.TABLE_NAME", "v.COLUMN_NAME"))).append(this.from("SYSTEM_CROSSREFERENCE", "COLUMNS_VIEW")).append(this.on(Arrays.asList("PKTABLE_NAME", "PKCOLUMN_NAME"), Arrays.asList("ESCAPED_TABLE_NAME", "ESCAPED_COLUMN_NAME"))).append(" INNER JOIN UCA_METADATA.COLUMNS_VIEW v ON( l.FKTABLE_NAME= v.ESCAPED_TABLE_NAME AND  l.FKCOLUMN_NAME= v.ESCAPED_COLUMN_NAME)").append(UcanaccessDatabaseMetadata.and("PKTABLE_CAT", "=", "PUBLIC", " WHERE ")).append(UcanaccessDatabaseMetadata.and("PKTABLE_SCHEM", "=", "PUBLIC")).append(UcanaccessDatabaseMetadata.and("PKTABLE_NAME", "=", table)).append(" ORDER BY FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, KEY_SEQ");
            return this.executeQuery(select.toString());
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        try {
            return this.wrapped.getExtraNameCharacters();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        try {
            columnNamePattern = UcanaccessDatabaseMetadata.normalizeName(columnNamePattern);
            return this.wrapped.getFunctionColumns(catalog, schemaPattern, functionNamePattern, columnNamePattern);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        try {
            return this.wrapped.getFunctions(catalog, schemaPattern, functionNamePattern);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return "`";
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        try {
            if (table == null) {
                throw new UcanaccessSQLException(UcanaccessSQLException.ExceptionMessages.PARAMETER_NULL, "table");
            }
            table = UcanaccessDatabaseMetadata.normalizeName(table);
            if (this.invokeWrapper(catalog, schema)) {
                return this.wrapped.getImportedKeys(catalog, schema, table);
            }
            String cat = this.connection.isShowSchema() ? "PUBLIC" : null;
            String schem = this.connection.isShowSchema() ? "PUBLIC" : null;
            StringBuffer select = new StringBuffer(this.select("SYSTEM_CROSSREFERENCE", Arrays.asList("FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME"), Arrays.asList(cat, schem, "TABLE_NAME", "COLUMN_NAME", cat, schem, "v.TABLE_NAME", "v.COLUMN_NAME"))).append(this.from("SYSTEM_CROSSREFERENCE", "COLUMNS_VIEW")).append(this.on(Arrays.asList("FKTABLE_NAME", "FKCOLUMN_NAME"), Arrays.asList("ESCAPED_TABLE_NAME", "ESCAPED_COLUMN_NAME"))).append(" INNER JOIN UCA_METADATA.COLUMNS_VIEW v ON( l.PKTABLE_NAME= v.ESCAPED_TABLE_NAME AND  l.PKCOLUMN_NAME= v.ESCAPED_COLUMN_NAME)").append(UcanaccessDatabaseMetadata.and("FKTABLE_CAT", "=", "PUBLIC", " WHERE ")).append(UcanaccessDatabaseMetadata.and("FKTABLE_SCHEM", "=", "PUBLIC")).append(UcanaccessDatabaseMetadata.and("FKTABLE_NAME", "=", table)).append(" ORDER BY PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME, KEY_SEQ");
            return this.executeQuery(select.toString());
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        try {
            if (table == null) {
                throw new UcanaccessSQLException(UcanaccessSQLException.ExceptionMessages.PARAMETER_NULL, "table");
            }
            table = UcanaccessDatabaseMetadata.normalizeName(table);
            String cat = this.connection.isShowSchema() ? "PUBLIC" : null;
            String schem = this.connection.isShowSchema() ? "PUBLIC" : null;
            String nuS = unique ? "AND NON_UNIQUE IS FALSE" : "";
            StringBuffer select = new StringBuffer(this.select("SYSTEM_INDEXINFO", Arrays.asList("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME"), Arrays.asList(cat, schem, "TABLE_NAME", "COLUMN_NAME"))).append(this.from("SYSTEM_INDEXINFO", "COLUMNS_VIEW")).append(this.on(Arrays.asList("TABLE_NAME", "COLUMN_NAME"), Arrays.asList("ESCAPED_TABLE_NAME", "ESCAPED_COLUMN_NAME"))).append(UcanaccessDatabaseMetadata.and("TABLE_CAT", "=", "PUBLIC")).append(UcanaccessDatabaseMetadata.and("TABLE_SCHEM", "=", "PUBLIC", " WHERE ")).append(UcanaccessDatabaseMetadata.and("TABLE_NAME", "=", table)).append(nuS);
            return this.executeQuery(select.toString());
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        try {
            return this.wrapped.getJDBCMajorVersion();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        try {
            return this.wrapped.getJDBCMinorVersion();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        try {
            return this.wrapped.getMaxBinaryLiteralLength();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        try {
            return this.wrapped.getMaxCatalogNameLength();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        try {
            return this.wrapped.getMaxCharLiteralLength();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        try {
            return this.wrapped.getMaxColumnNameLength();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        try {
            return this.wrapped.getMaxColumnsInGroupBy();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        try {
            return this.wrapped.getMaxColumnsInIndex();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        try {
            return this.wrapped.getMaxColumnsInOrderBy();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        try {
            return this.wrapped.getMaxColumnsInSelect();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        try {
            return this.wrapped.getMaxColumnsInTable();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getMaxConnections() throws SQLException {
        try {
            return this.wrapped.getMaxConnections();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        try {
            return this.wrapped.getMaxCursorNameLength();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        try {
            return this.wrapped.getMaxIndexLength();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        try {
            return this.wrapped.getMaxProcedureNameLength();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        try {
            return this.wrapped.getMaxRowSize();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        try {
            return this.wrapped.getMaxSchemaNameLength();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        try {
            return this.wrapped.getMaxStatementLength();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getMaxStatements() throws SQLException {
        try {
            return this.wrapped.getMaxStatements();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        try {
            return this.wrapped.getMaxTableNameLength();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        try {
            return this.wrapped.getMaxTablesInSelect();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        try {
            return this.wrapped.getMaxUserNameLength();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        try {
            return this.wrapped.getNumericFunctions();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    private boolean invokeWrapper(String catalog, String schema) {
        return !(!this.connection.isShowSchema() || catalog == null && schema == null || "PUBLIC".equals(catalog) && "PUBLIC".equals(schema));
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        try {
            if (table == null) {
                throw new UcanaccessSQLException(UcanaccessSQLException.ExceptionMessages.PARAMETER_NULL, "table");
            }
            table = UcanaccessDatabaseMetadata.normalizeName(table);
            if (this.invokeWrapper(catalog, schema)) {
                return this.wrapped.getPrimaryKeys(catalog, schema, table);
            }
            String cat = this.connection.isShowSchema() ? "PUBLIC" : null;
            String schem = this.connection.isShowSchema() ? "PUBLIC" : null;
            StringBuffer select = new StringBuffer(this.select("SYSTEM_PRIMARYKEYS", Arrays.asList("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME"), Arrays.asList(cat, schem, "TABLE_NAME", "COLUMN_NAME"))).append(this.from("SYSTEM_PRIMARYKEYS", "COLUMNS_VIEW")).append(this.on(Arrays.asList("TABLE_NAME", "COLUMN_NAME"), Arrays.asList("ESCAPED_TABLE_NAME", "ESCAPED_COLUMN_NAME"))).append(UcanaccessDatabaseMetadata.and("TABLE_CAT", "=", "PUBLIC", " WHERE ")).append(UcanaccessDatabaseMetadata.and("TABLE_SCHEM", "=", "PUBLIC")).append(UcanaccessDatabaseMetadata.and("TABLE_NAME", "=", table));
            return this.executeQuery(select.toString());
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        try {
            columnNamePattern = UcanaccessDatabaseMetadata.normalizeName(columnNamePattern);
            return this.wrapped.getProcedureColumns(catalog, schemaPattern, procedureNamePattern, columnNamePattern);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        try {
            return this.wrapped.getProcedures(catalog, schemaPattern, procedureNamePattern);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        try {
            return this.wrapped.getProcedureTerm();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        try {
            return ((JDBCDatabaseMetaData)this.wrapped).getPseudoColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            return this.wrapped.getResultSetHoldability();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        throw new FeatureNotSupportedException();
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        if (this.connection.isShowSchema()) {
            try {
                return this.wrapped.getSchemas();
            }
            catch (SQLException e) {
                throw new UcanaccessSQLException(e);
            }
        }
        throw new FeatureNotSupportedException();
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        if (this.connection.isShowSchema()) {
            try {
                return this.wrapped.getSchemas(catalog, schemaPattern);
            }
            catch (SQLException e) {
                throw new UcanaccessSQLException(e);
            }
        }
        throw new FeatureNotSupportedException();
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return null;
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        try {
            return this.wrapped.getSearchStringEscape();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        try {
            return this.wrapped.getSQLKeywords();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getSQLStateType() throws SQLException {
        try {
            return this.wrapped.getSQLStateType();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public String getStringFunctions() throws SQLException {
        try {
            return this.wrapped.getStringFunctions();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        try {
            tableNamePattern = UcanaccessDatabaseMetadata.normalizeName(tableNamePattern);
            return this.wrapped.getSuperTables(catalog, schemaPattern, tableNamePattern);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        try {
            return this.wrapped.getSuperTypes(catalog, schemaPattern, typeNamePattern);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        try {
            return this.wrapped.getSystemFunctions();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        try {
            tableNamePattern = UcanaccessDatabaseMetadata.normalizeName(tableNamePattern);
            StringBuffer select = new StringBuffer(this.select("TABLE_PRIVILEGES", Arrays.asList("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME"), Arrays.asList("CAST(null AS VARCHAR(50)) AS  TABLE_CAT ", "CAST(null AS VARCHAR(50)) AS  TABLE_SCHEM", "TABLE_NAME"))).append(this.from("TABLE_PRIVILEGES", "TABLES")).append(this.on(Arrays.asList("TABLE_NAME"), Arrays.asList("ESCAPED_TABLE_NAME"))).append(UcanaccessDatabaseMetadata.and("TABLE_CATALOG", "=", "PUBLIC", " WHERE ")).append(UcanaccessDatabaseMetadata.and("TABLE_SCHEMA", "=", "PUBLIC")).append(UcanaccessDatabaseMetadata.and("TABLE_NAME", "LIKE", tableNamePattern));
            return this.executeQuery(select.toString());
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        try {
            tableNamePattern = UcanaccessDatabaseMetadata.normalizeName(tableNamePattern);
            if (this.invokeWrapper(catalog, schemaPattern)) {
                return this.wrapped.getTables(catalog, schemaPattern, tableNamePattern, types);
            }
            String cat = this.connection.isShowSchema() ? "PUBLIC" : null;
            String schem = this.connection.isShowSchema() ? "PUBLIC" : null;
            StringBuffer select = new StringBuffer(this.select("SYSTEM_TABLES", Arrays.asList("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME"), Arrays.asList(cat, schem, "TABLE_NAME"))).append(this.from("SYSTEM_TABLES", "TABLES")).append(this.on(Arrays.asList("TABLE_NAME"), Arrays.asList("ESCAPED_TABLE_NAME"))).append(UcanaccessDatabaseMetadata.and("TABLE_CAT", "=", "PUBLIC", " WHERE ")).append(UcanaccessDatabaseMetadata.and("TABLE_SCHEM", "=", "PUBLIC")).append(UcanaccessDatabaseMetadata.and("TABLE_NAME", "LIKE", tableNamePattern)).append(this.in(CUSTOM_ALIAS, "TYPE", types));
            return this.executeQuery(select.toString());
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        try {
            return this.wrapped.getTableTypes();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        try {
            return this.wrapped.getTimeDateFunctions();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        try {
            return this.wrapped.getTypeInfo();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        try {
            return this.wrapped.getUDTs(catalog, schemaPattern, typeNamePattern, types);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public String getURL() throws SQLException {
        return this.connection.getUrl();
    }

    @Override
    public String getUserName() throws SQLException {
        try {
            return this.wrapped.getUserName();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        try {
            return this.wrapped.getVersionColumns(catalog, schema, table);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        try {
            return this.wrapped.insertsAreDetected(type);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        try {
            return this.wrapped.isCatalogAtStart();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            return this.wrapped.isReadOnly();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        try {
            return this.wrapped.isWrapperFor(iface);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        try {
            return this.wrapped.locatorsUpdateCopy();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    public static String normalizeName(String name) {
        String stb;
        if (name == null || name.trim().length() == 0) {
            return name;
        }
        if (name.indexOf("%") >= 0) {
            return name.toUpperCase();
        }
        if (name.startsWith("\"") && name.endsWith("\"") && SQLConverter.isListedAsKeyword(stb = name.substring(1, name.length() - 1).toUpperCase())) {
            return stb;
        }
        if (SQLConverter.isListedAsKeyword(name)) {
            return name;
        }
        return SQLConverter.preEscapingIdentifier(name);
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        try {
            return this.wrapped.nullPlusNonNullIsNull();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        try {
            return this.wrapped.nullsAreSortedAtEnd();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        try {
            return this.wrapped.nullsAreSortedAtStart();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        try {
            return this.wrapped.nullsAreSortedHigh();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        try {
            return this.wrapped.nullsAreSortedLow();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        try {
            return this.wrapped.othersDeletesAreVisible(type);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        try {
            return this.wrapped.othersInsertsAreVisible(type);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        try {
            return this.wrapped.othersUpdatesAreVisible(type);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        try {
            return this.wrapped.ownDeletesAreVisible(type);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        try {
            return this.wrapped.ownInsertsAreVisible(type);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        try {
            return this.wrapped.ownUpdatesAreVisible(type);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        try {
            return this.wrapped.storesLowerCaseIdentifiers();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        try {
            return this.wrapped.storesLowerCaseQuotedIdentifiers();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        try {
            return this.wrapped.storesMixedCaseIdentifiers();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        try {
            return this.wrapped.storesMixedCaseQuotedIdentifiers();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        try {
            return this.wrapped.storesUpperCaseIdentifiers();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        try {
            return this.wrapped.storesUpperCaseQuotedIdentifiers();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        try {
            return this.wrapped.supportsAlterTableWithAddColumn();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        try {
            return this.wrapped.supportsAlterTableWithDropColumn();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        try {
            return this.wrapped.supportsANSI92EntryLevelSQL();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        try {
            return this.wrapped.supportsANSI92FullSQL();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        try {
            return this.wrapped.supportsANSI92IntermediateSQL();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        try {
            return this.wrapped.supportsBatchUpdates();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        try {
            return this.wrapped.supportsCatalogsInDataManipulation();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        try {
            return this.wrapped.supportsCatalogsInIndexDefinitions();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        try {
            return this.wrapped.supportsCatalogsInPrivilegeDefinitions();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        try {
            return this.wrapped.supportsCatalogsInProcedureCalls();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        try {
            return this.wrapped.supportsCatalogsInTableDefinitions();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        try {
            return this.wrapped.supportsColumnAliasing();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        try {
            return this.wrapped.supportsConvert();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        try {
            return this.wrapped.supportsConvert(fromType, toType);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        try {
            return this.wrapped.supportsCoreSQLGrammar();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        try {
            return this.wrapped.supportsCorrelatedSubqueries();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        try {
            return this.wrapped.supportsDataDefinitionAndDataManipulationTransactions();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        try {
            return this.wrapped.supportsDataManipulationTransactionsOnly();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        try {
            return this.wrapped.supportsDifferentTableCorrelationNames();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        try {
            return this.wrapped.supportsExpressionsInOrderBy();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        try {
            return this.wrapped.supportsExtendedSQLGrammar();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        try {
            return this.wrapped.supportsFullOuterJoins();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        try {
            return this.wrapped.supportsGetGeneratedKeys();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        try {
            return this.wrapped.supportsGroupBy();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        try {
            return this.wrapped.supportsGroupByBeyondSelect();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        try {
            return this.wrapped.supportsGroupByUnrelated();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        try {
            return this.wrapped.supportsIntegrityEnhancementFacility();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        try {
            return this.wrapped.supportsLikeEscapeClause();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        try {
            return this.wrapped.supportsLimitedOuterJoins();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        try {
            return this.wrapped.supportsMinimumSQLGrammar();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        try {
            return this.wrapped.supportsMixedCaseIdentifiers();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        try {
            return this.wrapped.supportsMixedCaseQuotedIdentifiers();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        try {
            return this.wrapped.supportsMultipleOpenResults();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        try {
            return this.wrapped.supportsMultipleResultSets();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        try {
            return this.wrapped.supportsMultipleTransactions();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        try {
            return this.wrapped.supportsNamedParameters();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        try {
            return this.wrapped.supportsNonNullableColumns();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        try {
            return this.wrapped.supportsOpenCursorsAcrossCommit();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        try {
            return this.wrapped.supportsOpenCursorsAcrossRollback();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        try {
            return this.wrapped.supportsOpenStatementsAcrossCommit();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        try {
            return this.wrapped.supportsOpenStatementsAcrossRollback();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        try {
            return this.wrapped.supportsOrderByUnrelated();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        try {
            return this.wrapped.supportsOuterJoins();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        try {
            return this.wrapped.supportsPositionedDelete();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        try {
            return this.wrapped.supportsPositionedUpdate();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        try {
            return this.wrapped.supportsResultSetConcurrency(type, concurrency);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        try {
            return this.wrapped.supportsResultSetHoldability(holdability);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        try {
            return this.wrapped.supportsResultSetType(type);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        try {
            return this.wrapped.supportsSavepoints();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        try {
            return this.wrapped.supportsSchemasInDataManipulation();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        try {
            return this.wrapped.supportsSchemasInIndexDefinitions();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        try {
            return this.wrapped.supportsSchemasInPrivilegeDefinitions();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        try {
            return this.wrapped.supportsSchemasInProcedureCalls();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        try {
            return this.wrapped.supportsSchemasInTableDefinitions();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        try {
            return this.wrapped.supportsSelectForUpdate();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        try {
            return this.wrapped.supportsStatementPooling();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        try {
            return this.wrapped.supportsStoredFunctionsUsingCallSyntax();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        try {
            return this.wrapped.supportsStoredProcedures();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        try {
            return this.wrapped.supportsSubqueriesInComparisons();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        try {
            return this.wrapped.supportsSubqueriesInExists();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        try {
            return this.wrapped.supportsSubqueriesInIns();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        try {
            return this.wrapped.supportsSubqueriesInQuantifieds();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        try {
            return this.wrapped.supportsTableCorrelationNames();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        try {
            return this.wrapped.supportsTransactionIsolationLevel(level);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        try {
            return this.wrapped.supportsTransactions();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        try {
            return this.wrapped.supportsUnion();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        try {
            return this.wrapped.supportsUnionAll();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return this.wrapped.unwrap(iface);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        try {
            return this.wrapped.updatesAreDetected(type);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        try {
            return this.wrapped.usesLocalFilePerTable();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        try {
            return this.wrapped.usesLocalFiles();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }
}

