/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.ScriptException;
import com.gargoylesoftware.htmlunit.ScriptPreProcessor;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitWrapFactory;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptErrorListener;
import com.gargoylesoftware.htmlunit.javascript.TimeoutError;
import com.gargoylesoftware.htmlunit.javascript.regexp.HtmlUnitRegExpProxy;
import java.io.Serializable;
import java.util.Map;
import net.sourceforge.htmlunit.corejs.javascript.Callable;
import net.sourceforge.htmlunit.corejs.javascript.ClassShutter;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ContextAction;
import net.sourceforge.htmlunit.corejs.javascript.ContextFactory;
import net.sourceforge.htmlunit.corejs.javascript.ErrorReporter;
import net.sourceforge.htmlunit.corejs.javascript.Evaluator;
import net.sourceforge.htmlunit.corejs.javascript.EvaluatorException;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.RegExpProxy;
import net.sourceforge.htmlunit.corejs.javascript.Script;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.WrapFactory;
import net.sourceforge.htmlunit.corejs.javascript.debug.Debugger;

public class HtmlUnitContextFactory
extends ContextFactory {
    private static final int INSTRUCTION_COUNT_THRESHOLD = 10000;
    private final WebClient webClient_;
    private final BrowserVersion browserVersion_;
    private long timeout_;
    private Debugger debugger_;
    private final WrapFactory wrapFactory_ = new HtmlUnitWrapFactory();
    private boolean deminifyFunctionCode_;

    public HtmlUnitContextFactory(WebClient webClient) {
        this.webClient_ = webClient;
        this.browserVersion_ = webClient.getBrowserVersion();
    }

    public void setTimeout(long timeout) {
        this.timeout_ = timeout;
    }

    public long getTimeout() {
        return this.timeout_;
    }

    public void setDebugger(Debugger debugger) {
        this.debugger_ = debugger;
    }

    public Debugger getDebugger() {
        return this.debugger_;
    }

    public void setDeminifyFunctionCode(boolean deminify) {
        this.deminifyFunctionCode_ = deminify;
    }

    public boolean isDeminifyFunctionCode() {
        return this.deminifyFunctionCode_;
    }

    protected String preProcess(HtmlPage htmlPage, String sourceCode, String sourceName, int lineNumber, HtmlElement htmlElement) {
        String newSourceCode = sourceCode;
        ScriptPreProcessor preProcessor = this.webClient_.getScriptPreProcessor();
        if (preProcessor != null && (newSourceCode = preProcessor.preProcess(htmlPage, sourceCode, sourceName, lineNumber, htmlElement)) == null) {
            newSourceCode = "";
        }
        return newSourceCode;
    }

    protected Context makeContext() {
        TimeoutContext cx = new TimeoutContext(this);
        cx.setLanguageVersion(200);
        cx.setClassShutter(new ClassShutter(){

            public boolean visibleToScripts(String fullClassName) {
                Map<String, String> activeXObjectMap = HtmlUnitContextFactory.this.webClient_.getActiveXObjectMap();
                if (activeXObjectMap != null) {
                    for (String mappedClass : activeXObjectMap.values()) {
                        if (!fullClassName.equals(mappedClass)) continue;
                        return true;
                    }
                }
                return false;
            }
        });
        cx.setOptimizationLevel(-1);
        cx.setInstructionObserverThreshold(10000);
        cx.setErrorReporter(new HtmlUnitErrorReporter(this.webClient_.getJavaScriptErrorListener()));
        cx.setWrapFactory(this.wrapFactory_);
        if (this.debugger_ != null) {
            cx.setDebugger(this.debugger_, null);
        }
        ScriptRuntime.setRegExpProxy((Context)cx, (RegExpProxy)new HtmlUnitRegExpProxy(ScriptRuntime.getRegExpProxy((Context)cx), this.browserVersion_));
        cx.setMaximumInterpreterStackDepth(10000);
        return cx;
    }

    protected void observeInstructionCount(Context cx, int instructionCount) {
        TimeoutContext tcx = (TimeoutContext)cx;
        tcx.terminateScriptIfNecessary();
    }

    protected Object doTopCall(Callable callable, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        TimeoutContext tcx = (TimeoutContext)cx;
        tcx.startClock();
        return super.doTopCall(callable, cx, scope, thisObj, args);
    }

    public final <T> T callSecured(ContextAction<T> action, HtmlPage page) {
        try {
            return (T)this.call(action);
        }
        catch (StackOverflowError e) {
            this.webClient_.getJavaScriptErrorListener().scriptException(page, new ScriptException(page, (Throwable)e));
            return null;
        }
    }

    protected boolean hasFeature(Context cx, int featureIndex) {
        switch (featureIndex) {
            case 3: {
                return true;
            }
            case 6: {
                return false;
            }
            case 15: {
                return true;
            }
            case 1: {
                return false;
            }
            case 19: {
                return true;
            }
            case 10: {
                return true;
            }
            case 101: {
                return this.browserVersion_.hasFeature(BrowserVersionFeatures.JS_ARGUMENTS_READ_ONLY_ACCESSED_FROM_FUNCTION);
            }
            case 102: {
                return this.browserVersion_.hasFeature(BrowserVersionFeatures.JS_ERROR_STACK);
            }
            case 103: {
                return true;
            }
            case 104: {
                return true;
            }
            case 105: {
                return this.browserVersion_.hasFeature(BrowserVersionFeatures.JS_PROPERTY_DESCRIPTOR_NAME);
            }
            case 106: {
                return this.browserVersion_.hasFeature(BrowserVersionFeatures.JS_PROPERTY_DESCRIPTOR_NEW_LINE);
            }
            case 107: {
                return false;
            }
        }
        return super.hasFeature(cx, featureIndex);
    }

    private static final class HtmlUnitErrorReporter
    implements ErrorReporter,
    Serializable {
        private final JavaScriptErrorListener javaScriptErrorListener_;

        HtmlUnitErrorReporter(JavaScriptErrorListener javaScriptErrorListener) {
            this.javaScriptErrorListener_ = javaScriptErrorListener;
        }

        public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
            this.javaScriptErrorListener_.warn(message, sourceName, line, lineSource, lineOffset);
        }

        public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
            throw new EvaluatorException(message, sourceName, line, lineSource, lineOffset);
        }

        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
            return new EvaluatorException(message, sourceName, line, lineSource, lineOffset);
        }
    }

    private class TimeoutContext
    extends Context {
        private long startTime_;

        protected TimeoutContext(ContextFactory factory) {
            super(factory);
        }

        public void startClock() {
            this.startTime_ = System.currentTimeMillis();
        }

        public void terminateScriptIfNecessary() {
            long currentTime;
            if (HtmlUnitContextFactory.this.timeout_ > 0L && (currentTime = System.currentTimeMillis()) - this.startTime_ > HtmlUnitContextFactory.this.timeout_) {
                throw new TimeoutError(HtmlUnitContextFactory.this.timeout_, currentTime - this.startTime_);
            }
        }

        protected Script compileString(String source, Evaluator compiler, ErrorReporter compilationErrorReporter, String sourceName, int lineno, Object securityDomain) {
            boolean isWindowEval;
            boolean bl = isWindowEval = compiler != null;
            if (!isWindowEval) {
                int start;
                int length = source.length();
                for (start = 0; start < length && source.charAt(start) <= ' '; ++start) {
                }
                if (start + 3 < length && source.charAt(start++) == '<' && source.charAt(start++) == '!' && source.charAt(start++) == '-' && source.charAt(start++) == '-') {
                    source = source.replaceFirst("<!--", "// <!--");
                }
                if (HtmlUnitContextFactory.this.browserVersion_.hasFeature(BrowserVersionFeatures.JS_IGNORES_LAST_LINE_CONTAINING_UNCOMMENTED)) {
                    int end;
                    for (end = source.length() - 1; end > -1 && source.charAt(end) <= ' '; --end) {
                    }
                    if (1 < end && source.charAt(end--) == '>' && source.charAt(end--) == '-' && source.charAt(end--) == '-') {
                        int lastDoubleSlash = source.lastIndexOf("//");
                        int lastNewLine = Math.max(source.lastIndexOf(10), source.lastIndexOf(13));
                        if (lastNewLine > lastDoubleSlash) {
                            source = source.substring(0, lastNewLine);
                        }
                    }
                }
            }
            HtmlPage page = (HtmlPage)Context.getCurrentContext().getThreadLocal((Object)"startingPage");
            source = HtmlUnitContextFactory.this.preProcess(page, source, sourceName, lineno, null);
            return super.compileString(source, compiler, compilationErrorReporter, sourceName, lineno, securityDomain);
        }

        protected Function compileFunction(Scriptable scope, String source, Evaluator compiler, ErrorReporter compilationErrorReporter, String sourceName, int lineno, Object securityDomain) {
            if (HtmlUnitContextFactory.this.deminifyFunctionCode_) {
                Function f = super.compileFunction(scope, source, compiler, compilationErrorReporter, sourceName, lineno, securityDomain);
                source = this.decompileFunction(f, 4).trim().replace("\n    ", "\n");
            }
            return super.compileFunction(scope, source, compiler, compilationErrorReporter, sourceName, lineno, securityDomain);
        }
    }
}

