/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlAbbreviated;
import com.gargoylesoftware.htmlunit.html.HtmlAcronym;
import com.gargoylesoftware.htmlunit.html.HtmlAddress;
import com.gargoylesoftware.htmlunit.html.HtmlArticle;
import com.gargoylesoftware.htmlunit.html.HtmlAside;
import com.gargoylesoftware.htmlunit.html.HtmlBaseFont;
import com.gargoylesoftware.htmlunit.html.HtmlBidirectionalIsolation;
import com.gargoylesoftware.htmlunit.html.HtmlBidirectionalOverride;
import com.gargoylesoftware.htmlunit.html.HtmlBig;
import com.gargoylesoftware.htmlunit.html.HtmlBody;
import com.gargoylesoftware.htmlunit.html.HtmlBold;
import com.gargoylesoftware.htmlunit.html.HtmlCenter;
import com.gargoylesoftware.htmlunit.html.HtmlCitation;
import com.gargoylesoftware.htmlunit.html.HtmlCode;
import com.gargoylesoftware.htmlunit.html.HtmlDefinition;
import com.gargoylesoftware.htmlunit.html.HtmlDefinitionDescription;
import com.gargoylesoftware.htmlunit.html.HtmlDefinitionTerm;
import com.gargoylesoftware.htmlunit.html.HtmlDivision;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlEmphasis;
import com.gargoylesoftware.htmlunit.html.HtmlFigure;
import com.gargoylesoftware.htmlunit.html.HtmlFigureCaption;
import com.gargoylesoftware.htmlunit.html.HtmlFooter;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlHeader;
import com.gargoylesoftware.htmlunit.html.HtmlItalic;
import com.gargoylesoftware.htmlunit.html.HtmlKeyboard;
import com.gargoylesoftware.htmlunit.html.HtmlLayer;
import com.gargoylesoftware.htmlunit.html.HtmlMain;
import com.gargoylesoftware.htmlunit.html.HtmlMark;
import com.gargoylesoftware.htmlunit.html.HtmlNav;
import com.gargoylesoftware.htmlunit.html.HtmlNoBreak;
import com.gargoylesoftware.htmlunit.html.HtmlNoEmbed;
import com.gargoylesoftware.htmlunit.html.HtmlNoFrames;
import com.gargoylesoftware.htmlunit.html.HtmlNoLayer;
import com.gargoylesoftware.htmlunit.html.HtmlNoScript;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlPlainText;
import com.gargoylesoftware.htmlunit.html.HtmlRp;
import com.gargoylesoftware.htmlunit.html.HtmlRt;
import com.gargoylesoftware.htmlunit.html.HtmlRuby;
import com.gargoylesoftware.htmlunit.html.HtmlS;
import com.gargoylesoftware.htmlunit.html.HtmlSample;
import com.gargoylesoftware.htmlunit.html.HtmlSection;
import com.gargoylesoftware.htmlunit.html.HtmlSmall;
import com.gargoylesoftware.htmlunit.html.HtmlStrike;
import com.gargoylesoftware.htmlunit.html.HtmlStrong;
import com.gargoylesoftware.htmlunit.html.HtmlSubscript;
import com.gargoylesoftware.htmlunit.html.HtmlSummary;
import com.gargoylesoftware.htmlunit.html.HtmlSuperscript;
import com.gargoylesoftware.htmlunit.html.HtmlTable;
import com.gargoylesoftware.htmlunit.html.HtmlTableDataCell;
import com.gargoylesoftware.htmlunit.html.HtmlTeletype;
import com.gargoylesoftware.htmlunit.html.HtmlUnderlined;
import com.gargoylesoftware.htmlunit.html.HtmlVariable;
import com.gargoylesoftware.htmlunit.html.HtmlWordBreak;
import com.gargoylesoftware.htmlunit.javascript.background.BackgroundJavaScriptFactory;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptJob;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClasses;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.ClientRect;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSS2Properties;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.css.ComputedCSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.css.StyleAttributes;
import com.gargoylesoftware.htmlunit.javascript.host.dom.DOMStringMap;
import com.gargoylesoftware.htmlunit.javascript.host.dom.DOMTokenList;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Node;
import com.gargoylesoftware.htmlunit.javascript.host.dom.NodeList;
import com.gargoylesoftware.htmlunit.javascript.host.event.EventHandler;
import com.gargoylesoftware.htmlunit.javascript.host.event.MouseEvent;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLBodyElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLDocument;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLFormElement;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.helpers.AttributesImpl;

@JsxClasses(value={@JsxClass(domClass=HtmlAbbreviated.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78}), @JsxClass(domClass=HtmlAcronym.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78}), @JsxClass(domClass=HtmlAddress.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78}), @JsxClass(domClass=HtmlArticle.class), @JsxClass(domClass=HtmlAside.class), @JsxClass(domClass=HtmlBaseFont.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78}), @JsxClass(domClass=HtmlBidirectionalIsolation.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78}), @JsxClass(domClass=HtmlBidirectionalOverride.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78}), @JsxClass(domClass=HtmlBig.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78}), @JsxClass(domClass=HtmlBold.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78}), @JsxClass(domClass=HtmlCenter.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78}), @JsxClass(domClass=HtmlCitation.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78}), @JsxClass(domClass=HtmlCode.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78}), @JsxClass(domClass=HtmlDefinition.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78}), @JsxClass(domClass=HtmlDefinitionDescription.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78}), @JsxClass(domClass=HtmlDefinitionTerm.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78}), @JsxClass(domClass=HtmlElement.class, value={SupportedBrowser.FF, SupportedBrowser.FF78, SupportedBrowser.IE}), @JsxClass(domClass=HtmlEmphasis.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78}), @JsxClass(domClass=HtmlFigure.class), @JsxClass(domClass=HtmlFigureCaption.class), @JsxClass(domClass=HtmlFooter.class), @JsxClass(domClass=HtmlHeader.class), @JsxClass(domClass=HtmlItalic.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78}), @JsxClass(domClass=HtmlKeyboard.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78}), @JsxClass(domClass=HtmlLayer.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE}), @JsxClass(domClass=HtmlMark.class), @JsxClass(domClass=HtmlNav.class), @JsxClass(domClass=HtmlNoBreak.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78}), @JsxClass(domClass=HtmlNoEmbed.class), @JsxClass(domClass=HtmlNoFrames.class), @JsxClass(domClass=HtmlNoLayer.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE}), @JsxClass(domClass=HtmlNoScript.class), @JsxClass(domClass=HtmlPlainText.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78}), @JsxClass(domClass=HtmlRuby.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE}), @JsxClass(domClass=HtmlRp.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE}), @JsxClass(domClass=HtmlRt.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE}), @JsxClass(domClass=HtmlS.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78}), @JsxClass(domClass=HtmlSample.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78}), @JsxClass(domClass=HtmlSection.class), @JsxClass(domClass=HtmlSmall.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78}), @JsxClass(domClass=HtmlStrike.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78}), @JsxClass(domClass=HtmlStrong.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78}), @JsxClass(domClass=HtmlSubscript.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78}), @JsxClass(domClass=HtmlSummary.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78}), @JsxClass(domClass=HtmlSuperscript.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78}), @JsxClass(domClass=HtmlTeletype.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78}), @JsxClass(domClass=HtmlUnderlined.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78}), @JsxClass(domClass=HtmlWordBreak.class), @JsxClass(domClass=HtmlMain.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78}), @JsxClass(domClass=HtmlVariable.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})})
public class HTMLElement
extends Element {
    private static final Class<?>[] METHOD_PARAMS_OBJECT = new Class[]{Object.class};
    private static final Pattern PERCENT_VALUE = Pattern.compile("\\d+%");
    private static final Map<String, String> COLORS_MAP_IE = new HashMap<String, String>();
    private static final Log LOG = LogFactory.getLog(HTMLElement.class);
    private static final int BEHAVIOR_ID_UNKNOWN = -1;
    public static final int BEHAVIOR_ID_CLIENT_CAPS = 0;
    public static final int BEHAVIOR_ID_HOMEPAGE = 1;
    public static final int BEHAVIOR_ID_DOWNLOAD = 2;
    private static final String BEHAVIOR_CLIENT_CAPS = "#default#clientCaps";
    private static final String BEHAVIOR_HOMEPAGE = "#default#homePage";
    private static final String BEHAVIOR_DOWNLOAD = "#default#download";
    private static AtomicInteger UniqueID_Counter_ = new AtomicInteger(1);
    private final Set<String> behaviors_ = new HashSet<String>();
    private String uniqueID_;
    private boolean endTagForbidden_;

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public HTMLElement() {
    }

    @Override
    public void setDomNode(DomNode domNode) {
        HtmlForm form;
        super.setDomNode(domNode);
        String name = domNode.getLocalName();
        if ("wbr".equalsIgnoreCase(name) || "basefont".equalsIgnoreCase(name) || "keygen".equalsIgnoreCase(name) || "track".equalsIgnoreCase(name)) {
            this.endTagForbidden_ = true;
        }
        if (("input".equalsIgnoreCase(name) || "button".equalsIgnoreCase(name) || "textarea".equalsIgnoreCase(name) || "select".equalsIgnoreCase(name)) && (form = ((HtmlElement)domNode).getEnclosingForm()) != null) {
            this.setParentScope((Scriptable)this.getScriptableFor(form));
        }
    }

    public HTMLFormElement getForm() {
        HtmlForm form = this.getDomNodeOrDie().getEnclosingForm();
        if (form == null) {
            return null;
        }
        return (HTMLFormElement)this.getScriptableFor(form);
    }

    @JsxGetter
    public String getTitle() {
        return this.getDomNodeOrDie().getAttributeDirect("title");
    }

    @JsxSetter
    public void setTitle(String newTitle) {
        this.getDomNodeOrDie().setAttribute("title", newTitle);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public boolean isDisabled() {
        return this.getDomNodeOrDie().hasAttribute("disabled");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setDisabled(boolean disabled) {
        HtmlElement element = this.getDomNodeOrDie();
        if (disabled) {
            element.setAttribute("disabled", "disabled");
        } else {
            element.removeAttribute("disabled");
        }
    }

    @Override
    public String getLocalName() {
        HtmlElement domNode = this.getDomNodeOrDie();
        if (domNode.getHtmlPageOrNull() != null) {
            String prefix = ((DomNode)domNode).getPrefix();
            if (prefix != null) {
                StringBuilder localName = new StringBuilder(prefix.toLowerCase(Locale.ROOT)).append(':').append(((DomNode)domNode).getLocalName().toLowerCase(Locale.ROOT));
                return localName.toString();
            }
            return ((DomNode)domNode).getLocalName().toLowerCase(Locale.ROOT);
        }
        return ((DomNode)domNode).getLocalName();
    }

    @JsxFunction(value={SupportedBrowser.IE})
    public void clearAttributes() {
        HtmlElement node = this.getDomNodeOrDie();
        ArrayList<String> removals = new ArrayList<String>();
        for (String attributeName : node.getAttributesMap().keySet()) {
            if (ScriptableObject.hasProperty((Scriptable)this.getPrototype(), (String)attributeName)) continue;
            removals.add(attributeName);
        }
        for (String attributeName : removals) {
            node.removeAttribute(attributeName);
        }
        for (Iterator<String> iterator : this.getAllIds()) {
            if (iterator instanceof Integer) {
                int i = (Integer)((Object)iterator);
                this.delete(i);
                continue;
            }
            if (!(iterator instanceof String)) continue;
            this.delete((String)((Object)iterator));
        }
    }

    @JsxFunction(value={SupportedBrowser.IE})
    public void mergeAttributes(HTMLElement source, Object preserveIdentity) {
        HtmlElement src = source.getDomNodeOrDie();
        HtmlElement target = this.getDomNodeOrDie();
        if (preserveIdentity instanceof Boolean && !((Boolean)preserveIdentity).booleanValue()) {
            target.setId(src.getId());
            target.setAttribute("name", src.getAttributeDirect("name"));
        }
    }

    @Override
    public void setAttribute(String name, String value) {
        this.getDomNodeOrDie().setAttribute(name, value);
        if (!name.isEmpty() && (name = name.toLowerCase(Locale.ROOT)).startsWith("on")) {
            try {
                name = Character.toUpperCase(name.charAt(0)) + name.substring(1);
                Method method = this.getClass().getMethod("set" + name, METHOD_PARAMS_OBJECT);
                method.invoke((Object)this, new Object[]{new EventHandler(this.getDomNodeOrDie(), name.substring(2), value)});
            }
            catch (IllegalAccessException | NoSuchMethodException method) {
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        }
    }

    protected AttributesImpl readAttributes(HtmlElement element) {
        AttributesImpl attributes = new AttributesImpl();
        for (DomAttr entry : element.getAttributesMap().values()) {
            String name = entry.getName();
            String value = entry.getValue();
            attributes.addAttribute(null, name, name, null, value);
        }
        return attributes;
    }

    @JsxFunction(value={SupportedBrowser.IE})
    public HTMLElement removeNode(boolean removeChildren) {
        HTMLElement parent = (HTMLElement)this.getParentElement();
        if (parent != null) {
            parent.removeChild(this);
            if (!removeChildren) {
                NodeList collection = this.getChildNodes();
                int length = collection.getLength();
                for (int i = 0; i < length; ++i) {
                    Node object = (Node)collection.item(0);
                    parent.appendChild(object);
                }
            }
        }
        return this;
    }

    @Override
    public Object getAttributeNode(String attributeName) {
        return this.getAttributes().getNamedItem(attributeName);
    }

    @Override
    @JsxFunction(value={SupportedBrowser.IE})
    public HTMLCollection getElementsByClassName(String className) {
        return super.getElementsByClassName(className);
    }

    @Override
    @JsxGetter(propertyName="className", value={SupportedBrowser.IE})
    public Object getClassName_js() {
        return super.getClassName_js();
    }

    @Override
    @JsxGetter(value={SupportedBrowser.IE})
    public String getOuterHTML() {
        return super.getOuterHTML();
    }

    @Override
    @JsxSetter(value={SupportedBrowser.IE})
    public void setOuterHTML(Object value) {
        super.setOuterHTML(value);
    }

    @Override
    @JsxGetter(value={SupportedBrowser.IE})
    public String getInnerHTML() {
        return super.getInnerHTML();
    }

    @Override
    @JsxSetter(value={SupportedBrowser.IE})
    public void setInnerHTML(Object value) {
        super.setInnerHTML(value);
    }

    @Override
    @JsxSetter(propertyName="className", value={SupportedBrowser.IE})
    public void setClassName_js(String className) {
        super.setClassName_js(className);
    }

    @Override
    @JsxFunction(value={SupportedBrowser.IE})
    public void insertAdjacentHTML(String position, String text) {
        super.insertAdjacentHTML(position, text);
    }

    @Override
    @JsxFunction(value={SupportedBrowser.IE})
    public void insertAdjacentText(String where, String text) {
        super.insertAdjacentText(where, text);
    }

    @Override
    @JsxFunction(value={SupportedBrowser.IE})
    public Object insertAdjacentElement(String where, Object insertedElement) {
        return super.insertAdjacentElement(where, insertedElement);
    }

    @JsxGetter
    public String getInnerText() {
        StringBuilder buf = new StringBuilder();
        this.printChildren(buf, this.getDomNodeOrDie(), false, false);
        return buf.toString();
    }

    @JsxSetter
    public void setInnerText(Object value) {
        String valueString = value == null && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_INNER_TEXT_VALUE_NULL) ? null : Context.toString((Object)value);
        this.setInnerTextImpl(valueString);
    }

    protected void setInnerTextImpl(String value) {
        HtmlElement domNode = this.getDomNodeOrDie();
        domNode.removeAllChildren();
        if (value != null && !value.isEmpty()) {
            domNode.appendChild(new DomText(domNode.getPage(), value));
        }
    }

    @Override
    public void setTextContent(Object value) {
        this.setInnerTextImpl(value == null ? null : Context.toString((Object)value));
    }

    public int addBehavior(String behavior) {
        if (this.behaviors_.contains(behavior)) {
            return 0;
        }
        Class<?> c = this.getClass();
        if (BEHAVIOR_CLIENT_CAPS.equalsIgnoreCase(behavior)) {
            this.defineProperty("availHeight", c, 0);
            this.defineProperty("availWidth", c, 0);
            this.defineProperty("bufferDepth", c, 0);
            this.defineProperty("colorDepth", c, 0);
            this.defineProperty("connectionType", c, 0);
            this.defineProperty("cookieEnabled", c, 0);
            this.defineProperty("cpuClass", c, 0);
            this.defineProperty("height", c, 0);
            this.defineProperty("javaEnabled", c, 0);
            this.defineProperty("platform", c, 0);
            this.defineProperty("systemLanguage", c, 0);
            this.defineProperty("userLanguage", c, 0);
            this.defineProperty("width", c, 0);
            this.defineFunctionProperties(new String[]{"addComponentRequest"}, c, 0);
            this.defineFunctionProperties(new String[]{"clearComponentRequest"}, c, 0);
            this.defineFunctionProperties(new String[]{"compareVersions"}, c, 0);
            this.defineFunctionProperties(new String[]{"doComponentRequest"}, c, 0);
            this.defineFunctionProperties(new String[]{"getComponentVersion"}, c, 0);
            this.defineFunctionProperties(new String[]{"isComponentInstalled"}, c, 0);
            this.behaviors_.add(BEHAVIOR_CLIENT_CAPS);
            return 0;
        }
        if (BEHAVIOR_HOMEPAGE.equalsIgnoreCase(behavior)) {
            this.defineFunctionProperties(new String[]{"isHomePage"}, c, 0);
            this.defineFunctionProperties(new String[]{"setHomePage"}, c, 0);
            this.defineFunctionProperties(new String[]{"navigateHomePage"}, c, 0);
            this.behaviors_.add(BEHAVIOR_CLIENT_CAPS);
            return 1;
        }
        if (BEHAVIOR_DOWNLOAD.equalsIgnoreCase(behavior)) {
            this.defineFunctionProperties(new String[]{"startDownload"}, c, 0);
            this.behaviors_.add(BEHAVIOR_DOWNLOAD);
            return 2;
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("Unimplemented behavior: " + behavior));
        }
        return -1;
    }

    public void removeBehavior(int id) {
        switch (id) {
            case 0: {
                this.delete("availHeight");
                this.delete("availWidth");
                this.delete("bufferDepth");
                this.delete("colorDepth");
                this.delete("connectionType");
                this.delete("cookieEnabled");
                this.delete("cpuClass");
                this.delete("height");
                this.delete("javaEnabled");
                this.delete("platform");
                this.delete("systemLanguage");
                this.delete("userLanguage");
                this.delete("width");
                this.delete("addComponentRequest");
                this.delete("clearComponentRequest");
                this.delete("compareVersions");
                this.delete("doComponentRequest");
                this.delete("getComponentVersion");
                this.delete("isComponentInstalled");
                this.behaviors_.remove(BEHAVIOR_CLIENT_CAPS);
                break;
            }
            case 1: {
                this.delete("isHomePage");
                this.delete("setHomePage");
                this.delete("navigateHomePage");
                this.behaviors_.remove(BEHAVIOR_HOMEPAGE);
                break;
            }
            case 2: {
                this.delete("startDownload");
                this.behaviors_.remove(BEHAVIOR_DOWNLOAD);
                break;
            }
            default: {
                if (!LOG.isWarnEnabled()) break;
                LOG.warn((Object)("Unexpected behavior id: " + id + ". Ignoring."));
            }
        }
    }

    public int getAvailHeight() {
        return this.getWindow().getScreen().getAvailHeight();
    }

    public int getAvailWidth() {
        return this.getWindow().getScreen().getAvailWidth();
    }

    public int getBufferDepth() {
        return this.getWindow().getScreen().getBufferDepth();
    }

    public int getColorDepth() {
        return this.getWindow().getScreen().getColorDepth();
    }

    public boolean isCookieEnabled() {
        return this.getWindow().getNavigator().isCookieEnabled();
    }

    public String getCpuClass() {
        return this.getWindow().getNavigator().getCpuClass();
    }

    public int getHeight() {
        return this.getWindow().getScreen().getHeight();
    }

    public boolean isJavaEnabled() {
        return this.getWindow().getNavigator().javaEnabled();
    }

    public String getPlatform() {
        return this.getWindow().getNavigator().getPlatform();
    }

    public String getSystemLanguage() {
        return this.getWindow().getNavigator().getSystemLanguage();
    }

    public String getUserLanguage() {
        return this.getWindow().getNavigator().getUserLanguage();
    }

    public int getWidth() {
        return this.getWindow().getScreen().getWidth();
    }

    public void addComponentRequest(String id, String idType, String minVersion) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Call to addComponentRequest(" + id + ", " + idType + ", " + minVersion + ") ignored."));
        }
    }

    public void clearComponentRequest() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Call to clearComponentRequest() ignored.");
        }
    }

    public int compareVersions(String v1, String v2) {
        int i = v1.compareTo(v2);
        if (i == 0) {
            return 0;
        }
        if (i < 0) {
            return -1;
        }
        return 1;
    }

    public boolean doComponentRequest() {
        return false;
    }

    public String getComponentVersion(String id, String idType) {
        if ("{E5D12C4E-7B4F-11D3-B5C9-0050045C3C96}".equals(id)) {
            return "";
        }
        return "1.0";
    }

    public boolean isComponentInstalled(String id, String idType, String minVersion) {
        return false;
    }

    public void startDownload(String uri, Function callback) throws MalformedURLException {
        WebWindow ww = this.getWindow().getWebWindow();
        HtmlPage page = (HtmlPage)ww.getEnclosedPage();
        URL url = page.getFullyQualifiedUrl(uri);
        if (!page.getUrl().getHost().equals(url.getHost())) {
            throw Context.reportRuntimeError((String)("Not authorized url: " + url));
        }
        JavaScriptJob job = BackgroundJavaScriptFactory.theFactory().createDownloadBehaviorJob(url, callback, ww.getWebClient());
        page.getEnclosingWindow().getJobManager().addJob(job, page);
    }

    public boolean isHomePage(String url) {
        try {
            URL newUrl = new URL(url);
            URL currentUrl = this.getDomNodeOrDie().getPage().getUrl();
            String home = this.getDomNodeOrDie().getPage().getEnclosingWindow().getWebClient().getOptions().getHomePage();
            boolean sameDomains = newUrl.getHost().equalsIgnoreCase(currentUrl.getHost());
            boolean isHomePage = home != null && home.equals(url);
            return sameDomains && isHomePage;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public void setHomePage(String url) {
        this.getDomNodeOrDie().getPage().getEnclosingWindow().getWebClient().getOptions().setHomePage(url);
    }

    public void navigateHomePage() throws IOException {
        WebClient webClient = this.getDomNodeOrDie().getPage().getEnclosingWindow().getWebClient();
        webClient.getPage(webClient.getOptions().getHomePage());
    }

    @JsxGetter
    public int getOffsetHeight() {
        if (this.isDisplayNone() || !this.getDomNodeOrDie().isAttachedToPage()) {
            return 0;
        }
        MouseEvent event = MouseEvent.getCurrentMouseEvent();
        if (this.isAncestorOfEventTarget(event)) {
            return event.getClientY() - this.getPosY() + 50;
        }
        CSS2Properties style = this.getWindow().getComputedStyle(this, null);
        return style.getCalculatedHeight(true, true);
    }

    @JsxGetter
    public int getOffsetWidth() {
        if (this.isDisplayNone() || !this.getDomNodeOrDie().isAttachedToPage()) {
            return 0;
        }
        MouseEvent event = MouseEvent.getCurrentMouseEvent();
        if (this.isAncestorOfEventTarget(event)) {
            return event.getClientX() - this.getPosX() + 50;
        }
        CSS2Properties style = this.getWindow().getComputedStyle(this, null);
        return style.getCalculatedWidth(true, true);
    }

    protected boolean isAncestorOfEventTarget(MouseEvent event) {
        if (event == null) {
            return false;
        }
        if (!(event.getSrcElement() instanceof HTMLElement)) {
            return false;
        }
        HTMLElement srcElement = (HTMLElement)event.getSrcElement();
        return this.getDomNodeOrDie().isAncestorOf(srcElement.getDomNodeOrDie());
    }

    public String toString() {
        return "HTMLElement for " + this.getDomNodeOrNull();
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setTagUrn(String tagUrn) {
        throw Context.reportRuntimeError((String)("Error trying to set tagUrn to '" + tagUrn + "'."));
    }

    public HTMLElement getParentHTMLElement() {
        Node parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof HTMLElement); parent = parent.getParent()) {
        }
        return (HTMLElement)parent;
    }

    @Override
    @JsxFunction(value={SupportedBrowser.IE})
    public void scrollIntoView() {
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getUniqueID() {
        if (this.uniqueID_ == null) {
            this.uniqueID_ = "ms__id" + UniqueID_Counter_.incrementAndGet();
        }
        return this.uniqueID_;
    }

    @Override
    public HtmlElement getDomNodeOrDie() {
        return (HtmlElement)super.getDomNodeOrDie();
    }

    @Override
    public HtmlElement getDomNodeOrNull() {
        return (HtmlElement)super.getDomNodeOrNull();
    }

    @JsxFunction
    public void blur() {
        this.getDomNodeOrDie().blur();
    }

    @JsxFunction
    public void focus() {
        this.getDomNodeOrDie().focus();
    }

    @JsxFunction(value={SupportedBrowser.IE})
    public void setActive() {
        Window window = this.getWindow();
        HTMLDocument document = (HTMLDocument)window.getDocument();
        document.setActiveElement(this);
        if (window.getWebWindow() == window.getWebWindow().getWebClient().getCurrentWindow()) {
            HtmlElement element = this.getDomNodeOrDie();
            ((HtmlPage)element.getPage()).setFocusedElement(element);
        }
    }

    @Override
    public String getNodeName() {
        HtmlElement domNode = this.getDomNodeOrDie();
        String nodeName = ((DomNode)domNode).getNodeName();
        if (domNode.getHtmlPageOrNull() != null) {
            nodeName = nodeName.toUpperCase(Locale.ROOT);
        }
        return nodeName;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @JsxFunction
    public void click() throws IOException {
        this.getDomNodeOrDie().click(false, false, false, true, true, false);
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF78})
    public boolean isSpellcheck() {
        return Context.toBoolean((Object)this.getDomNodeOrDie().getAttributeDirect("spellcheck"));
    }

    @JsxSetter(value={SupportedBrowser.FF, SupportedBrowser.FF78})
    public void setSpellcheck(boolean spellcheck) {
        this.getDomNodeOrDie().setAttribute("spellcheck", Boolean.toString(spellcheck));
    }

    @JsxGetter
    public String getLang() {
        return this.getDomNodeOrDie().getAttributeDirect("lang");
    }

    @JsxSetter
    public void setLang(String lang) {
        this.getDomNodeOrDie().setAttribute("lang", lang);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getLanguage() {
        return this.getDomNodeOrDie().getAttributeDirect("language");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setLanguage(String language) {
        this.getDomNodeOrDie().setAttribute("language", language);
    }

    @JsxGetter
    public String getDir() {
        return this.getDomNodeOrDie().getAttributeDirect("dir");
    }

    @JsxSetter
    public void setDir(String dir) {
        this.getDomNodeOrDie().setAttribute("dir", dir);
    }

    @JsxGetter
    public int getTabIndex() {
        return (int)Context.toNumber((Object)this.getDomNodeOrDie().getAttributeDirect("tabindex"));
    }

    @JsxSetter
    public void setTabIndex(int tabIndex) {
        this.getDomNodeOrDie().setAttribute("tabindex", Integer.toString(tabIndex));
    }

    @JsxGetter
    public String getAccessKey() {
        return this.getDomNodeOrDie().getAttributeDirect("accesskey");
    }

    @JsxSetter
    public void setAccessKey(String accessKey) {
        this.getDomNodeOrDie().setAttribute("accesskey", accessKey);
    }

    protected String getWidthOrHeight(String attributeName, Boolean returnNegativeValues) {
        String value;
        block4: {
            value = this.getDomNodeOrDie().getAttribute(attributeName);
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_WIDTH_HEIGHT_ACCEPTS_ARBITRARY_VALUES)) {
                return value;
            }
            if (!PERCENT_VALUE.matcher(value).matches()) {
                try {
                    Float f = Float.valueOf(value);
                    int i = f.intValue();
                    value = i < 0 ? (returnNegativeValues == null ? "0" : (!returnNegativeValues.booleanValue() ? "" : Integer.toString(i))) : Integer.toString(i);
                }
                catch (NumberFormatException e) {
                    if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_WIDTH_HEIGHT_ACCEPTS_ARBITRARY_VALUES)) break block4;
                    value = "";
                }
            }
        }
        return value;
    }

    protected void setWidthOrHeight(String attributeName, String value, boolean allowNegativeValues) {
        if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_WIDTH_HEIGHT_ACCEPTS_ARBITRARY_VALUES) && !value.isEmpty()) {
            if (value.endsWith("px")) {
                value = value.substring(0, value.length() - 2);
            }
            boolean error = false;
            if (!PERCENT_VALUE.matcher(value).matches()) {
                try {
                    Float f = Float.valueOf(value);
                    int i = f.intValue();
                    if (i < 0 && !allowNegativeValues) {
                        error = true;
                    }
                }
                catch (NumberFormatException e) {
                    error = true;
                }
            }
            if (error) {
                Exception e = new Exception("Cannot set the '" + attributeName + "' property to invalid value: '" + value + "'");
                Context.throwAsScriptRuntimeEx((Throwable)e);
            }
        }
        this.getDomNodeOrDie().setAttribute(attributeName, value);
    }

    protected void setColorAttribute(String name, String value) {
        String s = value;
        if (!s.isEmpty()) {
            boolean restrict = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTML_COLOR_RESTRICT);
            boolean isName = false;
            if (restrict) {
                for (String key : COLORS_MAP_IE.keySet()) {
                    if (!key.equalsIgnoreCase(value)) continue;
                    isName = true;
                    break;
                }
            }
            if (!isName && restrict) {
                if (s.charAt(0) == '#') {
                    s = s.substring(1);
                }
                StringBuilder builder = new StringBuilder(7);
                for (int x = 0; x < 6 && x < s.length(); ++x) {
                    char ch = s.charAt(x);
                    if (ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F') {
                        builder.append(ch);
                        continue;
                    }
                    builder.append('0');
                }
                builder.insert(0, '#');
                s = builder.toString();
            }
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTML_COLOR_TO_LOWER)) {
                s = s.toLowerCase(Locale.ROOT);
            }
        }
        this.getDomNodeOrDie().setAttribute(name, s);
    }

    protected String getAlign(boolean returnInvalidValues) {
        boolean acceptArbitraryValues = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ALIGN_ACCEPTS_ARBITRARY_VALUES);
        String align = this.getDomNodeOrDie().getAttributeDirect("align");
        if (returnInvalidValues || acceptArbitraryValues || "center".equals(align) || "justify".equals(align) || "left".equals(align) || "right".equals(align)) {
            return align;
        }
        return "";
    }

    protected void setAlign(String align, boolean ignoreIfNoError) {
        String alignLC = align.toLowerCase(Locale.ROOT);
        boolean acceptArbitraryValues = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ALIGN_ACCEPTS_ARBITRARY_VALUES);
        if (acceptArbitraryValues || "center".equals(alignLC) || "justify".equals(alignLC) || "left".equals(alignLC) || "right".equals(alignLC) || "bottom".equals(alignLC) || "middle".equals(alignLC) || "top".equals(alignLC)) {
            if (!ignoreIfNoError) {
                String newValue = acceptArbitraryValues ? align : alignLC;
                this.getDomNodeOrDie().setAttribute("align", newValue);
            }
            return;
        }
        throw Context.reportRuntimeError((String)("Cannot set the align property to invalid value: '" + align + "'"));
    }

    protected String getVAlign(String[] valid, String defaultValue) {
        String valign = this.getDomNodeOrDie().getAttributeDirect("valign");
        String valignLC = valign.toLowerCase(Locale.ROOT);
        if (valid == null || ArrayUtils.contains((Object[])valid, (Object)valignLC)) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_VALIGN_CONVERTS_TO_LOWERCASE)) {
                return valignLC;
            }
            return valign;
        }
        return defaultValue;
    }

    protected void setVAlign(Object vAlign, String[] valid) {
        String valign = Context.toString((Object)vAlign);
        String valignLC = valign.toLowerCase(Locale.ROOT);
        if (valid == null || ArrayUtils.contains((Object[])valid, (Object)valignLC)) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_VALIGN_CONVERTS_TO_LOWERCASE)) {
                this.getDomNodeOrDie().setAttribute("valign", valignLC);
            } else {
                this.getDomNodeOrDie().setAttribute("valign", valign);
            }
        } else {
            throw Context.reportRuntimeError((String)("Cannot set the vAlign property to invalid value: " + vAlign));
        }
    }

    protected String getCh() {
        return this.getDomNodeOrDie().getAttributeDirect("char");
    }

    protected void setCh(String ch) {
        this.getDomNodeOrDie().setAttribute("char", ch);
    }

    protected String getChOff() {
        return this.getDomNodeOrDie().getAttribute("charOff");
    }

    protected void setChOff(String chOff) {
        try {
            float f = Float.parseFloat(chOff);
            int i = (int)f;
            chOff = (float)i == f ? Integer.toString(i) : Float.toString(f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.getDomNodeOrDie().setAttribute("charOff", chOff);
    }

    @JsxGetter
    public int getOffsetLeft() {
        if (this instanceof HTMLBodyElement) {
            return 0;
        }
        int left = 0;
        HTMLElement offsetParent = this.getOffsetParent();
        DomNode node = this.getDomNodeOrDie();
        HTMLElement element = (HTMLElement)node.getScriptableObject();
        CSS2Properties style = element.getWindow().getComputedStyle(element, null);
        left += style.getLeft(true, false, false);
        String position = style.getPositionWithInheritance();
        if ("absolute".equals(position)) {
            return left;
        }
        for (node = node.getParentNode(); node != null && node.getScriptableObject() != offsetParent; node = node.getParentNode()) {
            if (!(node.getScriptableObject() instanceof HTMLElement)) continue;
            element = (HTMLElement)node.getScriptableObject();
            style = element.getWindow().getComputedStyle(element, null);
            left += style.getLeft(true, true, true);
        }
        if (offsetParent != null) {
            style = offsetParent.getWindow().getComputedStyle(offsetParent, null);
            left += style.getMarginLeftValue();
            left += style.getPaddingLeftValue();
        }
        return left;
    }

    public int getPosX() {
        int cumulativeOffset = 0;
        for (HTMLElement element = this; element != null; element = element.getOffsetParent()) {
            cumulativeOffset += element.getOffsetLeft();
            if (element == this) continue;
            CSS2Properties style = element.getWindow().getComputedStyle(element, null);
            cumulativeOffset += style.getBorderLeftValue();
        }
        return cumulativeOffset;
    }

    public int getPosY() {
        int cumulativeOffset = 0;
        for (HTMLElement element = this; element != null; element = element.getOffsetParent()) {
            cumulativeOffset += element.getOffsetTop();
            if (element == this) continue;
            CSS2Properties style = element.getWindow().getComputedStyle(element, null);
            cumulativeOffset += style.getBorderTopValue();
        }
        return cumulativeOffset;
    }

    private HTMLElement getOffsetParent() {
        Object offsetParent = this.getOffsetParentInternal(false);
        if (offsetParent instanceof HTMLElement) {
            return (HTMLElement)offsetParent;
        }
        return null;
    }

    @JsxGetter
    public int getOffsetTop() {
        if (this instanceof HTMLBodyElement) {
            return 0;
        }
        int top = 0;
        HTMLElement offsetParent = this.getOffsetParent();
        DomNode node = this.getDomNodeOrDie();
        HTMLElement element = (HTMLElement)node.getScriptableObject();
        CSS2Properties style = element.getWindow().getComputedStyle(element, null);
        top += style.getTop(true, false, false);
        String position = style.getPositionWithInheritance();
        if ("absolute".equals(position)) {
            return top;
        }
        for (node = node.getParentNode(); node != null && node.getScriptableObject() != offsetParent; node = node.getParentNode()) {
            if (!(node.getScriptableObject() instanceof HTMLElement)) continue;
            element = (HTMLElement)node.getScriptableObject();
            style = element.getWindow().getComputedStyle(element, null);
            top += style.getTop(false, true, true);
        }
        if (offsetParent != null) {
            HTMLElement thiz = (HTMLElement)this.getDomNodeOrDie().getScriptableObject();
            style = thiz.getWindow().getComputedStyle(thiz, null);
            boolean thisElementHasTopMargin = style.getMarginTopValue() != 0;
            style = offsetParent.getWindow().getComputedStyle(offsetParent, null);
            if (!thisElementHasTopMargin) {
                top += style.getMarginTopValue();
            }
            top += style.getPaddingTopValue();
        }
        return top;
    }

    @JsxGetter(propertyName="offsetParent")
    public Object getOffsetParent_js() {
        return this.getOffsetParentInternal(this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_OFFSET_PARENT_NULL_IF_FIXED));
    }

    private Object getOffsetParentInternal(boolean returnNullIfFixed) {
        DomNode currentElement = this.getDomNodeOrDie();
        if (currentElement.getParentNode() == null) {
            return null;
        }
        HTMLElement htmlElement = (HTMLElement)currentElement.getScriptableObject();
        if (returnNullIfFixed && "fixed".equals(htmlElement.getStyle().getStyleAttribute(StyleAttributes.Definition.POSITION, true))) {
            return null;
        }
        CSS2Properties style = htmlElement.getWindow().getComputedStyle(htmlElement, null);
        String position = style.getPositionWithInheritance();
        boolean staticPos = "static".equals(position);
        while (currentElement != null) {
            HTMLElement parentElement;
            CSS2Properties parentStyle;
            String parentPosition;
            DomNode parentNode = currentElement.getParentNode();
            if (parentNode instanceof HtmlBody || staticPos && parentNode instanceof HtmlTableDataCell || staticPos && parentNode instanceof HtmlTable) {
                return parentNode.getScriptableObject();
            }
            if (parentNode != null && parentNode.getScriptableObject() instanceof HTMLElement && !"static".equals(parentPosition = (parentStyle = (parentElement = (HTMLElement)parentNode.getScriptableObject()).getWindow().getComputedStyle(parentElement, null)).getPositionWithInheritance())) {
                return parentNode.getScriptableObject();
            }
            currentElement = currentElement.getParentNode();
        }
        return null;
    }

    @Override
    public ClientRect getBoundingClientRect() {
        ClientRect textRectangle = super.getBoundingClientRect();
        int left = this.getPosX();
        int top = this.getPosY();
        Object parentNode = this.getOffsetParentInternal(false);
        while (parentNode != null && parentNode instanceof HTMLElement && !(parentNode instanceof HTMLBodyElement)) {
            HTMLElement elem = (HTMLElement)parentNode;
            left -= elem.getScrollLeft();
            top -= elem.getScrollTop();
            parentNode = elem.getParentNode();
        }
        textRectangle.setBottom(top + this.getOffsetHeight());
        textRectangle.setLeft(left);
        textRectangle.setRight(left + this.getOffsetWidth());
        textRectangle.setTop(top);
        return textRectangle;
    }

    @Override
    @JsxGetter(value={SupportedBrowser.IE})
    public DOMTokenList getClassList() {
        return super.getClassList();
    }

    @Override
    @JsxGetter(value={SupportedBrowser.IE})
    public HTMLCollection getChildren() {
        return super.getChildren();
    }

    @Override
    @JsxGetter(value={SupportedBrowser.IE})
    public Element getParentElement() {
        return super.getParentElement();
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78, SupportedBrowser.IE})
    public DOMStringMap getDataset() {
        return new DOMStringMap(this);
    }

    @Override
    protected boolean isEndTagForbidden() {
        return this.endTagForbidden_;
    }

    protected boolean isLowerCaseInOuterHtml() {
        return false;
    }

    @JsxSetter
    public void setOnchange(Object onchange) {
        this.setEventHandler("change", onchange);
    }

    @JsxGetter
    public Function getOnchange() {
        return this.getEventHandler("change");
    }

    @JsxGetter
    public Object getOnsubmit() {
        return this.getEventHandler("submit");
    }

    @JsxSetter
    public void setOnsubmit(Object onsubmit) {
        this.setEventHandler("submit", onsubmit);
    }

    @Override
    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Function getOnwheel() {
        return super.getOnwheel();
    }

    @Override
    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnwheel(Object onwheel) {
        super.setOnwheel(onwheel);
    }

    @Override
    @JsxFunction(value={SupportedBrowser.IE})
    public void setCapture(boolean retargetToElement) {
        super.setCapture(retargetToElement);
    }

    @Override
    @JsxFunction(value={SupportedBrowser.IE})
    public boolean releaseCapture() {
        return super.releaseCapture();
    }

    @JsxGetter
    public String getContentEditable() {
        String attribute = this.getDomNodeOrDie().getAttribute("contentEditable");
        if (attribute == DomElement.ATTRIBUTE_NOT_DEFINED) {
            return "inherit";
        }
        if (attribute == DomElement.ATTRIBUTE_VALUE_EMPTY) {
            return "true";
        }
        return attribute;
    }

    @JsxSetter
    public void setContentEditable(String contentEditable) {
        this.getDomNodeOrDie().setAttribute("contentEditable", contentEditable);
    }

    @JsxGetter
    public boolean isIsContentEditable() {
        Object parentScriptable;
        DomNode parent;
        String attribute = this.getContentEditable();
        if ("true".equals(attribute)) {
            return true;
        }
        if ("inherit".equals(attribute) && (parent = this.getDomNodeOrDie().getParentNode()) != null && (parentScriptable = parent.getScriptableObject()) instanceof HTMLElement) {
            return ((HTMLElement)parentScriptable).isIsContentEditable();
        }
        return false;
    }

    @Override
    @JsxGetter
    public CSSStyleDeclaration getStyle() {
        return super.getStyle();
    }

    @Override
    @JsxSetter
    public void setStyle(String style) {
        super.setStyle(style);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public CSSStyleDeclaration getRuntimeStyle() {
        return super.getStyle();
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public ComputedCSSStyleDeclaration getCurrentStyle() {
        if (!this.getDomNodeOrDie().isAttachedToPage()) {
            return null;
        }
        return this.getWindow().getComputedStyle(this, null);
    }

    @JsxSetter
    public void setOnclick(Object handler) {
        this.setEventHandler("click", handler);
    }

    @JsxGetter
    public Object getOnclick() {
        return this.getEventHandler("click");
    }

    @JsxSetter
    public void setOndblclick(Object handler) {
        this.setEventHandler("dblclick", handler);
    }

    @JsxGetter
    public Object getOndblclick() {
        return this.getEventHandler("dblclick");
    }

    @JsxSetter
    public void setOnblur(Object handler) {
        this.setEventHandler("blur", handler);
    }

    @JsxGetter
    public Object getOnblur() {
        return this.getEventHandler("blur");
    }

    @JsxSetter
    public void setOnfocus(Object handler) {
        this.setEventHandler("focus", handler);
    }

    @JsxGetter
    public Object getOnfocus() {
        return this.getEventHandler("focus");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnfocusin(Object handler) {
        this.setEventHandler("focusin", handler);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Object getOnfocusin() {
        return this.getEventHandler("focusin");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnfocusout(Object handler) {
        this.setEventHandler("focusout", handler);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Object getOnfocusout() {
        return this.getEventHandler("focusout");
    }

    @JsxSetter
    public void setOnkeydown(Object handler) {
        this.setEventHandler("keydown", handler);
    }

    @JsxGetter
    public Object getOnkeydown() {
        return this.getEventHandler("keydown");
    }

    @JsxSetter
    public void setOnkeypress(Object handler) {
        this.setEventHandler("keypress", handler);
    }

    @JsxGetter
    public Object getOnkeypress() {
        return this.getEventHandler("keypress");
    }

    @JsxSetter
    public void setOnkeyup(Object handler) {
        this.setEventHandler("keyup", handler);
    }

    @JsxGetter
    public Object getOnkeyup() {
        return this.getEventHandler("keyup");
    }

    @JsxSetter
    public void setOnmousedown(Object handler) {
        this.setEventHandler("mousedown", handler);
    }

    @JsxGetter
    public Object getOnmousedown() {
        return this.getEventHandler("mousedown");
    }

    @JsxSetter
    public void setOnmousemove(Object handler) {
        this.setEventHandler("mousemove", handler);
    }

    @JsxGetter
    public Object getOnmousemove() {
        return this.getEventHandler("mousemove");
    }

    @JsxSetter
    public void setOnmouseout(Object handler) {
        this.setEventHandler("mouseout", handler);
    }

    @JsxGetter
    public Object getOnmouseout() {
        return this.getEventHandler("mouseout");
    }

    @JsxSetter
    public void setOnmouseover(Object handler) {
        this.setEventHandler("mouseover", handler);
    }

    @JsxGetter
    public Object getOnmouseover() {
        return this.getEventHandler("mouseover");
    }

    @JsxSetter
    public void setOnmouseup(Object handler) {
        this.setEventHandler("mouseup", handler);
    }

    @JsxGetter
    public Object getOnmouseup() {
        return this.getEventHandler("mouseup");
    }

    @JsxSetter
    public void setOncontextmenu(Object handler) {
        this.setEventHandler("contextmenu", handler);
    }

    @JsxGetter
    public Object getOncontextmenu() {
        return this.getEventHandler("contextmenu");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public void setOnresize(Object handler) {
        this.setEventHandler("resize", handler);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public Function getOnresize() {
        return this.getEventHandler("resize");
    }

    @JsxSetter
    public void setOnerror(Object handler) {
        this.setEventHandler("error", handler);
    }

    @JsxGetter
    public Object getOnerror() {
        return this.getEventHandler("error");
    }

    @JsxGetter
    public Function getOninput() {
        return this.getEventHandler("input");
    }

    @JsxSetter
    public void setOninput(Object oninput) {
        this.setEventHandler("input", oninput);
    }

    @Override
    @JsxFunction(value={SupportedBrowser.IE})
    public boolean contains(Object element) {
        return super.contains(element);
    }

    @JsxGetter
    public boolean isHidden() {
        return this.getDomNodeOrDie().isHidden();
    }

    @JsxSetter
    public void setHidden(boolean hidden) {
        if (hidden) {
            this.getDomNodeOrDie().setAttribute("hidden", "hidden");
        } else {
            this.getDomNodeOrDie().removeAttribute("hidden");
        }
    }

    @Override
    @JsxGetter(value={SupportedBrowser.IE})
    public String getId() {
        return super.getId();
    }

    @Override
    @JsxSetter(value={SupportedBrowser.IE})
    public void setId(String newId) {
        super.setId(newId);
    }

    @JsxGetter
    public Function getOnabort() {
        return this.getEventHandler("abort");
    }

    @JsxSetter
    public void setOnabort(Object onabort) {
        this.setEventHandler("abort", onabort);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Function getOnauxclick() {
        return this.getEventHandler("auxclick");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnauxclick(Object onauxclick) {
        this.setEventHandler("auxclick", onauxclick);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Function getOncancel() {
        return this.getEventHandler("cancel");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOncancel(Object oncancel) {
        this.setEventHandler("cancel", oncancel);
    }

    @JsxGetter
    public Function getOncanplay() {
        return this.getEventHandler("canplay");
    }

    @JsxSetter
    public void setOncanplay(Object oncanplay) {
        this.setEventHandler("canplay", oncanplay);
    }

    @JsxGetter
    public Function getOncanplaythrough() {
        return this.getEventHandler("canplaythrough");
    }

    @JsxSetter
    public void setOncanplaythrough(Object oncanplaythrough) {
        this.setEventHandler("canplaythrough", oncanplaythrough);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Function getOnclose() {
        return this.getEventHandler("close");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnclose(Object onclose) {
        this.setEventHandler("close", onclose);
    }

    @JsxGetter
    public Function getOncuechange() {
        return this.getEventHandler("cuechange");
    }

    @JsxSetter
    public void setOncuechange(Object oncuechange) {
        this.setEventHandler("cuechange", oncuechange);
    }

    @JsxGetter
    public Function getOndrag() {
        return this.getEventHandler("drag");
    }

    @JsxSetter
    public void setOndrag(Object ondrag) {
        this.setEventHandler("drag", ondrag);
    }

    @JsxGetter
    public Function getOndragend() {
        return this.getEventHandler("dragend");
    }

    @JsxSetter
    public void setOndragend(Object ondragend) {
        this.setEventHandler("dragend", ondragend);
    }

    @JsxGetter
    public Function getOndragenter() {
        return this.getEventHandler("dragenter");
    }

    @JsxSetter
    public void setOndragenter(Object ondragenter) {
        this.setEventHandler("dragenter", ondragenter);
    }

    @JsxGetter
    public Function getOndragleave() {
        return this.getEventHandler("dragleave");
    }

    @JsxSetter
    public void setOndragleave(Object ondragleave) {
        this.setEventHandler("dragleave", ondragleave);
    }

    @JsxGetter
    public Function getOndragover() {
        return this.getEventHandler("dragover");
    }

    @JsxSetter
    public void setOndragover(Object ondragover) {
        this.setEventHandler("dragover", ondragover);
    }

    @JsxGetter
    public Function getOndragstart() {
        return this.getEventHandler("dragstart");
    }

    @JsxSetter
    public void setOndragstart(Object ondragstart) {
        this.setEventHandler("dragstart", ondragstart);
    }

    @JsxGetter
    public Function getOndrop() {
        return this.getEventHandler("drop");
    }

    @JsxSetter
    public void setOndrop(Object ondrop) {
        this.setEventHandler("drop", ondrop);
    }

    @JsxGetter
    public Function getOndurationchange() {
        return this.getEventHandler("durationchange");
    }

    @JsxSetter
    public void setOndurationchange(Object ondurationchange) {
        this.setEventHandler("durationchange", ondurationchange);
    }

    @JsxGetter
    public Function getOnemptied() {
        return this.getEventHandler("emptied");
    }

    @JsxSetter
    public void setOnemptied(Object onemptied) {
        this.setEventHandler("emptied", onemptied);
    }

    @JsxGetter
    public Function getOnended() {
        return this.getEventHandler("ended");
    }

    @JsxSetter
    public void setOnended(Object onended) {
        this.setEventHandler("ended", onended);
    }

    @Override
    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public Function getOngotpointercapture() {
        return this.getEventHandler("gotpointercapture");
    }

    @Override
    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public void setOngotpointercapture(Object ongotpointercapture) {
        this.setEventHandler("gotpointercapture", ongotpointercapture);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public Function getOninvalid() {
        return this.getEventHandler("invalid");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public void setOninvalid(Object oninvalid) {
        this.setEventHandler("invalid", oninvalid);
    }

    @JsxGetter
    public Object getOnload() {
        if (this instanceof HTMLBodyElement) {
            return this.getWindow().getEventHandler("load");
        }
        return this.getEventHandler("load");
    }

    @JsxSetter
    public void setOnload(Object onload) {
        if (this instanceof HTMLBodyElement) {
            this.getWindow().setEventHandler("load", onload);
            return;
        }
        this.setEventHandler("load", onload);
    }

    @JsxGetter
    public Function getOnloadeddata() {
        return this.getEventHandler("loadeddata");
    }

    @JsxSetter
    public void setOnloadeddata(Object onloadeddata) {
        this.setEventHandler("loadeddata", onloadeddata);
    }

    @JsxGetter
    public Function getOnloadedmetadata() {
        return this.getEventHandler("loadedmetadata");
    }

    @JsxSetter
    public void setOnloadedmetadata(Object onloadedmetadata) {
        this.setEventHandler("loadedmetadata", onloadedmetadata);
    }

    @JsxGetter
    public Function getOnloadstart() {
        return this.getEventHandler("loadstart");
    }

    @JsxSetter
    public void setOnloadstart(Object onloadstart) {
        this.setEventHandler("loadstart", onloadstart);
    }

    @Override
    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Function getOnlostpointercapture() {
        return this.getEventHandler("lostpointercapture");
    }

    @Override
    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnlostpointercapture(Object onlostpointercapture) {
        this.setEventHandler("lostpointercapture", onlostpointercapture);
    }

    @JsxGetter
    public Function getOnmouseenter() {
        return this.getEventHandler("mouseenter");
    }

    @JsxSetter
    public void setOnmouseenter(Object onmouseenter) {
        this.setEventHandler("mouseenter", onmouseenter);
    }

    @JsxGetter
    public Function getOnmouseleave() {
        return this.getEventHandler("mouseleave");
    }

    @JsxSetter
    public void setOnmouseleave(Object onmouseleave) {
        this.setEventHandler("mouseleave", onmouseleave);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.IE})
    public Function getOnmousewheel() {
        return this.getEventHandler("mousewheel");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.IE})
    public void setOnmousewheel(Object onmousewheel) {
        this.setEventHandler("mousewheel", onmousewheel);
    }

    @JsxGetter
    public Function getOnpause() {
        return this.getEventHandler("pause");
    }

    @JsxSetter
    public void setOnpause(Object onpause) {
        this.setEventHandler("pause", onpause);
    }

    @JsxGetter
    public Function getOnplay() {
        return this.getEventHandler("play");
    }

    @JsxSetter
    public void setOnplay(Object onplay) {
        this.setEventHandler("play", onplay);
    }

    @JsxGetter
    public Function getOnplaying() {
        return this.getEventHandler("playing");
    }

    @JsxSetter
    public void setOnplaying(Object onplaying) {
        this.setEventHandler("playing", onplaying);
    }

    @Override
    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public Function getOnpointercancel() {
        return this.getEventHandler("pointercancel");
    }

    @Override
    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public void setOnpointercancel(Object onpointercancel) {
        this.setEventHandler("pointercancel", onpointercancel);
    }

    @Override
    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public Function getOnpointerdown() {
        return this.getEventHandler("pointerdown");
    }

    @Override
    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public void setOnpointerdown(Object onpointerdown) {
        this.setEventHandler("pointerdown", onpointerdown);
    }

    @Override
    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public Function getOnpointerenter() {
        return this.getEventHandler("pointerenter");
    }

    @Override
    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public void setOnpointerenter(Object onpointerenter) {
        this.setEventHandler("pointerenter", onpointerenter);
    }

    @Override
    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public Function getOnpointerleave() {
        return this.getEventHandler("pointerleave");
    }

    @Override
    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public void setOnpointerleave(Object onpointerleave) {
        this.setEventHandler("pointerleave", onpointerleave);
    }

    @Override
    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public Function getOnpointermove() {
        return this.getEventHandler("pointermove");
    }

    @Override
    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public void setOnpointermove(Object onpointermove) {
        this.setEventHandler("pointermove", onpointermove);
    }

    @Override
    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public Function getOnpointerout() {
        return this.getEventHandler("pointerout");
    }

    @Override
    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public void setOnpointerout(Object onpointerout) {
        this.setEventHandler("pointerout", onpointerout);
    }

    @Override
    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public Function getOnpointerover() {
        return this.getEventHandler("pointerover");
    }

    @Override
    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public void setOnpointerover(Object onpointerover) {
        this.setEventHandler("pointerover", onpointerover);
    }

    @Override
    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public Function getOnpointerup() {
        return this.getEventHandler("pointerup");
    }

    @Override
    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public void setOnpointerup(Object onpointerup) {
        this.setEventHandler("pointerup", onpointerup);
    }

    @JsxGetter
    public Function getOnprogress() {
        return this.getEventHandler("progress");
    }

    @JsxSetter
    public void setOnprogress(Object onprogress) {
        this.setEventHandler("progress", onprogress);
    }

    @JsxGetter
    public Function getOnratechange() {
        return this.getEventHandler("ratechange");
    }

    @JsxSetter
    public void setOnratechange(Object onratechange) {
        this.setEventHandler("ratechange", onratechange);
    }

    @JsxGetter
    public Function getOnreset() {
        return this.getEventHandler("reset");
    }

    @JsxSetter
    public void setOnreset(Object onreset) {
        this.setEventHandler("reset", onreset);
    }

    @JsxGetter
    public Function getOnscroll() {
        return this.getEventHandler("scroll");
    }

    @JsxSetter
    public void setOnscroll(Object onscroll) {
        this.setEventHandler("scroll", onscroll);
    }

    @JsxGetter
    public Function getOnseeked() {
        return this.getEventHandler("seeked");
    }

    @JsxSetter
    public void setOnseeked(Object onseeked) {
        this.setEventHandler("seeked", onseeked);
    }

    @JsxGetter
    public Function getOnseeking() {
        return this.getEventHandler("seeking");
    }

    @JsxSetter
    public void setOnseeking(Object onseeking) {
        this.setEventHandler("seeking", onseeking);
    }

    @JsxGetter
    public Function getOnselect() {
        return this.getEventHandler("select");
    }

    @JsxSetter
    public void setOnselect(Object onselect) {
        this.setEventHandler("select", onselect);
    }

    @JsxGetter(value={SupportedBrowser.FF78})
    public Function getOnshow() {
        return this.getEventHandler("show");
    }

    @JsxSetter(value={SupportedBrowser.FF78})
    public void setOnshow(Object onshow) {
        this.setEventHandler("show", onshow);
    }

    @JsxGetter
    public Function getOnstalled() {
        return this.getEventHandler("stalled");
    }

    @JsxSetter
    public void setOnstalled(Object onstalled) {
        this.setEventHandler("stalled", onstalled);
    }

    @JsxGetter
    public Function getOnsuspend() {
        return this.getEventHandler("suspend");
    }

    @JsxSetter
    public void setOnsuspend(Object onsuspend) {
        this.setEventHandler("suspend", onsuspend);
    }

    @JsxGetter
    public Function getOntimeupdate() {
        return this.getEventHandler("timeupdate");
    }

    @JsxSetter
    public void setOntimeupdate(Object ontimeupdate) {
        this.setEventHandler("timeupdate", ontimeupdate);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public Function getOntoggle() {
        return this.getEventHandler("toggle");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public void setOntoggle(Object ontoggle) {
        this.setEventHandler("toggle", ontoggle);
    }

    @JsxGetter
    public Function getOnvolumechange() {
        return this.getEventHandler("volumechange");
    }

    @JsxSetter
    public void setOnvolumechange(Object onvolumechange) {
        this.setEventHandler("volumechange", onvolumechange);
    }

    @JsxGetter
    public Function getOnwaiting() {
        return this.getEventHandler("waiting");
    }

    @JsxSetter
    public void setOnwaiting(Object onwaiting) {
        this.setEventHandler("waiting", onwaiting);
    }

    @JsxGetter
    public Function getOncopy() {
        return this.getEventHandler("copy");
    }

    @JsxSetter
    public void setOncopy(Object oncopy) {
        this.setEventHandler("copy", oncopy);
    }

    @JsxGetter
    public Function getOncut() {
        return this.getEventHandler("cut");
    }

    @JsxSetter
    public void setOncut(Object oncut) {
        this.setEventHandler("cut", oncut);
    }

    @JsxGetter
    public Function getOnpaste() {
        return this.getEventHandler("paste");
    }

    @JsxSetter
    public void setOnpaste(Object onpaste) {
        this.setEventHandler("paste", onpaste);
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF78})
    public Function getOnmozfullscreenchange() {
        return this.getEventHandler("mozfullscreenchange");
    }

    @JsxSetter(value={SupportedBrowser.FF, SupportedBrowser.FF78})
    public void setOnmozfullscreenchange(Object onmozfullscreenchange) {
        this.setEventHandler("mozfullscreenchange", onmozfullscreenchange);
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF78})
    public Function getOnmozfullscreenerror() {
        return this.getEventHandler("mozfullscreenerror");
    }

    @JsxSetter(value={SupportedBrowser.FF, SupportedBrowser.FF78})
    public void setOnmozfullscreenerror(Object onmozfullscreenerror) {
        this.setEventHandler("mozfullscreenerror", onmozfullscreenerror);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnactivate() {
        return this.getEventHandler("activate");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnactivate(Object onactivate) {
        this.setEventHandler("activate", onactivate);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnbeforeactivate() {
        return this.getEventHandler("beforeactivate");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnbeforeactivate(Object onbeforeactivate) {
        this.setEventHandler("beforeactivate", onbeforeactivate);
    }

    @Override
    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnbeforecopy() {
        return this.getEventHandler("beforecopy");
    }

    @Override
    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnbeforecopy(Object onbeforecopy) {
        this.setEventHandler("beforecopy", onbeforecopy);
    }

    @Override
    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnbeforecut() {
        return this.getEventHandler("beforecut");
    }

    @Override
    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnbeforecut(Object onbeforecut) {
        this.setEventHandler("beforecut", onbeforecut);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnbeforedeactivate() {
        return this.getEventHandler("beforedeactivate");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnbeforedeactivate(Object onbeforedeactivate) {
        this.setEventHandler("beforedeactivate", onbeforedeactivate);
    }

    @Override
    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnbeforepaste() {
        return this.getEventHandler("beforepaste");
    }

    @Override
    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnbeforepaste(Object onbeforepaste) {
        this.setEventHandler("beforepaste", onbeforepaste);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOndeactivate() {
        return this.getEventHandler("deactivate");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOndeactivate(Object ondeactivate) {
        this.setEventHandler("deactivate", ondeactivate);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnhelp() {
        return this.getEventHandler("help");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnhelp(Object onhelp) {
        this.setEventHandler("help", onhelp);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmscontentzoom() {
        return this.getEventHandler("mscontentzoom");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmscontentzoom(Object onmscontentzoom) {
        this.setEventHandler("mscontentzoom", onmscontentzoom);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmsmanipulationstatechanged() {
        return this.getEventHandler("msmanipulationstatechanged");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmsmanipulationstatechanged(Object onmsmanipulationstatechanged) {
        this.setEventHandler("msmanipulationstatechanged", onmsmanipulationstatechanged);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.IE})
    public Function getOnselectstart() {
        return this.getEventHandler("selectstart");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.IE})
    public void setOnselectstart(Object onselectstart) {
        this.setEventHandler("selectstart", onselectstart);
    }

    public String getName() {
        return this.getDomNodeOrDie().getAttributeDirect("name");
    }

    public void setName(String newName) {
        this.getDomNodeOrDie().setAttribute("name", newName);
    }

    public Object getValue() {
        return this.getDomNodeOrDie().getAttributeDirect("value");
    }

    public void setValue(Object newValue) {
        this.getDomNodeOrDie().setAttribute("value", Context.toString((Object)newValue));
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF78})
    public Function getOnanimationcancel() {
        return this.getEventHandler("animationcancel");
    }

    @JsxSetter(value={SupportedBrowser.FF, SupportedBrowser.FF78})
    public void setOnanimationcancel(Object onanimationcancel) {
        this.setEventHandler("animationcancel", onanimationcancel);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public Function getOnanimationend() {
        return this.getEventHandler("animationend");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public void setOnanimationend(Object onanimationend) {
        this.setEventHandler("animationend", onanimationend);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public Function getOnanimationiteration() {
        return this.getEventHandler("animationiteration");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public void setOnanimationiteration(Object onanimationiteration) {
        this.setEventHandler("animationiteration", onanimationiteration);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public Function getOnanimationstart() {
        return this.getEventHandler("animationstart");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public void setOnanimationstart(Object onanimationstart) {
        this.setEventHandler("animationstart", onanimationstart);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Function getOnselectionchange() {
        return this.getEventHandler("selectionchange");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnselectionchange(Object onselectionchange) {
        this.setEventHandler("selectionchange", onselectionchange);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public Function getOntransitioncancel() {
        return this.getEventHandler("ontransitioncancel");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public void setOntransitioncancel(Object ontransitioncancel) {
        this.setEventHandler("ontransitioncancel", ontransitioncancel);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public Function getOntransitionend() {
        return this.getEventHandler("ontransitionend");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public void setOntransitionend(Object ontransitionend) {
        this.setEventHandler("ontransitionend", ontransitionend);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public Function getOntransitionrun() {
        return this.getEventHandler("ontransitionrun");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public void setOntransitionrun(Object ontransitionrun) {
        this.setEventHandler("ontransitionrun", ontransitionrun);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public Function getOntransitionstart() {
        return this.getEventHandler("ontransitionstart");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public void setOntransitionstart(Object ontransitionstart) {
        this.setEventHandler("ontransitionstart", ontransitionstart);
    }

    static {
        COLORS_MAP_IE.put("AliceBlue", "#F0F8FF");
        COLORS_MAP_IE.put("AntiqueWhite", "#FAEBD7");
        COLORS_MAP_IE.put("Aqua", "#00FFFF");
        COLORS_MAP_IE.put("Aquamarine", "#7FFFD4");
        COLORS_MAP_IE.put("Azure", "#F0FFFF");
        COLORS_MAP_IE.put("Beige", "#F5F5DC");
        COLORS_MAP_IE.put("Bisque", "#FFE4C4");
        COLORS_MAP_IE.put("Black", "#000000");
        COLORS_MAP_IE.put("BlanchedAlmond", "#FFEBCD");
        COLORS_MAP_IE.put("Blue", "#0000FF");
        COLORS_MAP_IE.put("BlueViolet", "#8A2BE2");
        COLORS_MAP_IE.put("Brown", "#A52A2A");
        COLORS_MAP_IE.put("BurlyWood", "#DEB887");
        COLORS_MAP_IE.put("CadetBlue", "#5F9EA0");
        COLORS_MAP_IE.put("Chartreuse", "#7FFF00");
        COLORS_MAP_IE.put("Chocolate", "#D2691E");
        COLORS_MAP_IE.put("Coral", "#FF7F50");
        COLORS_MAP_IE.put("CornflowerBlue", "#6495ED");
        COLORS_MAP_IE.put("Cornsilk", "#FFF8DC");
        COLORS_MAP_IE.put("Crimson", "#DC143C");
        COLORS_MAP_IE.put("Cyan", "#00FFFF");
        COLORS_MAP_IE.put("DarkBlue", "#00008B");
        COLORS_MAP_IE.put("DarkCyan", "#008B8B");
        COLORS_MAP_IE.put("DarkGoldenrod", "#B8860B");
        COLORS_MAP_IE.put("DarkGray", "#A9A9A9");
        COLORS_MAP_IE.put("DarkGrey", "#A9A9A9");
        COLORS_MAP_IE.put("DarkGreen", "#006400");
        COLORS_MAP_IE.put("DarkKhaki", "#BDB76B");
        COLORS_MAP_IE.put("DarkMagenta", "#8B008B");
        COLORS_MAP_IE.put("DarkOliveGreen", "#556B2F");
        COLORS_MAP_IE.put("DarkOrange", "#FF8C00");
        COLORS_MAP_IE.put("DarkOrchid", "#9932CC");
        COLORS_MAP_IE.put("DarkRed", "#8B0000");
        COLORS_MAP_IE.put("DarkSalmon", "#E9967A");
        COLORS_MAP_IE.put("DarkSeaGreen", "#8FBC8F");
        COLORS_MAP_IE.put("DarkSlateBlue", "#483D8B");
        COLORS_MAP_IE.put("DarkSlateGray", "#2F4F4F");
        COLORS_MAP_IE.put("DarkSlateGrey", "#2F4F4F");
        COLORS_MAP_IE.put("DarkTurquoise", "#00CED1");
        COLORS_MAP_IE.put("DarkViolet", "#9400D3");
        COLORS_MAP_IE.put("DeepPink", "#FF1493");
        COLORS_MAP_IE.put("DeepSkyBlue", "#00BFFF");
        COLORS_MAP_IE.put("DimGray", "#696969");
        COLORS_MAP_IE.put("DimGrey", "#696969");
        COLORS_MAP_IE.put("DodgerBlue", "#1E90FF");
        COLORS_MAP_IE.put("FireBrick", "#B22222");
        COLORS_MAP_IE.put("FloralWhite", "#FFFAF0");
        COLORS_MAP_IE.put("ForestGreen", "#228B22");
        COLORS_MAP_IE.put("Fuchsia", "#FF00FF");
        COLORS_MAP_IE.put("Gainsboro", "#DCDCDC");
        COLORS_MAP_IE.put("GhostWhite", "#F8F8FF");
        COLORS_MAP_IE.put("Gold", "#FFD700");
        COLORS_MAP_IE.put("Goldenrod", "#DAA520");
        COLORS_MAP_IE.put("Gray", "#808080");
        COLORS_MAP_IE.put("Grey", "#808080");
        COLORS_MAP_IE.put("Green", "#008000");
        COLORS_MAP_IE.put("GreenYellow", "#ADFF2F");
        COLORS_MAP_IE.put("Honeydew", "#F0FFF0");
        COLORS_MAP_IE.put("HotPink", "#FF69B4");
        COLORS_MAP_IE.put("IndianRed", "#CD5C5C");
        COLORS_MAP_IE.put("Indigo", "#4B0082");
        COLORS_MAP_IE.put("Ivory", "#FFFFF0");
        COLORS_MAP_IE.put("Khaki", "#F0E68C");
        COLORS_MAP_IE.put("Lavender", "#E6E6FA");
        COLORS_MAP_IE.put("LavenderBlush", "#FFF0F5");
        COLORS_MAP_IE.put("LawnGreen", "#7CFC00");
        COLORS_MAP_IE.put("LemonChiffon", "#FFFACD");
        COLORS_MAP_IE.put("LightBlue", "#ADD8E6");
        COLORS_MAP_IE.put("LightCoral", "#F08080");
        COLORS_MAP_IE.put("LightCyan", "#E0FFFF");
        COLORS_MAP_IE.put("LightGoldenrodYellow", "#FAFAD2");
        COLORS_MAP_IE.put("LightGreen", "#90EE90");
        COLORS_MAP_IE.put("LightGray", "#D3D3D3");
        COLORS_MAP_IE.put("LightGrey", "#D3D3D3");
        COLORS_MAP_IE.put("LightPink", "#FFB6C1");
        COLORS_MAP_IE.put("LightSalmon", "#FFA07A");
        COLORS_MAP_IE.put("LightSeaGreen", "#20B2AA");
        COLORS_MAP_IE.put("LightSkyBlue", "#87CEFA");
        COLORS_MAP_IE.put("LightSlateGray", "#778899");
        COLORS_MAP_IE.put("LightSlateGrey", "#778899");
        COLORS_MAP_IE.put("LightSteelBlue", "#B0C4DE");
        COLORS_MAP_IE.put("LightYellow", "#FFFFE0");
        COLORS_MAP_IE.put("Lime", "#00FF00");
        COLORS_MAP_IE.put("LimeGreen", "#32CD32");
        COLORS_MAP_IE.put("Linen", "#FAF0E6");
        COLORS_MAP_IE.put("Magenta", "#FF00FF");
        COLORS_MAP_IE.put("Maroon", "#800000");
        COLORS_MAP_IE.put("MediumAquamarine", "#66CDAA");
        COLORS_MAP_IE.put("MediumBlue", "#0000CD");
        COLORS_MAP_IE.put("MediumOrchid", "#BA55D3");
        COLORS_MAP_IE.put("MediumPurple", "#9370DB");
        COLORS_MAP_IE.put("MediumSeaGreen", "#3CB371");
        COLORS_MAP_IE.put("MediumSlateBlue", "#7B68EE");
        COLORS_MAP_IE.put("MediumSpringGreen", "#00FA9A");
        COLORS_MAP_IE.put("MediumTurquoise", "#48D1CC");
        COLORS_MAP_IE.put("MediumVioletRed", "#C71585");
        COLORS_MAP_IE.put("MidnightBlue", "#191970");
        COLORS_MAP_IE.put("MintCream", "#F5FFFA");
        COLORS_MAP_IE.put("MistyRose", "#FFE4E1");
        COLORS_MAP_IE.put("Moccasin", "#FFE4B5");
        COLORS_MAP_IE.put("NavajoWhite", "#FFDEAD");
        COLORS_MAP_IE.put("Navy", "#000080");
        COLORS_MAP_IE.put("OldLace", "#FDF5E6");
        COLORS_MAP_IE.put("Olive", "#808000");
        COLORS_MAP_IE.put("OliveDrab", "#6B8E23");
        COLORS_MAP_IE.put("Orange", "#FFA500");
        COLORS_MAP_IE.put("OrangeRed", "#FF6000");
        COLORS_MAP_IE.put("Orchid", "#DA70D6");
        COLORS_MAP_IE.put("PaleGoldenrod", "#EEE8AA");
        COLORS_MAP_IE.put("PaleGreen", "#98FB98");
        COLORS_MAP_IE.put("PaleTurquoise", "#AFEEEE");
        COLORS_MAP_IE.put("PaleVioletRed", "#DB7093");
        COLORS_MAP_IE.put("PapayaWhip", "#FFEFD5");
        COLORS_MAP_IE.put("PeachPuff", "#FFDAB9");
        COLORS_MAP_IE.put("Peru", "#CD853F");
        COLORS_MAP_IE.put("Pink", "#FFC0CB");
        COLORS_MAP_IE.put("Plum", "#DDA0DD");
        COLORS_MAP_IE.put("PowderBlue", "#B0E0E6");
        COLORS_MAP_IE.put("Purple", "#800080");
        COLORS_MAP_IE.put("Red", "#FF0000");
        COLORS_MAP_IE.put("RosyBrown", "#BC8F8F");
        COLORS_MAP_IE.put("RoyalBlue", "#4169E1");
        COLORS_MAP_IE.put("SaddleBrown", "#8B4513");
        COLORS_MAP_IE.put("Salmon", "#FA8072");
        COLORS_MAP_IE.put("SandyBrown", "#F4A460");
        COLORS_MAP_IE.put("SeaGreen", "#2E8B57");
        COLORS_MAP_IE.put("Seashell", "#FFF5EE");
        COLORS_MAP_IE.put("Sienna", "#A0522D");
        COLORS_MAP_IE.put("Silver", "#C0C0C0");
        COLORS_MAP_IE.put("SkyBlue", "#87CEEB");
        COLORS_MAP_IE.put("SlateBlue", "#6A5ACD");
        COLORS_MAP_IE.put("SlateGray", "#708090");
        COLORS_MAP_IE.put("SlateGrey", "#708090");
        COLORS_MAP_IE.put("Snow", "#FFFAFA");
        COLORS_MAP_IE.put("SpringGreen", "#00FF7F");
        COLORS_MAP_IE.put("SteelBlue", "#4682B4");
        COLORS_MAP_IE.put("Tan", "#D2B48C");
        COLORS_MAP_IE.put("Teal", "#008080");
        COLORS_MAP_IE.put("Thistle", "#D8BFD8");
        COLORS_MAP_IE.put("Tomato", "#FF6347");
        COLORS_MAP_IE.put("Turquoise", "#40E0D0");
        COLORS_MAP_IE.put("Violet", "#EE82EE");
        COLORS_MAP_IE.put("Wheat", "#F5DEB3");
        COLORS_MAP_IE.put("White", "#FFFFFF");
        COLORS_MAP_IE.put("WhiteSmoke", "#F5F5F5");
        COLORS_MAP_IE.put("Yellow", "#FFFF00");
        COLORS_MAP_IE.put("YellowGreen", "#9ACD32");
    }

    public static class ProxyDomNode
    extends HtmlDivision {
        private final DomNode target_;
        private final boolean append_;

        public ProxyDomNode(SgmlPage page, DomNode target, boolean append) {
            super("div", page, null);
            this.target_ = target;
            this.append_ = append;
        }

        @Override
        public DomNode appendChild(org.w3c.dom.Node node) {
            DomNode domNode = (DomNode)node;
            if (this.append_) {
                return this.target_.appendChild(domNode);
            }
            this.target_.insertBefore(domNode);
            return domNode;
        }

        public DomNode getDomNode() {
            return this.target_;
        }

        public boolean isAppend() {
            return this.append_;
        }
    }
}

