/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlArea;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlMap;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.PostponedAction;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Document;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HtmlImage
extends HtmlElement {
    private static final Log LOG = LogFactory.getLog(HtmlImage.class);
    public static final String TAG_NAME = "img";
    public static final String TAG_NAME2 = "image";
    private final String originalQualifiedName_;
    private int lastClickX_;
    private int lastClickY_;
    private WebResponse imageWebResponse_;
    private transient ImageData imageData_;
    private int width_;
    private int height_;
    private boolean downloaded_;
    private boolean isComplete_;
    private boolean onloadProcessed_;
    private boolean createdByJavascript_;

    HtmlImage(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        block3: {
            super(HtmlImage.unifyLocalName(qualifiedName), page, attributes);
            this.width_ = -1;
            this.height_ = -1;
            this.originalQualifiedName_ = qualifiedName;
            if (page.getWebClient().getOptions().isDownloadImages()) {
                try {
                    this.downloadImageIfNeeded();
                }
                catch (IOException e) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug((Object)("Unable to download image for element " + this));
                }
            }
        }
    }

    private static String unifyLocalName(String qualifiedName) {
        if (qualifiedName != null && qualifiedName.endsWith(TAG_NAME2)) {
            int pos = qualifiedName.lastIndexOf(TAG_NAME2);
            return qualifiedName.substring(0, pos) + TAG_NAME;
        }
        return qualifiedName;
    }

    @Override
    protected void onAddedToPage() {
        this.doOnLoad();
        super.onAddedToPage();
    }

    @Override
    protected void setAttributeNS(String namespaceURI, String qualifiedName, String value, boolean notifyAttributeChangeListeners, boolean notifyMutationObservers) {
        String oldValue;
        HtmlPage htmlPage = this.getHtmlPageOrNull();
        if ("src".equals(qualifiedName) && value != ATTRIBUTE_NOT_DEFINED && htmlPage != null && !(oldValue = this.getAttributeNS(namespaceURI, qualifiedName)).equals(value)) {
            String readyState;
            super.setAttributeNS(namespaceURI, qualifiedName, value, notifyAttributeChangeListeners, notifyMutationObservers);
            this.onloadProcessed_ = false;
            this.downloaded_ = false;
            this.isComplete_ = false;
            this.width_ = -1;
            this.height_ = -1;
            if (this.imageData_ != null) {
                this.imageData_.close();
                this.imageData_ = null;
            }
            if ("loading".equals(readyState = htmlPage.getReadyState())) {
                PostponedAction action = new PostponedAction(this.getPage(), "HtmlImage.setAttributeNS"){

                    @Override
                    public void execute() throws Exception {
                        HtmlImage.this.doOnLoad();
                    }
                };
                htmlPage.addAfterLoadAction(action);
                return;
            }
            this.doOnLoad();
            return;
        }
        super.setAttributeNS(namespaceURI, qualifiedName, value, notifyAttributeChangeListeners, notifyMutationObservers);
    }

    @Override
    public void processImportNode(Document doc) {
        block11: {
            URL oldUrl = null;
            String src = this.getSrcAttribute();
            HtmlPage htmlPage = this.getHtmlPageOrNull();
            try {
                if (htmlPage != null) {
                    oldUrl = htmlPage.getFullyQualifiedUrl(src);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            super.processImportNode(doc);
            URL url = null;
            htmlPage = this.getHtmlPageOrNull();
            try {
                if (htmlPage != null) {
                    url = htmlPage.getFullyQualifiedUrl(src);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (oldUrl == null || !UrlUtils.sameFile(oldUrl, url)) {
                this.lastClickX_ = 0;
                this.lastClickY_ = 0;
                this.imageWebResponse_ = null;
                this.imageData_ = null;
                this.width_ = -1;
                this.height_ = -1;
                this.downloaded_ = false;
                this.isComplete_ = false;
                this.onloadProcessed_ = false;
                this.createdByJavascript_ = true;
            }
            if (htmlPage == null) {
                return;
            }
            if (htmlPage.getWebClient().getOptions().isDownloadImages()) {
                try {
                    this.downloadImageIfNeeded();
                }
                catch (IOException e) {
                    if (!LOG.isDebugEnabled()) break block11;
                    LOG.debug((Object)("Unable to download image for element " + this));
                }
            }
        }
    }

    public void doOnLoad() {
        boolean hasEventHandler;
        if (this.onloadProcessed_) {
            return;
        }
        HtmlPage htmlPage = this.getHtmlPageOrNull();
        if (htmlPage == null) {
            return;
        }
        WebClient client = htmlPage.getWebClient();
        boolean bl = hasEventHandler = this.hasEventHandlers("onload") || this.hasEventHandlers("onerror");
        if ((hasEventHandler && client.isJavaScriptEnabled() || client.getOptions().isDownloadImages()) && this.hasAttribute("src")) {
            boolean loadSuccessful;
            block14: {
                boolean tryDownload;
                loadSuccessful = false;
                if (this.hasFeature(BrowserVersionFeatures.HTMLIMAGE_BLANK_SRC_AS_EMPTY)) {
                    tryDownload = !StringUtils.isBlank((CharSequence)this.getSrcAttribute());
                } else {
                    boolean bl2 = tryDownload = !this.getSrcAttribute().isEmpty();
                }
                if (tryDownload) {
                    try {
                        this.downloadImageIfNeeded();
                        int i = this.imageWebResponse_.getStatusCode();
                        if (i >= 200 && i < 300 || i == 305) {
                            loadSuccessful = true;
                        }
                    }
                    catch (IOException e) {
                        if (!LOG.isDebugEnabled()) break block14;
                        LOG.debug((Object)("IOException while downloading image for '" + this + "' : " + e.getMessage()));
                    }
                }
            }
            if (!client.isJavaScriptEnabled()) {
                this.onloadProcessed_ = true;
                return;
            }
            if (!hasEventHandler) {
                return;
            }
            this.onloadProcessed_ = true;
            final Event event = new Event(this, loadSuccessful ? "load" : "error");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Firing the " + event.getType() + " event for '" + this + "'."));
            }
            if ("loading".equals(htmlPage.getReadyState())) {
                PostponedAction action = new PostponedAction(this.getPage(), "HtmlImage.doOnLoad"){

                    @Override
                    public void execute() throws Exception {
                        HtmlImage.this.fireEvent(event);
                    }
                };
                htmlPage.addAfterLoadAction(action);
            } else {
                this.fireEvent(event);
            }
        }
    }

    public final String getSrcAttribute() {
        return this.getSrcAttributeNormalized();
    }

    public String getSrc() {
        String src = this.getSrcAttribute();
        if ("".equals(src)) {
            return src;
        }
        try {
            HtmlPage page = (HtmlPage)this.getPage();
            return page.getFullyQualifiedUrl(src).toExternalForm();
        }
        catch (MalformedURLException e) {
            String msg = "Unable to create fully qualified URL for src attribute of image " + e.getMessage();
            throw new RuntimeException(msg, e);
        }
    }

    public final String getAltAttribute() {
        return this.getAttributeDirect("alt");
    }

    public final String getNameAttribute() {
        return this.getAttributeDirect("name");
    }

    public final String getLongDescAttribute() {
        return this.getAttributeDirect("longdesc");
    }

    public final String getHeightAttribute() {
        return this.getAttributeDirect("height");
    }

    public final String getWidthAttribute() {
        return this.getAttributeDirect("width");
    }

    public final String getUseMapAttribute() {
        return this.getAttributeDirect("usemap");
    }

    public final String getIsmapAttribute() {
        return this.getAttributeDirect("ismap");
    }

    public final String getAlignAttribute() {
        return this.getAttributeDirect("align");
    }

    public final String getBorderAttribute() {
        return this.getAttributeDirect("border");
    }

    public final String getHspaceAttribute() {
        return this.getAttributeDirect("hspace");
    }

    public final String getVspaceAttribute() {
        return this.getAttributeDirect("vspace");
    }

    public int getHeight() throws IOException {
        if (this.height_ < 0) {
            this.determineWidthAndHeight();
        }
        return this.height_;
    }

    public int getHeightOrDefault() {
        String src;
        String height = this.getHeightAttribute();
        if (ATTRIBUTE_NOT_DEFINED != height) {
            try {
                return Integer.parseInt(height);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (ATTRIBUTE_NOT_DEFINED == (src = this.getSrcAttribute())) {
            BrowserVersion browserVersion = ((HtmlPage)this.getPage()).getWebClient().getBrowserVersion();
            if (browserVersion.hasFeature(BrowserVersionFeatures.JS_IMAGE_WIDTH_HEIGHT_RETURNS_28x30_28x30)) {
                return 30;
            }
            if (browserVersion.hasFeature(BrowserVersionFeatures.JS_IMAGE_WIDTH_HEIGHT_RETURNS_16x16_0x0) || browserVersion.hasFeature(BrowserVersionFeatures.JS_IMAGE_WIDTH_HEIGHT_RETURNS_24x24_0x0)) {
                return 0;
            }
            return 24;
        }
        WebClient webClient = ((HtmlPage)this.getPage()).getWebClient();
        BrowserVersion browserVersion = webClient.getBrowserVersion();
        if (browserVersion.hasFeature(BrowserVersionFeatures.JS_IMAGE_WIDTH_HEIGHT_EMPTY_SOURCE_RETURNS_0x0) && StringUtils.isEmpty((CharSequence)src)) {
            return 0;
        }
        if (browserVersion.hasFeature(BrowserVersionFeatures.JS_IMAGE_WIDTH_HEIGHT_RETURNS_16x16_0x0) && StringUtils.isBlank((CharSequence)src)) {
            return 0;
        }
        try {
            return this.getHeight();
        }
        catch (IOException e) {
            if (browserVersion.hasFeature(BrowserVersionFeatures.JS_IMAGE_WIDTH_HEIGHT_RETURNS_28x30_28x30)) {
                return 30;
            }
            if (browserVersion.hasFeature(BrowserVersionFeatures.JS_IMAGE_WIDTH_HEIGHT_RETURNS_16x16_0x0)) {
                return 16;
            }
            return 24;
        }
    }

    public int getWidth() throws IOException {
        if (this.width_ < 0) {
            this.determineWidthAndHeight();
        }
        return this.width_;
    }

    public int getWidthOrDefault() {
        String src;
        String widthAttrib = this.getWidthAttribute();
        if (ATTRIBUTE_NOT_DEFINED != widthAttrib) {
            try {
                return Integer.parseInt(widthAttrib);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (ATTRIBUTE_NOT_DEFINED == (src = this.getSrcAttribute())) {
            BrowserVersion browserVersion = ((HtmlPage)this.getPage()).getWebClient().getBrowserVersion();
            if (browserVersion.hasFeature(BrowserVersionFeatures.JS_IMAGE_WIDTH_HEIGHT_RETURNS_28x30_28x30)) {
                return 28;
            }
            if (browserVersion.hasFeature(BrowserVersionFeatures.JS_IMAGE_WIDTH_HEIGHT_RETURNS_16x16_0x0) || browserVersion.hasFeature(BrowserVersionFeatures.JS_IMAGE_WIDTH_HEIGHT_RETURNS_24x24_0x0)) {
                return 0;
            }
            return 24;
        }
        WebClient webClient = ((HtmlPage)this.getPage()).getWebClient();
        BrowserVersion browserVersion = webClient.getBrowserVersion();
        if (browserVersion.hasFeature(BrowserVersionFeatures.JS_IMAGE_WIDTH_HEIGHT_EMPTY_SOURCE_RETURNS_0x0) && StringUtils.isEmpty((CharSequence)src)) {
            return 0;
        }
        if (browserVersion.hasFeature(BrowserVersionFeatures.JS_IMAGE_WIDTH_HEIGHT_RETURNS_16x16_0x0) && StringUtils.isBlank((CharSequence)src)) {
            return 0;
        }
        try {
            return this.getWidth();
        }
        catch (IOException e) {
            if (browserVersion.hasFeature(BrowserVersionFeatures.JS_IMAGE_WIDTH_HEIGHT_RETURNS_28x30_28x30)) {
                return 28;
            }
            if (browserVersion.hasFeature(BrowserVersionFeatures.JS_IMAGE_WIDTH_HEIGHT_RETURNS_16x16_0x0)) {
                return 16;
            }
            return 24;
        }
    }

    public ImageReader getImageReader() throws IOException {
        this.readImageIfNeeded();
        return this.imageData_.getImageReader();
    }

    private void determineWidthAndHeight() throws IOException {
        ImageReader imgReader = this.getImageReader();
        this.width_ = imgReader.getWidth(0);
        this.height_ = imgReader.getHeight(0);
        if (this.imageData_ != null) {
            this.imageData_.close();
            this.imageData_ = null;
        }
    }

    public WebResponse getWebResponse(boolean downloadIfNeeded) throws IOException {
        if (downloadIfNeeded) {
            this.downloadImageIfNeeded();
        }
        return this.imageWebResponse_;
    }

    private void downloadImageIfNeeded() throws IOException {
        if (!this.downloaded_) {
            HtmlPage page;
            WebClient webClient;
            BrowserVersion browser;
            String src = this.getSrcAttribute();
            if (!("".equals(src) || (browser = (webClient = (page = (HtmlPage)this.getPage()).getWebClient()).getBrowserVersion()).hasFeature(BrowserVersionFeatures.HTMLIMAGE_BLANK_SRC_AS_EMPTY) && StringUtils.isBlank((CharSequence)src))) {
                URL url = page.getFullyQualifiedUrl(src);
                WebRequest request = new WebRequest(url, browser.getImgAcceptHeader(), browser.getAcceptEncodingHeader());
                request.setCharset(page.getCharset());
                request.setRefererlHeader(page.getUrl());
                this.imageWebResponse_ = webClient.loadWebResponse(request);
            }
            if (this.imageData_ != null) {
                this.imageData_.close();
                this.imageData_ = null;
            }
            this.downloaded_ = true;
            this.isComplete_ = this.hasFeature(BrowserVersionFeatures.JS_IMAGE_COMPLETE_RETURNS_TRUE_FOR_NO_REQUEST) || this.imageWebResponse_ != null && this.imageWebResponse_.getContentType().contains(TAG_NAME2);
            this.width_ = -1;
            this.height_ = -1;
        }
    }

    private void readImageIfNeeded() throws IOException {
        this.downloadImageIfNeeded();
        if (this.imageData_ == null) {
            if (null == this.imageWebResponse_) {
                throw new IOException("No image response available (src='" + this.getSrcAttribute() + "')");
            }
            ImageInputStream iis = ImageIO.createImageInputStream(this.imageWebResponse_.getContentAsStream());
            Iterator<ImageReader> iter = ImageIO.getImageReaders(iis);
            if (!iter.hasNext()) {
                iis.close();
                throw new IOException("No image detected in response");
            }
            ImageReader imageReader = iter.next();
            imageReader.setInput(iis);
            this.imageData_ = new ImageData(imageReader);
            while (iter.hasNext()) {
                iter.next().dispose();
            }
        }
    }

    public Page click(int x, int y) throws IOException {
        this.lastClickX_ = x;
        this.lastClickY_ = y;
        return super.click();
    }

    public Page click() throws IOException {
        return this.click(0, 0);
    }

    @Override
    protected boolean doClickStateUpdate(boolean shiftKey, boolean ctrlKey) throws IOException {
        HtmlAnchor anchor;
        if (ATTRIBUTE_NOT_DEFINED != this.getUseMapAttribute()) {
            String mapName = this.getUseMapAttribute().substring(1);
            HtmlElement doc = ((HtmlPage)this.getPage()).getDocumentElement();
            HtmlMap map = (HtmlMap)doc.getOneHtmlElementByAttribute("map", "name", mapName);
            for (DomElement element : map.getChildElements()) {
                HtmlArea area;
                if (!(element instanceof HtmlArea) || !(area = (HtmlArea)element).containsPoint(this.lastClickX_, this.lastClickY_)) continue;
                area.doClickStateUpdate(shiftKey, ctrlKey);
                return false;
            }
        }
        if ((anchor = (HtmlAnchor)this.getEnclosingElement("a")) == null) {
            return false;
        }
        if (ATTRIBUTE_NOT_DEFINED != this.getIsmapAttribute()) {
            String suffix = "?" + this.lastClickX_ + "," + this.lastClickY_;
            anchor.doClickStateUpdate(false, false, suffix);
            return false;
        }
        anchor.doClickStateUpdate(shiftKey, ctrlKey);
        return false;
    }

    public void saveAs(File file) throws IOException {
        this.downloadImageIfNeeded();
        if (null != this.imageWebResponse_) {
            try (OutputStream fos = Files.newOutputStream(file.toPath(), new OpenOption[0]);
                 InputStream inputStream = this.imageWebResponse_.getContentAsStream();){
                IOUtils.copy((InputStream)inputStream, (OutputStream)fos);
            }
        }
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        return HtmlElement.DisplayStyle.INLINE;
    }

    public boolean isComplete() {
        return this.isComplete_ || (this.hasFeature(BrowserVersionFeatures.JS_IMAGE_COMPLETE_RETURNS_TRUE_FOR_NO_REQUEST) ? ATTRIBUTE_NOT_DEFINED == this.getSrcAttribute() : this.imageData_ != null);
    }

    @Override
    public boolean isDisplayed() {
        String src = this.getSrcAttribute();
        if (this.hasFeature(BrowserVersionFeatures.HTMLIMAGE_INVISIBLE_NO_SRC)) {
            if (ATTRIBUTE_NOT_DEFINED == src) {
                return false;
            }
            if (this.hasFeature(BrowserVersionFeatures.HTMLIMAGE_BLANK_SRC_AS_EMPTY) && StringUtils.isBlank((CharSequence)src)) {
                return false;
            }
            if (this.hasFeature(BrowserVersionFeatures.HTMLIMAGE_EMPTY_SRC_DISPLAY_FALSE) && StringUtils.isEmpty((CharSequence)src)) {
                return false;
            }
        }
        return super.isDisplayed();
    }

    public void markAsCreatedByJavascript() {
        this.createdByJavascript_ = true;
    }

    public boolean wasCreatedByJavascript() {
        return this.createdByJavascript_;
    }

    public String getOriginalQualifiedName() {
        return this.originalQualifiedName_;
    }

    @Override
    public String getLocalName() {
        if (this.wasCreatedByJavascript() && (this.hasFeature(BrowserVersionFeatures.HTMLIMAGE_HTMLELEMENT) || this.hasFeature(BrowserVersionFeatures.HTMLIMAGE_HTMLUNKNOWNELEMENT))) {
            return this.originalQualifiedName_;
        }
        return super.getLocalName();
    }

    static final class ImageData
    implements AutoCloseable {
        private final ImageReader imageReader_;

        ImageData(ImageReader imageReader) {
            this.imageReader_ = imageReader;
        }

        public ImageReader getImageReader() {
            return this.imageReader_;
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (this.imageReader_ != null) {
                try {
                    ImageInputStream stream = (ImageInputStream)this.imageReader_.getInput();
                    Throwable throwable = null;
                    if (stream != null) {
                        if (throwable != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        } else {
                            stream.close();
                        }
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
                finally {
                    this.imageReader_.setInput(null);
                    this.imageReader_.dispose();
                }
            }
        }
    }
}

