/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.css.dom.AbstractCSSRuleImpl;
import com.gargoylesoftware.css.dom.CSSPageRuleImpl;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSRule;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleSheet;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

@JsxClass
public class CSSPageRule
extends CSSRule {
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public CSSPageRule() {
    }

    protected CSSPageRule(CSSStyleSheet stylesheet, CSSPageRuleImpl rule) {
        super(stylesheet, (AbstractCSSRuleImpl)rule);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.IE})
    public String getSelectorText() {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_PAGERULE_SELECTORTEXT_EMPTY)) {
            return "";
        }
        String selectorText = this.getPageRule().getSelectorText();
        if (selectorText != null) {
            return selectorText.toLowerCase(Locale.ROOT);
        }
        return null;
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setSelectorText(String selectorText) {
    }

    @JsxGetter
    public CSSStyleDeclaration getStyle() {
        return new CSSStyleDeclaration(this.getParentScope(), this.getPageRule().getStyle());
    }

    private CSSPageRuleImpl getPageRule() {
        return (CSSPageRuleImpl)this.getRule();
    }

    @Override
    public String getCssText() {
        String cssText = super.getCssText();
        BrowserVersion browserVersion = this.getBrowserVersion();
        if (browserVersion.hasFeature(BrowserVersionFeatures.CSS_CSSTEXT_IE_STYLE)) {
            cssText = StringUtils.replace((String)cssText, (String)" { }", (String)"  {\n\t\n}");
            cssText = StringUtils.replace((String)cssText, (String)" { ", (String)"  {\n\t");
            cssText = StringUtils.replace((String)cssText, (String)"; }", (String)";\n}");
        }
        return cssText;
    }
}

