/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlArea;
import com.gargoylesoftware.htmlunit.html.HtmlMap;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import java.util.ArrayList;
import java.util.List;

@JsxClass(domClass=HtmlMap.class)
public class HTMLMapElement
extends HTMLElement {
    private HTMLCollection areas_;

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public HTMLMapElement() {
    }

    @JsxGetter
    public HTMLCollection getAreas() {
        if (this.areas_ == null) {
            final HtmlMap map = (HtmlMap)this.getDomNodeOrDie();
            this.areas_ = new HTMLCollection(map, false){

                @Override
                protected List<DomNode> computeElements() {
                    ArrayList<DomNode> list = new ArrayList<DomNode>();
                    for (DomNode domNode : map.getChildElements()) {
                        if (!(domNode instanceof HtmlArea)) continue;
                        list.add(domNode);
                    }
                    return list;
                }
            };
        }
        return this.areas_;
    }

    @Override
    @JsxGetter
    public String getName() {
        return this.getDomNodeOrDie().getAttributeDirect("name");
    }

    @Override
    @JsxSetter
    public void setName(String name) {
        this.getDomNodeOrDie().setAttribute("name", name);
    }
}

